/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import visad.ActivityHandler;
import visad.DisplayImpl;
import visad.VisADException;

public class DisplayActivity {
    private static final int DEFAULT_IDLE_MILLISECONDS = 250;
    private static final boolean DEBUG = false;
    private transient DisplayImpl dpy;
    private int interval;
    private long lastBusyEvt;
    private boolean isBusy;
    private transient Timer busyTimer;
    private transient BusyAction busyAction;
    private transient ArrayList handlerList;

    public DisplayActivity(DisplayImpl dpy) {
        this(dpy, 250);
    }

    public DisplayActivity(DisplayImpl dpy, int milliseconds) {
        this.dpy = dpy;
        this.interval = milliseconds < 100 ? 100 : milliseconds;
        this.lastBusyEvt = System.currentTimeMillis() - (long)this.interval;
        this.isBusy = false;
        this.busyAction = new BusyAction();
        this.busyTimer = new Timer(this.interval, this.busyAction);
        this.busyTimer.removeActionListener(this.busyAction);
        this.busyAction = null;
        this.handlerList = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Timer timer = this.busyTimer;
        synchronized (timer) {
            if (this.busyAction != null) {
                this.busyTimer.removeActionListener(this.busyAction);
                this.busyAction = null;
            }
            this.busyTimer.stop();
        }
    }

    public void addHandler(ActivityHandler ah) throws VisADException {
        if (this.handlerList == null) {
            throw new VisADException("No handler list found; was this object serialized?");
        }
        if (!this.busyTimer.isRunning()) {
            this.busyTimer.restart();
        }
        this.handlerList.add(ah);
    }

    public void removeHandler(ActivityHandler ah) throws VisADException {
        if (this.handlerList == null) {
            throw new VisADException("No handler list found; was this object serialized?");
        }
        this.handlerList.remove(ah);
        if (this.handlerList.size() == 0 && this.busyTimer.isRunning()) {
            this.busyTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyList(boolean isBusy) {
        if (this.handlerList != null && this.busyTimer != null) {
            ArrayList arrayList = this.handlerList;
            synchronized (arrayList) {
                int len = this.handlerList.size();
                for (int i = 0; i < len; ++i) {
                    ActivityHandler ah = (ActivityHandler)this.handlerList.get(i);
                    if (isBusy) {
                        ah.busyDisplay(this.dpy);
                        continue;
                    }
                    ah.idleDisplay(this.dpy);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBusyStatus() {
        long now = System.currentTimeMillis();
        if (!(this.isBusy || now >= this.lastBusyEvt && now <= this.lastBusyEvt + (long)this.interval)) {
            this.isBusy = true;
            if (this.busyAction == null && this.busyTimer != null) {
                Timer timer = this.busyTimer;
                synchronized (timer) {
                    if (this.busyAction == null) {
                        this.busyAction = new BusyAction();
                        this.busyTimer.addActionListener(this.busyAction);
                    }
                }
            }
            this.notifyList(true);
        }
        this.lastBusyEvt = now;
    }

    private class BusyAction
    implements ActionListener {
        private static final int MAX_IDLE = 10;
        private int idleCount = 0;

        BusyAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!DisplayActivity.this.isBusy) {
                ++this.idleCount;
                if (this.idleCount > 10 && DisplayActivity.this.busyTimer != null) {
                    Timer timer = DisplayActivity.this.busyTimer;
                    synchronized (timer) {
                        DisplayActivity.this.busyTimer.removeActionListener(DisplayActivity.this.busyAction);
                        DisplayActivity.this.busyAction = null;
                    }
                }
            } else {
                long now = System.currentTimeMillis();
                if (DisplayActivity.this.lastBusyEvt + (long)DisplayActivity.this.interval <= now) {
                    DisplayActivity.this.isBusy = false;
                    this.idleCount = 0;
                    DisplayActivity.this.notifyList(false);
                }
            }
        }
    }
}

