/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.ArrayList;
import visad.ControlEvent;
import visad.ControlListener;
import visad.GraphicsModeControl;
import visad.Info;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.ShadowType;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.util.Util;

public class FixGeomSizeAppearance
implements ControlListener {
    ArrayList<Object> FSTarray = new ArrayList();
    ProjectionControl p_cntrl = null;
    double last_scale;
    protected double first_scale = Double.NaN;
    double baseScale = Double.NaN;
    double rescaleThreshold = 1.15;
    int cnt = 0;
    VisADGeometryArray array;
    Object topBranch;
    ArrayList<float[]> anchors;
    protected ShadowType shadow;
    GraphicsModeControl mode;
    float constant_alpha;
    float[] constant_color;
    private boolean locked = false;
    MouseBehavior mouseBehav;

    public FixGeomSizeAppearance(ProjectionControl p_cntrl, ShadowType shadow, MouseBehavior mouseBehav) {
        this.p_cntrl = p_cntrl;
        this.shadow = shadow;
        this.mouseBehav = mouseBehav;
        double[] matrix = p_cntrl.getMatrix();
        double[] rot_a = new double[3];
        double[] trans_a = new double[3];
        double[] scale_a = new double[1];
        mouseBehav.instance_unmake_matrix(rot_a, scale_a, trans_a, matrix);
        this.first_scale = this.last_scale = scale_a[0];
    }

    @Override
    public synchronized void controlChanged(ControlEvent e) throws VisADException, RemoteException {
        if (this.locked) {
            return;
        }
        this.update();
    }

    public void update() throws VisADException {
        double[] matrix = this.p_cntrl.getMatrix();
        double[] rot_a = new double[3];
        double[] trans_a = new double[3];
        double[] scale_a = new double[1];
        this.mouseBehav.instance_unmake_matrix(rot_a, scale_a, trans_a, matrix);
        if (!Util.isApproximatelyEqual(scale_a[0], this.last_scale) && (scale_a[0] / this.last_scale > this.rescaleThreshold || scale_a[0] / this.last_scale < 1.0 / this.rescaleThreshold)) {
            for (int k = 0; k < this.FSTarray.size(); ++k) {
                Info info = (Info)this.FSTarray.get(k);
                this.topBranch = info.branch;
                this.array = info.array;
                this.anchors = info.anchors;
                this.mode = info.mode;
                this.constant_alpha = info.constant_alpha;
                this.constant_color = info.constant_color;
                this.rescaleAndReplace(scale_a[0], this.topBranch, this.array, this.anchors, this.mode, this.constant_alpha, this.constant_color);
            }
            this.last_scale = scale_a[0];
        }
    }

    public void rescaleAndReplace(double scale, Object topBranch, VisADGeometryArray array, ArrayList<float[]> anchors, GraphicsModeControl mode, float constant_alpha, float[] constant_color) throws VisADException {
        throw new VisADException("rescaleAndReplace unimplemented");
    }

    public void add(Object branch, VisADGeometryArray array, ArrayList<float[]> anchors, GraphicsModeControl mode, float constant_alpha, float[] constant_color) {
        Info info = new Info();
        info.branch = branch;
        info.array = array;
        info.anchors = anchors;
        info.mode = mode;
        info.constant_alpha = constant_alpha;
        info.constant_color = constant_color;
        this.FSTarray.add(info);
    }

    public synchronized void lock() {
        this.locked = true;
    }

    public synchronized void unlock() {
        this.locked = false;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

