/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.DataRenderer;
import visad.ShadowType;
import visad.VisADException;
import visad.VisADGeometryArray;

public class VisADIndexedTriangleStripArray
extends VisADGeometryArray {
    public int indexCount;
    public int[] indices;
    public int[] stripVertexCounts;
    private static final int MUL = 6;

    public static VisADIndexedTriangleStripArray merge(VisADIndexedTriangleStripArray[] arrays) throws VisADException {
        if (arrays == null || arrays.length == 0) {
            return null;
        }
        VisADIndexedTriangleStripArray array = new VisADIndexedTriangleStripArray();
        VisADIndexedTriangleStripArray.merge(arrays, array);
        int count = 0;
        int nind = 0;
        int nstrips = 0;
        int n = arrays.length;
        int[] start = new int[n];
        start[0] = 0;
        for (int i = 0; i < n; ++i) {
            if (arrays[i] == null) continue;
            count += arrays[i].indexCount;
            nind += arrays[i].indices.length;
            nstrips += arrays[i].stripVertexCounts.length;
            if (i <= 0) continue;
            start[i] = start[i - 1] + arrays[i - 1].vertexCount;
        }
        if (nstrips <= 0) {
            return null;
        }
        int[] indices = new int[nind];
        int[] stripVertexCounts = new int[nstrips];
        nind = 0;
        nstrips = 0;
        for (int i = 0; i < n; ++i) {
            int j;
            if (arrays[i] == null) continue;
            int incind = arrays[i].indices.length;
            int incnstrips = arrays[i].stripVertexCounts.length;
            for (j = 0; j < incind; ++j) {
                indices[nind + j] = arrays[i].indices[j] + start[i];
            }
            for (j = 0; j < incnstrips; ++j) {
                stripVertexCounts[nstrips + j] = arrays[i].stripVertexCounts[j];
            }
            nind += incind;
            nstrips += incnstrips;
        }
        array.indexCount = count;
        array.indices = indices;
        array.stripVertexCounts = stripVertexCounts;
        return array;
    }

    @Override
    public VisADGeometryArray adjustLongitude(DataRenderer renderer) throws VisADException {
        float[] lons = this.getLongitudes(renderer);
        if (lons == null) {
            return this;
        }
        int[] axis = new int[1];
        float[] lon_coords = new float[2];
        float[] lon_range = this.getLongitudeRange(lons, axis, lon_coords);
        if (lon_range[0] != lon_range[0] || lon_range[1] != lon_range[1]) {
            return this;
        }
        float bottom = lon_range[0];
        float top = lon_range[1];
        float low = bottom + 30.0f;
        float hi = top - 30.0f;
        int lon_axis = axis[0];
        float coord_bottom = lon_coords[0];
        float coord_top = lon_coords[1];
        int mid_first = -1;
        int mid_second = -1;
        int last_mid_first = -1;
        int last_mid_second = -1;
        int sillymid_first = -1;
        int sillymid_second = -1;
        int last = -1;
        int early = -1;
        int point = -1;
        VisADIndexedTriangleStripArray array = new VisADIndexedTriangleStripArray();
        float[] coords = new float[6 * this.coordinates.length];
        System.arraycopy(this.coordinates, 0, coords, 0, this.coordinates.length);
        float[] nos = null;
        if (this.normals != null) {
            nos = new float[6 * this.normals.length];
            System.arraycopy(this.normals, 0, nos, 0, this.normals.length);
        }
        int color_length = 0;
        byte[] cols = null;
        if (this.colors != null) {
            color_length = 3;
            cols = new byte[6 * this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
            System.arraycopy(this.colors, 0, cols, 0, this.colors.length);
        }
        float[] texs = null;
        if (this.texCoords != null) {
            texs = new float[6 * this.texCoords.length];
            System.arraycopy(this.texCoords, 0, texs, 0, this.texCoords.length);
        }
        int coord_index = this.coordinates.length / 3;
        int[] inds = new int[6 * this.indices.length];
        int ind_index = 0;
        int[] svcs = new int[this.coordinates.length];
        int svc_index = 0;
        int last_i = 0;
        boolean any_split = false;
        for (int i_svc = 0; i_svc < this.stripVertexCounts.length; ++i_svc) {
            boolean this_split = false;
            int accum = 0;
            for (int i = last_i; i < last_i + this.stripVertexCounts[i_svc] - 1; ++i) {
                int ip2;
                int s2;
                int f2;
                int ip4;
                int s4;
                int f4;
                int ip3;
                int s3;
                int f3;
                float beta;
                float alpha;
                float coord_second;
                float coord_first;
                float b;
                float a;
                boolean last_split = this_split;
                if (last_split) {
                    last_mid_first = mid_first;
                    last_mid_second = mid_second;
                }
                if (lons[this.indices[i]] < low && hi < lons[this.indices[i + 1]] || lons[this.indices[i + 1]] < low && hi < lons[this.indices[i]]) {
                    this_split = true;
                    any_split = true;
                    if (lon_axis < 0) {
                        if (accum >= 3) {
                            svcs[svc_index] = accum;
                            ++svc_index;
                        }
                        last = this.indices[i + 1];
                        accum = 1;
                        continue;
                    }
                    if (lons[this.indices[i]] < low) {
                        a = lons[this.indices[i]] - bottom;
                        b = top - lons[this.indices[i + 1]];
                        coord_first = coord_bottom;
                        coord_second = coord_top;
                    } else {
                        a = top - lons[this.indices[i]];
                        b = lons[this.indices[i + 1]] - bottom;
                        coord_first = coord_top;
                        coord_second = coord_bottom;
                    }
                    alpha = b / (a + b);
                    alpha = alpha != alpha || alpha < 0.0f ? 0.0f : (1.0f < alpha ? 1.0f : alpha);
                    beta = 1.0f - alpha;
                    mid_first = coord_index++;
                    mid_second = coord_index++;
                    f3 = 3 * mid_first;
                    s3 = 3 * mid_second;
                    int i3 = 3 * this.indices[i];
                    ip3 = 3 * this.indices[i + 1];
                    coords[f3] = alpha * this.coordinates[i3] + beta * this.coordinates[ip3];
                    coords[f3 + 1] = alpha * this.coordinates[i3 + 1] + beta * this.coordinates[ip3 + 1];
                    coords[f3 + 2] = alpha * this.coordinates[i3 + 2] + beta * this.coordinates[ip3 + 2];
                    coords[s3] = coords[f3];
                    coords[s3 + 1] = coords[f3 + 1];
                    coords[s3 + 2] = coords[f3 + 2];
                    coords[f3 + lon_axis] = coord_first;
                    coords[s3 + lon_axis] = coord_second;
                    if (this.normals != null) {
                        nos[f3] = alpha * this.normals[i3] + beta * this.normals[ip3];
                        nos[f3 + 1] = alpha * this.normals[i3 + 1] + beta * this.normals[ip3 + 1];
                        nos[f3 + 2] = alpha * this.normals[i3 + 2] + beta * this.normals[ip3 + 2];
                        nos[s3] = nos[f3];
                        nos[s3 + 1] = nos[f3 + 1];
                        nos[s3 + 2] = nos[f3 + 2];
                    }
                    if (color_length == 3) {
                        cols[f3] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[i3]) + beta * ShadowType.byteToFloat(this.colors[ip3]));
                        cols[f3 + 1] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[i3 + 1]) + beta * ShadowType.byteToFloat(this.colors[ip3 + 1]));
                        cols[f3 + 2] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[i3 + 2]) + beta * ShadowType.byteToFloat(this.colors[ip3 + 2]));
                        cols[s3] = cols[f3];
                        cols[s3 + 1] = cols[f3 + 1];
                        cols[s3 + 2] = cols[f3 + 2];
                    } else if (color_length == 4) {
                        f4 = 4 * mid_first;
                        s4 = 4 * mid_second;
                        int i4 = 4 * this.indices[i];
                        ip4 = 4 * this.indices[i + 1];
                        cols[f4] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[i4]) + beta * ShadowType.byteToFloat(this.colors[ip4]));
                        cols[f4 + 1] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[i4 + 1]) + beta * ShadowType.byteToFloat(this.colors[ip4 + 1]));
                        cols[f4 + 2] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[i4 + 2]) + beta * ShadowType.byteToFloat(this.colors[ip4 + 2]));
                        cols[f4 + 3] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[i4 + 3]) + beta * ShadowType.byteToFloat(this.colors[ip4 + 3]));
                        cols[s4] = cols[f4];
                        cols[s4 + 1] = cols[f4 + 1];
                        cols[s4 + 2] = cols[f4 + 2];
                        cols[s4 + 3] = cols[f4 + 3];
                    }
                    if (this.texCoords != null) {
                        f2 = 2 * mid_first;
                        s2 = 2 * mid_second;
                        int i2 = 2 * this.indices[i];
                        ip2 = 2 * this.indices[i + 1];
                        texs[f2] = alpha * this.texCoords[i2] + beta * this.texCoords[ip2];
                        texs[f2 + 1] = alpha * this.texCoords[i2 + 1] + beta * this.texCoords[ip2 + 1];
                        texs[s2] = cols[f2];
                        texs[s2 + 1] = cols[f2 + 1];
                    }
                } else {
                    this_split = false;
                }
                if (accum > 0 && this_split != last_split && lon_axis >= 0) {
                    if (lons[this.indices[i - 1]] < low) {
                        a = lons[this.indices[i - 1]] - bottom;
                        b = top - lons[this.indices[i + 1]];
                        coord_first = coord_bottom;
                        coord_second = coord_top;
                    } else {
                        a = top - lons[this.indices[i - 1]];
                        b = lons[this.indices[i + 1]] - bottom;
                        coord_first = coord_top;
                        coord_second = coord_bottom;
                    }
                    alpha = b / (a + b);
                    alpha = alpha != alpha || alpha < 0.0f ? 0.0f : (1.0f < alpha ? 1.0f : alpha);
                    beta = 1.0f - alpha;
                    sillymid_first = coord_index++;
                    sillymid_second = coord_index++;
                    f3 = 3 * sillymid_first;
                    s3 = 3 * sillymid_second;
                    int im3 = 3 * this.indices[i - 1];
                    ip3 = 3 * this.indices[i + 1];
                    coords[f3] = alpha * this.coordinates[im3] + beta * this.coordinates[ip3];
                    coords[f3 + 1] = alpha * this.coordinates[im3 + 1] + beta * this.coordinates[ip3 + 1];
                    coords[f3 + 2] = alpha * this.coordinates[im3 + 2] + beta * this.coordinates[ip3 + 2];
                    coords[s3] = coords[f3];
                    coords[s3 + 1] = coords[f3 + 1];
                    coords[s3 + 2] = coords[f3 + 2];
                    coords[f3 + lon_axis] = coord_first;
                    coords[s3 + lon_axis] = coord_second;
                    if (this.normals != null) {
                        nos[f3] = alpha * this.normals[im3] + beta * this.normals[ip3];
                        nos[f3 + 1] = alpha * this.normals[im3 + 1] + beta * this.normals[ip3 + 1];
                        nos[f3 + 2] = alpha * this.normals[im3 + 2] + beta * this.normals[ip3 + 2];
                        nos[s3] = nos[f3];
                        nos[s3 + 1] = nos[f3 + 1];
                        nos[s3 + 2] = nos[f3 + 2];
                    }
                    if (color_length == 3) {
                        cols[f3] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[im3]) + beta * ShadowType.byteToFloat(this.colors[ip3]));
                        cols[f3 + 1] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[im3 + 1]) + beta * ShadowType.byteToFloat(this.colors[ip3 + 1]));
                        cols[f3 + 2] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[im3 + 2]) + beta * ShadowType.byteToFloat(this.colors[ip3 + 2]));
                        cols[s3] = cols[f3];
                        cols[s3 + 1] = cols[f3 + 1];
                        cols[s3 + 2] = cols[f3 + 2];
                    } else if (color_length == 4) {
                        f4 = 4 * mid_first;
                        s4 = 4 * mid_second;
                        int im4 = 4 * this.indices[i - 1];
                        ip4 = 4 * this.indices[i + 1];
                        cols[f4] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[im4]) + beta * ShadowType.byteToFloat(this.colors[ip4]));
                        cols[f4 + 1] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[im4 + 1]) + beta * ShadowType.byteToFloat(this.colors[ip4 + 1]));
                        cols[f4 + 2] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[im4 + 2]) + beta * ShadowType.byteToFloat(this.colors[ip4 + 2]));
                        cols[f4 + 3] = ShadowType.floatToByte(alpha * ShadowType.byteToFloat(this.colors[im4 + 3]) + beta * ShadowType.byteToFloat(this.colors[ip4 + 3]));
                        cols[s4] = cols[f4];
                        cols[s4 + 1] = cols[f4 + 1];
                        cols[s4 + 2] = cols[f4 + 2];
                        cols[s4 + 3] = cols[f4 + 3];
                    }
                    if (this.texCoords != null) {
                        f2 = 2 * mid_first;
                        s2 = 2 * mid_second;
                        int im2 = 2 * this.indices[i - 1];
                        ip2 = 2 * this.indices[i + 1];
                        texs[f2] = alpha * this.texCoords[im2] + beta * this.texCoords[ip2];
                        texs[f2 + 1] = alpha * this.texCoords[im2 + 1] + beta * this.texCoords[ip2 + 1];
                        texs[s2] = cols[f2];
                        texs[s2 + 1] = cols[f2 + 1];
                    }
                }
                if (this_split) {
                    if (accum == 0) {
                        early = mid_second;
                        last = this.indices[i + 1];
                        accum = 2;
                        continue;
                    }
                    if (last_split) {
                        point = mid_first;
                        if (++accum == 3) {
                            inds[ind_index++] = early;
                            inds[ind_index++] = last;
                            inds[ind_index++] = point;
                        } else {
                            inds[ind_index++] = point;
                        }
                        svcs[svc_index] = accum;
                        ++svc_index;
                        early = last_mid_first;
                        last = this.indices[i - 1];
                        point = mid_second;
                        accum = 3;
                        inds[ind_index++] = early;
                        inds[ind_index++] = last;
                        inds[ind_index++] = point;
                        point = this.indices[i + 1];
                        ++accum;
                        inds[ind_index++] = point;
                        continue;
                    }
                    point = mid_first;
                    if (++accum == 2) {
                        early = last;
                        last = point;
                    } else if (accum == 3) {
                        inds[ind_index++] = early;
                        inds[ind_index++] = last;
                        inds[ind_index++] = point;
                    } else {
                        inds[ind_index++] = point;
                    }
                    point = this.indices[i - 1];
                    if (++accum == 2) {
                        early = last;
                        last = point;
                    } else if (accum == 3) {
                        inds[ind_index++] = early;
                        inds[ind_index++] = last;
                        inds[ind_index++] = point;
                    } else {
                        inds[ind_index++] = point;
                    }
                    point = sillymid_first;
                    if (++accum == 2) {
                        early = last;
                        last = point;
                    } else if (accum == 3) {
                        inds[ind_index++] = early;
                        inds[ind_index++] = last;
                        inds[ind_index++] = point;
                    } else {
                        inds[ind_index++] = point;
                    }
                    svcs[svc_index] = accum;
                    ++svc_index;
                    early = sillymid_second;
                    last = mid_second;
                    point = this.indices[i + 1];
                    accum = 3;
                    inds[ind_index++] = early;
                    inds[ind_index++] = last;
                    inds[ind_index++] = point;
                    continue;
                }
                if (accum == 0) {
                    early = this.indices[i];
                    last = this.indices[i + 1];
                    accum = 2;
                    continue;
                }
                if (last_split && lon_axis >= 0) {
                    if (accum >= 3) {
                        svcs[svc_index] = accum;
                        ++svc_index;
                    }
                    early = this.indices[i - 1];
                    last = last_mid_first;
                    point = sillymid_first;
                    accum = 3;
                    inds[ind_index++] = early;
                    inds[ind_index++] = last;
                    inds[ind_index++] = point;
                    svcs[svc_index] = accum;
                    ++svc_index;
                    early = last_mid_second;
                    last = sillymid_second;
                    point = this.indices[i];
                    accum = 3;
                    inds[ind_index++] = early;
                    inds[ind_index++] = last;
                    inds[ind_index++] = point;
                    point = this.indices[i + 1];
                    ++accum;
                    inds[ind_index++] = point;
                    continue;
                }
                point = this.indices[i + 1];
                if (++accum == 2) {
                    early = last;
                    last = point;
                    continue;
                }
                if (accum == 3) {
                    inds[ind_index++] = early;
                    inds[ind_index++] = last;
                    inds[ind_index++] = point;
                    continue;
                }
                inds[ind_index++] = point;
            }
            if (accum >= 3) {
                svcs[svc_index] = accum;
                ++svc_index;
            }
            last_i += this.stripVertexCounts[i_svc];
        }
        if (!any_split) {
            return this;
        }
        array.coordinates = new float[3 * coord_index];
        System.arraycopy(coords, 0, array.coordinates, 0, 3 * coord_index);
        if (this.normals != null) {
            array.normals = new float[3 * coord_index];
            System.arraycopy(nos, 0, array.normals, 0, 3 * coord_index);
        }
        if (this.colors != null) {
            array.colors = new byte[color_length * coord_index];
            System.arraycopy(cols, 0, array.colors, 0, color_length * coord_index);
        }
        if (this.texCoords != null) {
            array.texCoords = new float[2 * coord_index];
            System.arraycopy(texs, 0, array.texCoords, 0, 2 * coord_index);
        }
        array.vertexCount = coord_index;
        array.stripVertexCounts = new int[svc_index];
        System.arraycopy(svcs, 0, array.stripVertexCounts, 0, svc_index);
        array.indices = new int[ind_index];
        System.arraycopy(inds, 0, array.indices, 0, ind_index);
        return array;
    }

    @Override
    public VisADGeometryArray removeMissing() {
        VisADIndexedTriangleStripArray array = new VisADIndexedTriangleStripArray();
        float[] coords = new float[this.coordinates.length];
        float[] nos = null;
        if (this.normals != null) {
            nos = new float[this.normals.length];
        }
        int color_length = 3;
        byte[] cols = null;
        if (this.colors != null) {
            cols = new byte[this.colors.length];
            if (this.colors.length != this.coordinates.length) {
                color_length = 4;
            }
        }
        float[] texs = null;
        if (this.texCoords != null) {
            texs = new float[this.texCoords.length];
        }
        int[] compress = new int[this.indices.length];
        int j = 0;
        int k = 0;
        for (int i = 0; i < this.coordinates.length; i += 3) {
            if (this.coordinates[i] == this.coordinates[i] && this.coordinates[i + 1] == this.coordinates[i + 1] && this.coordinates[i + 2] == this.coordinates[i + 2]) {
                compress[j] = k;
                int k3 = 3 * k;
                coords[k3] = this.coordinates[i];
                coords[k3 + 1] = this.coordinates[i + 1];
                coords[k3 + 2] = this.coordinates[i + 2];
                if (this.normals != null) {
                    nos[k3] = this.normals[i];
                    nos[k3 + 1] = this.normals[i + 1];
                    nos[k3 + 2] = this.normals[i + 2];
                }
                if (this.colors != null) {
                    int kc = color_length * k;
                    int ic = color_length * j;
                    cols[kc] = this.colors[ic];
                    cols[kc + 1] = this.colors[ic + 1];
                    cols[kc + 2] = this.colors[ic + 2];
                    if (color_length == 4) {
                        cols[kc + 3] = this.colors[ic + 3];
                    }
                }
                if (this.texCoords != null) {
                    int kt = 2 * k;
                    int it = 2 * j;
                    texs[kt] = this.texCoords[it];
                    texs[kt + 1] = this.texCoords[it + 1];
                }
                ++k;
            } else {
                compress[j] = -1;
            }
            ++j;
        }
        array.coordinates = new float[3 * k];
        System.arraycopy(coords, 0, array.coordinates, 0, 3 * k);
        if (this.normals != null) {
            array.normals = new float[3 * k];
            System.arraycopy(nos, 0, array.normals, 0, 3 * k);
        }
        if (this.colors != null) {
            array.colors = new byte[color_length * k];
            System.arraycopy(cols, 0, array.colors, 0, color_length * k);
        }
        if (this.texCoords != null) {
            array.texCoords = new float[2 * k];
            System.arraycopy(texs, 0, array.texCoords, 0, 2 * k);
        }
        array.vertexCount = k;
        int[] new_indices = new int[this.indices.length];
        int[] svcs = new int[this.coordinates.length / 4];
        int svc_index = 0;
        int last_i = 0;
        int m = 0;
        boolean any_missing = false;
        for (int i_svc = 0; i_svc < this.stripVertexCounts.length; ++i_svc) {
            int accum = 0;
            for (int i = last_i; i < last_i + this.stripVertexCounts[i_svc]; ++i) {
                if (compress[this.indices[i]] >= 0) {
                    if (++accum < 3) continue;
                    int iml = i;
                    if (accum == 3) {
                        iml = i - 2;
                    }
                    for (int im = iml; im <= i; ++im) {
                        new_indices[m] = compress[this.indices[im]];
                        ++m;
                    }
                    continue;
                }
                any_missing = true;
                if (accum >= 3) {
                    svcs[svc_index] = accum;
                    ++svc_index;
                }
                accum = 0;
            }
            if (accum >= 3) {
                svcs[svc_index] = accum;
                ++svc_index;
            }
            last_i += this.stripVertexCounts[i_svc];
        }
        if (!any_missing) {
            return this;
        }
        array.indices = new int[m];
        System.arraycopy(new_indices, 0, array.indices, 0, m);
        array.stripVertexCounts = new int[svc_index];
        System.arraycopy(svcs, 0, array.stripVertexCounts, 0, svc_index);
        return array;
    }

    @Override
    public String toString() {
        int i;
        String string = "VisADIndexedTriangleStripArray, indexCount = " + this.indexCount;
        string = string + "\n stripVertexCounts = ";
        for (i = 0; i < this.stripVertexCounts.length; ++i) {
            string = string + this.stripVertexCounts[i] + " ";
        }
        string = string + "\n indices = ";
        for (i = 0; i < this.indices.length; ++i) {
            string = string + this.indices[i] + " ";
        }
        return string;
    }

    @Override
    public Object clone() {
        VisADIndexedTriangleStripArray array = new VisADIndexedTriangleStripArray();
        this.copy(array);
        array.indexCount = this.indexCount;
        if (this.stripVertexCounts != null) {
            array.stripVertexCounts = new int[this.stripVertexCounts.length];
            System.arraycopy(this.stripVertexCounts, 0, array.stripVertexCounts, 0, this.stripVertexCounts.length);
        }
        if (this.indices != null) {
            array.indices = new int[this.indices.length];
            System.arraycopy(this.indices, 0, array.indices, 0, this.indices.length);
        }
        return array;
    }
}

