/*
 * Decompiled with CFR 0.152.
 */
package visad.bom.annotations;

import visad.DisplayImpl;
import visad.bom.annotations.ScreenAnnotation;
import visad.bom.annotations.ScreenAnnotatorUtils;
import visad.java3d.DisplayImplJ3D;

public class QuadrilateralJ3D
implements ScreenAnnotation {
    public static final int POINT = 1;
    public static final int LINE = 2;
    public static final int FILL = 3;
    private int style;
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int x3;
    private int y3;
    private int x4;
    private int y4;
    private float[] colour;
    private double zValue;
    private double thickness;

    public QuadrilateralJ3D() {
        this(3, 0, 0, 0, 0, new float[]{1.0f, 1.0f, 1.0f}, 0.0, 1.0);
    }

    public QuadrilateralJ3D(int style, int x, int y, int width, int height, float[] colour, double zValue, double thickness) {
        this(style, x, y, x + width, y, x + width, y + height, x, y + height, colour, zValue, thickness);
    }

    public QuadrilateralJ3D(int style, int[][] points, float[] colour, double zValue, double thickness) {
        this(style, points[0][0], points[1][0], points[0][1], points[1][1], points[0][2], points[1][2], points[0][3], points[1][3], colour, zValue, thickness);
    }

    public QuadrilateralJ3D(int style, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, float[] colour, double zValue, double thickness) {
        this.style = style;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.x3 = x3;
        this.y3 = y3;
        this.x4 = x4;
        this.y4 = y4;
        this.colour = colour;
        this.zValue = zValue;
        this.thickness = thickness;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setLocation(int x, int y) {
        int w = this.x1 - x;
        int h = this.y1 - y;
        this.x1 = x;
        this.y1 = y;
        this.x2 -= w;
        this.y2 -= h;
        this.x3 -= w;
        this.y3 -= h;
        this.x4 -= w;
        this.y4 -= h;
    }

    public void setSize(int width, int height) {
        this.x2 = this.x1 + width;
        this.y2 = this.y1;
        this.x3 = this.x2;
        this.y3 = this.y1 + height;
        this.x4 = this.x1;
        this.y4 = this.y2;
    }

    public void setPoints(int[][] points) {
        this.setPoints(points[0][0], points[1][0], points[0][1], points[1][1], points[0][2], points[1][2], points[0][3], points[1][3]);
    }

    public void setPoints(int x, int y, int width, int height) {
        this.x1 = x;
        this.y1 = y;
        this.setSize(width, height);
    }

    public void setPoints(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.x3 = x3;
        this.y3 = y3;
        this.x4 = x4;
        this.y4 = y4;
    }

    public void setColour(float[] colour) {
        this.colour = colour;
    }

    public void setZValue(double zValue) {
        this.zValue = zValue;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    @Override
    public Object toDrawable(DisplayImpl display) {
        return ScreenAnnotatorUtils.makeQuadrilateralShape3D((DisplayImplJ3D)display, this.style, this.x1, this.y1, this.x2, this.y2, this.x3, this.y3, this.x4, this.y4, this.colour, this.zValue, this.thickness);
    }
}

