/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class DataCacheManager
implements Runnable {
    private double memoryPercentage = 0.25;
    private static DataCacheManager cacheManager;
    private File cacheDir;
    private int idCnt = 0;
    private long baseTime;
    private Hashtable<Object, CacheInfo> cache = new Hashtable();
    private Object MUTEX = new Object();
    private int totalSize = 0;
    private boolean running = false;
    private static final int TYPE_DOUBLE1D = 0;
    private static final int TYPE_FLOAT1D = 1;
    private static final int TYPE_INT1D = 2;
    private static final int TYPE_SHORT1D = 3;
    private static final int TYPE_BYTE1D = 4;
    private static final int TYPE_DOUBLE2D = 5;
    private static final int TYPE_FLOAT2D = 6;
    private static final int TYPE_INT2D = 7;
    private static final int TYPE_SHORT2D = 8;
    private static final int TYPE_BYTE2D = 9;
    private static final int TYPE_DOUBLE3D = 10;
    private static final int TYPE_FLOAT3D = 11;
    private static final int TYPE_INT3D = 12;
    private static final int TYPE_SHORT3D = 13;
    private static final int TYPE_BYTE3D = 14;

    private DataCacheManager() {
        this.baseTime = System.currentTimeMillis();
        try {
            Thread t = new Thread(this);
            t.start();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static DataCacheManager getCacheManager() {
        if (cacheManager == null) {
            cacheManager = new DataCacheManager();
        }
        return cacheManager;
    }

    @Override
    public void run() {
        if (this.running) {
            return;
        }
        this.running = true;
        try {
            while (true) {
                Thread.currentThread();
                Thread.sleep(5000L);
                this.checkCache();
            }
        }
        catch (Exception exc) {
            System.err.println("Error in DataCacheManager:");
            exc.printStackTrace();
            this.running = false;
            return;
        }
    }

    public void setCacheDir(File f) {
        this.cacheDir = f;
    }

    public File getCacheDir() {
        if (this.cacheDir == null) {
            this.cacheDir = new File(".");
        }
        return this.cacheDir;
    }

    public Object getId() {
        return "data_" + this.baseTime + "_" + this.idCnt++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object addToCache(String what, Object data, int type, boolean removeIfNeeded) {
        Object object = this.MUTEX;
        synchronized (object) {
            CacheInfo info = new CacheInfo(this, this.getId(), data, type, removeIfNeeded);
            if (what != null) {
                info.what = what;
            }
            this.cache.put(info.getId(), info);
            this.totalSize += info.getSize();
            this.checkCache();
            return info.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData(Object cacheId, Object data) {
        Object object = this.MUTEX;
        synchronized (object) {
            CacheInfo info = this.cache.get(cacheId);
            int oldSize = info.data != null ? info.getSize() : 0;
            info.setData(data);
            int newSize = info.getSize();
            this.totalSize -= oldSize;
            this.totalSize += newSize;
            this.checkCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inMemory(Object cacheId) {
        Object object = this.MUTEX;
        synchronized (object) {
            CacheInfo info = this.cache.get(cacheId);
            if (info == null) {
                return false;
            }
            info.dataAccessed();
            return info.data != null;
        }
    }

    private Object getData(Object cacheId) {
        CacheInfo info = null;
        Object data = null;
        Object object = this.MUTEX;
        synchronized (object) {
            info = this.cache.get(cacheId);
            if (info == null) {
                return null;
            }
            data = info.data;
            info.dataAccessed();
            if (data != null) {
                return data;
            }
            try {
                long t1 = System.currentTimeMillis();
                FileInputStream fis = new FileInputStream(info.cacheFile);
                BufferedInputStream bis = new BufferedInputStream(fis, 100000);
                ObjectInputStream ois = new ObjectInputStream(bis);
                data = ois.readObject();
                info.setDataFromCache(data);
                long t2 = System.currentTimeMillis();
                System.err.println("Read " + info.getSize() + " bytes from file in " + (t2 - t1) + " ms");
                this.totalSize += info.getSize();
                ois.close();
                bis.close();
                fis.close();
                this.checkCache();
                info.cacheMissed();
                return data;
            }
            catch (Exception exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    public File getCacheFile() {
        return new File(this.getCacheDir() + "/" + this.getId() + ".dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(Object cacheId) {
        Object object = this.MUTEX;
        synchronized (object) {
            this.removeFromCache(this.cache.get(cacheId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(CacheInfo info) {
        if (info == null) {
            return;
        }
        Object object = this.MUTEX;
        synchronized (object) {
            if (info.data != null) {
                info.data = null;
                this.totalSize -= info.getSize();
            }
            this.cache.remove(info.id);
            info.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAllCachedData() {
        Object object = this.MUTEX;
        synchronized (object) {
            for (CacheInfo info : this.getCacheInfos()) {
                this.flushCachedData(info);
            }
            Runtime.getRuntime().gc();
        }
    }

    private void flushCachedData(CacheInfo info) {
        try {
            if (info.removeIfNeeded) {
                this.removeFromCache(info);
                return;
            }
            if (info.data == null) {
                return;
            }
            if (!info.cacheFileGood) {
                FileOutputStream fos = new FileOutputStream(info.cacheFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos, 100000);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(info.data);
                oos.close();
                bos.close();
                fos.close();
            }
            info.data = null;
            this.totalSize -= info.getSize();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CacheInfo> getCacheInfos() {
        Object object = this.MUTEX;
        synchronized (object) {
            ArrayList<CacheInfo> infos = new ArrayList<CacheInfo>();
            Enumeration<Object> keys = this.cache.keys();
            while (keys.hasMoreElements()) {
                CacheInfo info = this.cache.get(keys.nextElement());
                infos.add(info);
            }
            Collections.sort(infos);
            return infos;
        }
    }

    public void setMemoryPercent(double percentage) {
        this.memoryPercentage = percentage;
        this.checkCache();
    }

    public int getMaxSize() {
        return (int)(this.memoryPercentage * (double)Runtime.getRuntime().maxMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCache() {
        if (this.totalSize < this.getMaxSize()) {
            return;
        }
        Object object = this.MUTEX;
        synchronized (object) {
            for (CacheInfo info : this.getCacheInfos()) {
                if (!info.removeIfNeeded) continue;
                this.flushCachedData(info);
                if (this.totalSize > this.getMaxSize()) continue;
                break;
            }
            if (this.totalSize <= this.getMaxSize()) {
                for (CacheInfo info : this.getCacheInfos()) {
                    this.flushCachedData(info);
                    if (this.totalSize > this.getMaxSize()) continue;
                    break;
                }
            }
        }
    }

    public void printStats() {
        System.err.println(this.getStats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStats() {
        Object object = this.MUTEX;
        synchronized (object) {
            StringBuffer sb = new StringBuffer();
            int mb = (int)((double)this.getMaxSize() / 1000000.0);
            int total = (int)((double)this.totalSize / 1000000.0);
            sb.append("Cache total size:" + total + " MB   max size:" + mb + " MB  (" + 100.0 * this.memoryPercentage + "% of max memory)");
            sb.append("\n");
            List<CacheInfo> infos = this.getCacheInfos();
            if (infos.size() == 0) {
                sb.append("nothing in cache");
                sb.append("\n");
            } else {
                sb.append("entry size/in cache/data access/cache miss/last touched");
                sb.append("\n");
                int cnt = 0;
                for (CacheInfo info : infos) {
                    sb.append("   #" + ++cnt + " ");
                    sb.append(info.toString());
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStats(String where) {
        Object object = this.MUTEX;
        synchronized (object) {
            CacheInfo info;
            int tmp = 0;
            Enumeration<Object> keys = this.cache.keys();
            while (keys.hasMoreElements()) {
                info = this.cache.get(keys.nextElement());
                if (info.data == null) continue;
                tmp += info.getSize();
            }
            if (tmp != this.totalSize) {
                System.err.println("WHOAA: " + where + "  " + tmp + " != total size:" + this.totalSize);
                keys = this.cache.keys();
                while (keys.hasMoreElements()) {
                    info = this.cache.get(keys.nextElement());
                    System.err.println("   cache entry:" + info.getSize() + " " + (info.data != null));
                }
            }
        }
    }

    public double[] getDoubleArray1D(Object cacheId) {
        return (double[])this.getData(cacheId);
    }

    public Object addToCache(double[] values) {
        return this.addToCache(null, values, 0, false);
    }

    public Object addToCache(String what, double[] values) {
        return this.addToCache(what, values, 0, false);
    }

    public Object addToCache(String what, double[] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 0, removeIfNeeded);
    }

    public float[] getFloatArray1D(Object cacheId) {
        return (float[])this.getData(cacheId);
    }

    public Object addToCache(float[] values) {
        return this.addToCache(null, values, 1, false);
    }

    public Object addToCache(String what, float[] values) {
        return this.addToCache(what, values, 1, false);
    }

    public Object addToCache(String what, float[] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 1, removeIfNeeded);
    }

    public int[] getIntArray1D(Object cacheId) {
        return (int[])this.getData(cacheId);
    }

    public Object addToCache(int[] values) {
        return this.addToCache(null, values, 2, false);
    }

    public Object addToCache(String what, int[] values) {
        return this.addToCache(what, values, 2, false);
    }

    public Object addToCache(String what, int[] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 2, removeIfNeeded);
    }

    public short[] getShortArray1D(Object cacheId) {
        return (short[])this.getData(cacheId);
    }

    public Object addToCache(short[] values) {
        return this.addToCache(null, values, 3, false);
    }

    public Object addToCache(String what, short[] values) {
        return this.addToCache(what, values, 3, false);
    }

    public Object addToCache(String what, short[] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 3, removeIfNeeded);
    }

    public byte[] getByteArray1D(Object cacheId) {
        return (byte[])this.getData(cacheId);
    }

    public Object addToCache(byte[] values) {
        return this.addToCache(null, values, 4, false);
    }

    public Object addToCache(String what, byte[] values) {
        return this.addToCache(what, values, 4, false);
    }

    public Object addToCache(String what, byte[] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 4, removeIfNeeded);
    }

    public double[][] getDoubleArray2D(Object cacheId) {
        return (double[][])this.getData(cacheId);
    }

    public Object addToCache(double[][] values) {
        return this.addToCache(null, values, 5, false);
    }

    public Object addToCache(String what, double[][] values) {
        return this.addToCache(what, values, 5, false);
    }

    public Object addToCache(String what, double[][] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 5, removeIfNeeded);
    }

    public float[][] getFloatArray2D(Object cacheId) {
        return (float[][])this.getData(cacheId);
    }

    public Object addToCache(float[][] values) {
        return this.addToCache(null, values, 6, false);
    }

    public Object addToCache(String what, float[][] values) {
        return this.addToCache(what, values, 6, false);
    }

    public Object addToCache(String what, float[][] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 6, removeIfNeeded);
    }

    public int[][] getIntArray2D(Object cacheId) {
        return (int[][])this.getData(cacheId);
    }

    public Object addToCache(int[][] values) {
        return this.addToCache(null, values, 7, false);
    }

    public Object addToCache(String what, int[][] values) {
        return this.addToCache(what, values, 7, false);
    }

    public Object addToCache(String what, int[][] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 7, removeIfNeeded);
    }

    public short[][] getShortArray2D(Object cacheId) {
        return (short[][])this.getData(cacheId);
    }

    public Object addToCache(short[][] values) {
        return this.addToCache(null, values, 8, false);
    }

    public Object addToCache(String what, short[][] values) {
        return this.addToCache(what, values, 8, false);
    }

    public Object addToCache(String what, short[][] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 8, removeIfNeeded);
    }

    public byte[][] getByteArray2D(Object cacheId) {
        return (byte[][])this.getData(cacheId);
    }

    public Object addToCache(byte[][] values) {
        return this.addToCache(null, values, 9, false);
    }

    public Object addToCache(String what, byte[][] values) {
        return this.addToCache(what, values, 9, false);
    }

    public Object addToCache(String what, byte[][] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 9, removeIfNeeded);
    }

    public double[][][] getDoubleArray3D(Object cacheId) {
        return (double[][][])this.getData(cacheId);
    }

    public Object addToCache(double[][][] values) {
        return this.addToCache(null, values, 10, false);
    }

    public Object addToCache(String what, double[][][] values) {
        return this.addToCache(what, values, 10, false);
    }

    public Object addToCache(String what, double[][][] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 10, removeIfNeeded);
    }

    public float[][][] getFloatArray3D(Object cacheId) {
        return (float[][][])this.getData(cacheId);
    }

    public Object addToCache(float[][][] values) {
        return this.addToCache(null, values, 11, false);
    }

    public Object addToCache(String what, float[][][] values) {
        return this.addToCache(what, values, 11, false);
    }

    public Object addToCache(String what, float[][][] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 11, removeIfNeeded);
    }

    public int[][][] getIntArray3D(Object cacheId) {
        return (int[][][])this.getData(cacheId);
    }

    public Object addToCache(int[][][] values) {
        return this.addToCache(null, values, 12, false);
    }

    public Object addToCache(String what, int[][][] values) {
        return this.addToCache(what, values, 12, false);
    }

    public Object addToCache(String what, int[][][] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 12, removeIfNeeded);
    }

    public short[][][] getShortArray3D(Object cacheId) {
        return (short[][][])this.getData(cacheId);
    }

    public Object addToCache(short[][][] values) {
        return this.addToCache(null, values, 13, false);
    }

    public Object addToCache(String what, short[][][] values) {
        return this.addToCache(what, values, 13, false);
    }

    public Object addToCache(String what, short[][][] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 13, removeIfNeeded);
    }

    public byte[][][] getByteArray3D(Object cacheId) {
        return (byte[][][])this.getData(cacheId);
    }

    public Object addToCache(byte[][][] values) {
        return this.addToCache(null, values, 14, false);
    }

    public Object addToCache(String what, byte[][][] values) {
        return this.addToCache(what, values, 14, false);
    }

    public Object addToCache(String what, byte[][][] values, boolean removeIfNeeded) {
        return this.addToCache(what, values, 14, removeIfNeeded);
    }

    private static int getArraySize(int type, Object values) {
        if (type == 0) {
            double[] data = (double[])values;
            return 8 * data.length;
        }
        if (type == 1) {
            float[] data = (float[])values;
            return 4 * data.length;
        }
        if (type == 2) {
            int[] data = (int[])values;
            return 4 * data.length;
        }
        if (type == 3) {
            short[] data = (short[])values;
            return 2 * data.length;
        }
        if (type == 4) {
            byte[] data = (byte[])values;
            return 1 * data.length;
        }
        if (type == 5) {
            double[][] data = (double[][])values;
            if (data[0] == null) {
                return 0;
            }
            return 8 * data.length * data[0].length;
        }
        if (type == 6) {
            float[][] data = (float[][])values;
            if (data[0] == null) {
                return 0;
            }
            return 4 * data.length * data[0].length;
        }
        if (type == 7) {
            int[][] data = (int[][])values;
            if (data[0] == null) {
                return 0;
            }
            return 4 * data.length * data[0].length;
        }
        if (type == 8) {
            short[][] data = (short[][])values;
            if (data[0] == null) {
                return 0;
            }
            return 2 * data.length * data[0].length;
        }
        if (type == 9) {
            byte[][] data = (byte[][])values;
            if (data[0] == null) {
                return 0;
            }
            return 1 * data.length * data[0].length;
        }
        if (type == 10) {
            double[][][] data = (double[][][])values;
            if (data[0] == null) {
                return 0;
            }
            if (data[0][0] == null) {
                return 0;
            }
            return 8 * data.length * data[0].length * data[0][0].length;
        }
        if (type == 11) {
            float[][][] data = (float[][][])values;
            if (data[0] == null) {
                return 0;
            }
            if (data[0][0] == null) {
                return 0;
            }
            return 4 * data.length * data[0].length * data[0][0].length;
        }
        if (type == 12) {
            int[][][] data = (int[][][])values;
            if (data[0] == null) {
                return 0;
            }
            if (data[0][0] == null) {
                return 0;
            }
            return 4 * data.length * data[0].length * data[0][0].length;
        }
        if (type == 13) {
            short[][][] data = (short[][][])values;
            if (data[0] == null) {
                return 0;
            }
            if (data[0][0] == null) {
                return 0;
            }
            return 2 * data.length * data[0].length * data[0][0].length;
        }
        if (type == 14) {
            byte[][][] data = (byte[][][])values;
            if (data[0] == null) {
                return 0;
            }
            if (data[0][0] == null) {
                return 0;
            }
            return 1 * data.length * data[0].length * data[0][0].length;
        }
        throw new IllegalArgumentException("Unknown type:" + type);
    }

    private static String getNameForType(int type) {
        if (type == 0) {
            return "double1d";
        }
        if (type == 1) {
            return "float1d";
        }
        if (type == 2) {
            return "int1d";
        }
        if (type == 3) {
            return "short1d";
        }
        if (type == 4) {
            return "byte1d";
        }
        if (type == 5) {
            return "double2d";
        }
        if (type == 6) {
            return "float2d";
        }
        if (type == 7) {
            return "int2d";
        }
        if (type == 8) {
            return "short2d";
        }
        if (type == 9) {
            return "byte2d";
        }
        if (type == 10) {
            return "double3d";
        }
        if (type == 11) {
            return "float3d";
        }
        if (type == 12) {
            return "int3d";
        }
        if (type == 13) {
            return "short3d";
        }
        if (type == 14) {
            return "byte3d";
        }
        return "unknown type";
    }

    private static class CacheInfo
    implements Comparable<CacheInfo> {
        private DataCacheManager cacheManager;
        private int type;
        private int size;
        private Object id;
        private long lastTime;
        private Object data;
        private File cacheFile;
        private boolean cacheFileGood = false;
        private int dataAccessedCnt = 0;
        private int cacheMissedCnt = 0;
        private String where;
        private String what;
        private boolean removeIfNeeded = false;

        public CacheInfo(DataCacheManager cacheManager, Object cacheId, Object data, int type, boolean removeIfNeeded) {
            this.id = cacheId;
            this.cacheManager = cacheManager;
            this.type = type;
            this.removeIfNeeded = removeIfNeeded;
            this.cacheFile = new File(cacheManager.getCacheDir() + "/" + cacheId + ".dat");
            this.what = data.toString();
            this.where = "";
            this.setData(data);
        }

        private void dataAccessed() {
            this.lastTime = System.currentTimeMillis();
            ++this.dataAccessedCnt;
        }

        private void cacheMissed() {
            ++this.cacheMissedCnt;
        }

        private void setData(Object data) {
            this.lastTime = System.currentTimeMillis();
            this.data = data;
            this.cacheFileGood = false;
            this.size = DataCacheManager.getArraySize(this.type, data);
        }

        public String getTypeName(int type) {
            return DataCacheManager.getNameForType(type);
        }

        public String toString() {
            return this.what + "   " + this.getTypeName(this.type) + ":" + this.getSize() + "   " + (this.data != null) + "   " + this.dataAccessedCnt + "   " + this.cacheMissedCnt + "   " + new Date(this.lastTime);
        }

        @Override
        public int compareTo(CacheInfo o) {
            CacheInfo that = o;
            if (this.lastTime < that.lastTime) {
                return -1;
            }
            if (this.lastTime == that.lastTime) {
                return 0;
            }
            return 1;
        }

        private void setDataFromCache(Object data) {
            this.lastTime = System.currentTimeMillis();
            this.data = data;
        }

        private void remove() {
            if (this.cacheFile != null) {
                this.cacheFile.delete();
            }
        }

        public int getSize() {
            return this.size;
        }

        public Object getId() {
            return this.id;
        }
    }
}

