/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import java.util.logging.Logger;
import visad.VisADException;
import visad.data.AreaImageCacheAdapter;
import visad.data.FlatFieldCacheAccessor;
import visad.data.FlatFieldCacheError;
import visad.data.FlatFieldCacheStrategy;

public class FlatFieldCache {
    private static Logger log = Logger.getLogger(FlatFieldCache.class.getName());
    private final Entry[] cache;
    private final int cacheSize;
    private FlatFieldCacheStrategy strategy;

    public FlatFieldCache(int cacheSize) {
        this(cacheSize, new AccessTimeCacheStrategy());
    }

    public FlatFieldCache(int cacheSize, FlatFieldCacheStrategy strategy) {
        if (cacheSize < 1) {
            throw new IllegalArgumentException("cache size must be >= 1");
        }
        this.cacheSize = cacheSize;
        this.strategy = strategy;
        this.cache = new Entry[cacheSize];
    }

    protected void updateEntry(Entry entry, float[][] data, CacheOwner owner) {
        for (int ii = 0; ii < data.length; ++ii) {
            System.arraycopy(data[ii], 0, entry.data[ii], 0, data[ii].length);
        }
        entry.owner = owner;
        entry.dirty = false;
        entry.lastAccessed = System.currentTimeMillis();
    }

    protected synchronized float[][] getData(AreaImageCacheAdapter owner, FlatFieldCacheAccessor fileAccessor) {
        if (this.cache == null) {
            log.fine("Cache was null, returning");
            return null;
        }
        for (int ii = 0; ii < this.cache.length; ++ii) {
            if (this.cache[ii] == null || owner != this.cache[ii].owner) continue;
            this.cache[ii].lastAccessed = System.currentTimeMillis();
            return this.cache[ii].data;
        }
        float[][] range = null;
        int idx = this.strategy.allocate(this.cache);
        if (idx == -1) {
            range = fileAccessor.readFlatFieldFloats();
        } else {
            if (this.cache[idx] == null) {
                this.cache[idx] = new Entry(owner, fileAccessor.readFlatFieldFloats());
            } else {
                if (this.cache[idx].dirty) {
                    try {
                        this.flushCache(this.cache[idx], fileAccessor);
                    }
                    catch (VisADException e) {
                        throw new FlatFieldCacheError("Could not flush to cache", e);
                    }
                }
                try {
                    float[][] data = fileAccessor.readFlatFieldFloats();
                    if (this.cache[idx].data == null) {
                        this.cache[idx].data = data;
                    } else {
                        this.updateEntry(this.cache[idx], data, owner);
                    }
                }
                catch (Exception e) {
                    throw new FlatFieldCacheError("Could not update cache entry", e);
                }
            }
            range = this.cache[idx] != null ? this.cache[idx].data : (float[][])null;
        }
        return range;
    }

    public void flushCache(Entry entry, FlatFieldCacheAccessor fileAccessor) throws VisADException {
        throw new UnsupportedOperationException("FlatFieldCache.flushCache not implemented");
    }

    public void setDirty(AreaImageCacheAdapter owner, boolean dirty) {
        for (int ii = 0; ii < this.cache.length; ++ii) {
            if (this.cache[ii].owner != owner) continue;
            this.cache[ii].dirty = dirty;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("<FlatFieldCache size=" + this.cacheSize + "\n");
        for (Entry entry : this.cache) {
            buf.append("\t" + (entry == null ? null : entry.toString()) + "\n");
        }
        buf.append(">");
        return buf.toString();
    }

    public int getSize() {
        return this.cacheSize;
    }

    static class Entry {
        CacheOwner owner;
        float[][] data;
        boolean dirty = false;
        long lastAccessed;
        long size;

        Entry(CacheOwner owner, float[][] data) {
            this.data = data;
            this.owner = owner;
            this.lastAccessed = System.currentTimeMillis();
        }

        public String toString() {
            return "<Entry lastAccessed=" + this.lastAccessed + " dirty=" + this.dirty + " owner=" + this.owner.getId() + ">";
        }
    }

    static class AccessTimeCacheStrategy
    implements FlatFieldCacheStrategy {
        AccessTimeCacheStrategy() {
        }

        @Override
        public int allocate(Entry[] entries) {
            if (entries == null || entries.length == 0) {
                return -1;
            }
            int availableIdx = 0;
            long oldest = entries[0] != null ? entries[0].lastAccessed : 0L;
            for (int ii = 0; ii < entries.length; ++ii) {
                if (entries[ii] == null) {
                    availableIdx = ii;
                    return availableIdx;
                }
                if (entries[ii].lastAccessed >= oldest) continue;
                oldest = entries[ii].lastAccessed;
                availableIdx = ii;
            }
            return availableIdx;
        }
    }

    static interface CacheOwner {
        public String getId();
    }
}

