/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Datatype
extends HDF5Object {
    private static final long serialVersionUID = 1L;

    public HDF5Datatype() {
        this.type = 3;
    }

    public HDF5Datatype(int datatype_class, int size) {
        this.type = 3;
        try {
            this.id = H5.H5Tcreate((int)datatype_class, (int)size);
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Datatype: " + (Object)((Object)e));
            this.id = -1;
        }
        try {
            this.init();
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Datatype.init(): " + (Object)((Object)e));
        }
    }

    public HDF5Datatype(int loc_id, String type_name) {
        super(type_name);
        this.type = 3;
        try {
            this.id = H5.H5Topen((int)loc_id, (String)this.name);
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Datatype: " + (Object)((Object)e));
            this.id = -1;
        }
    }

    public int H5Tcommit(int loc_id, String type_name) throws HDF5LibraryException, NullPointerException {
        this.name = type_name;
        return H5.H5Tcommit((int)loc_id, (String)type_name, (int)this.id);
    }

    public int get_class() throws HDF5LibraryException {
        return H5.H5Tget_class((int)this.id);
    }

    public int get_size() throws HDF5LibraryException {
        return H5.H5Tget_size((int)this.id);
    }

    public Object defineData(long[] count) throws HDF5Exception {
        Object[] data = null;
        int size = 0;
        long lsize = 1L;
        if (count == null) {
            return null;
        }
        for (int i = 0; i < count.length; ++i) {
            if ((lsize *= count[i]) <= Integer.MAX_VALUE) continue;
            throw new OutOfMemoryError("the size of data array > 2147483647");
        }
        size = (int)lsize;
        int class_t = H5.H5Tget_class((int)this.id);
        int class_s = H5.H5Tget_size((int)this.id);
        if (class_t == 0) {
            if (class_s == 1) {
                data = new byte[size];
            } else if (class_s == 2) {
                data = new short[size];
            } else if (class_s == 4) {
                data = new int[size];
            } else if (class_s == 8) {
                data = new long[size];
            }
        } else if (class_t == 1) {
            if (class_s == 4) {
                data = new float[size];
            } else if (class_s == 8) {
                data = new double[size];
            }
        } else if (class_t == 3) {
            data = new String[size];
        } else if (class_t == 6) {
            // empty if block
        }
        return data;
    }

    public static String getDatatype(int data_type) {
        if (data_type == H5.J2C((int)1)) {
            return "HDF5CDataTypes.JH5T_ALPHA_B16";
        }
        if (data_type == H5.J2C((int)2)) {
            return "HDF5CDataTypes.JH5T_ALPHA_B32";
        }
        if (data_type == H5.J2C((int)3)) {
            return "HDF5CDataTypes.JH5T_ALPHA_B64";
        }
        if (data_type == H5.J2C((int)4)) {
            return "HDF5CDataTypes.JH5T_ALPHA_B8";
        }
        if (data_type == H5.J2C((int)5)) {
            return "HDF5CDataTypes.JH5T_ALPHA_F32";
        }
        if (data_type == H5.J2C((int)6)) {
            return "HDF5CDataTypes.JH5T_ALPHA_F64";
        }
        if (data_type == H5.J2C((int)7)) {
            return "HDF5CDataTypes.JH5T_ALPHA_I16";
        }
        if (data_type == H5.J2C((int)8)) {
            return "HDF5CDataTypes.JH5T_ALPHA_I32";
        }
        if (data_type == H5.J2C((int)9)) {
            return "HDF5CDataTypes.JH5T_ALPHA_I64";
        }
        if (data_type == H5.J2C((int)10)) {
            return "HDF5CDataTypes.JH5T_ALPHA_I8";
        }
        if (data_type == H5.J2C((int)11)) {
            return "HDF5CDataTypes.JH5T_ALPHA_U16";
        }
        if (data_type == H5.J2C((int)12)) {
            return "HDF5CDataTypes.JH5T_ALPHA_U32";
        }
        if (data_type == H5.J2C((int)13)) {
            return "HDF5CDataTypes.JH5T_ALPHA_U64";
        }
        if (data_type == H5.J2C((int)14)) {
            return "HDF5CDataTypes.JH5T_ALPHA_U8";
        }
        if (data_type == H5.J2C((int)15)) {
            return "HDF5CDataTypes.JH5T_C_S1";
        }
        if (data_type == H5.J2C((int)16)) {
            return "HDF5CDataTypes.JH5T_FORTRAN_S1";
        }
        if (data_type == H5.J2C((int)17)) {
            return "HDF5CDataTypes.JH5T_IEEE_F32BE";
        }
        if (data_type == H5.J2C((int)18)) {
            return "HDF5CDataTypes.JH5T_IEEE_F32LE";
        }
        if (data_type == H5.J2C((int)19)) {
            return "HDF5CDataTypes.JH5T_IEEE_F64BE";
        }
        if (data_type == H5.J2C((int)20)) {
            return "HDF5CDataTypes.JH5T_IEEE_F64LE";
        }
        if (data_type == H5.J2C((int)21)) {
            return "HDF5CDataTypes.JH5T_INTEL_B16";
        }
        if (data_type == H5.J2C((int)22)) {
            return "HDF5CDataTypes.JH5T_INTEL_B32";
        }
        if (data_type == H5.J2C((int)23)) {
            return "HDF5CDataTypes.JH5T_INTEL_B64";
        }
        if (data_type == H5.J2C((int)24)) {
            return "HDF5CDataTypes.JH5T_INTEL_B8";
        }
        if (data_type == H5.J2C((int)25)) {
            return "HDF5CDataTypes.JH5T_INTEL_F32";
        }
        if (data_type == H5.J2C((int)26)) {
            return "HDF5CDataTypes.JH5T_INTEL_F64";
        }
        if (data_type == H5.J2C((int)27)) {
            return "HDF5CDataTypes.JH5T_INTEL_I16";
        }
        if (data_type == H5.J2C((int)28)) {
            return "HDF5CDataTypes.JH5T_INTEL_I32";
        }
        if (data_type == H5.J2C((int)29)) {
            return "HDF5CDataTypes.JH5T_INTEL_I64";
        }
        if (data_type == H5.J2C((int)30)) {
            return "HDF5CDataTypes.JH5T_INTEL_I8";
        }
        if (data_type == H5.J2C((int)31)) {
            return "HDF5CDataTypes.JH5T_INTEL_U16";
        }
        if (data_type == H5.J2C((int)32)) {
            return "HDF5CDataTypes.JH5T_INTEL_U32";
        }
        if (data_type == H5.J2C((int)33)) {
            return "HDF5CDataTypes.JH5T_INTEL_U64";
        }
        if (data_type == H5.J2C((int)34)) {
            return "HDF5CDataTypes.JH5T_INTEL_U8";
        }
        if (data_type == H5.J2C((int)35)) {
            return "HDF5CDataTypes.JH5T_MIPS_B16";
        }
        if (data_type == H5.J2C((int)36)) {
            return "HDF5CDataTypes.JH5T_MIPS_B32";
        }
        if (data_type == H5.J2C((int)37)) {
            return "HDF5CDataTypes.JH5T_MIPS_B64";
        }
        if (data_type == H5.J2C((int)38)) {
            return "HDF5CDataTypes.JH5T_MIPS_B8";
        }
        if (data_type == H5.J2C((int)39)) {
            return "HDF5CDataTypes.JH5T_MIPS_F32";
        }
        if (data_type == H5.J2C((int)40)) {
            return "HDF5CDataTypes.JH5T_MIPS_F64";
        }
        if (data_type == H5.J2C((int)41)) {
            return "HDF5CDataTypes.JH5T_MIPS_I16";
        }
        if (data_type == H5.J2C((int)42)) {
            return "HDF5CDataTypes.JH5T_MIPS_I32";
        }
        if (data_type == H5.J2C((int)43)) {
            return "HDF5CDataTypes.JH5T_MIPS_I64";
        }
        if (data_type == H5.J2C((int)44)) {
            return "HDF5CDataTypes.JH5T_MIPS_I8";
        }
        if (data_type == H5.J2C((int)45)) {
            return "HDF5CDataTypes.JH5T_MIPS_U16";
        }
        if (data_type == H5.J2C((int)46)) {
            return "HDF5CDataTypes.JH5T_MIPS_U32";
        }
        if (data_type == H5.J2C((int)47)) {
            return "HDF5CDataTypes.JH5T_MIPS_U64 ";
        }
        if (data_type == H5.J2C((int)48)) {
            return "HDF5CDataTypes.JH5T_MIPS_U8";
        }
        if (data_type == H5.J2C((int)49)) {
            return "HDF5CDataTypes.JH5T_NATIVE_B16";
        }
        if (data_type == H5.J2C((int)50)) {
            return "HDF5CDataTypes.JH5T_NATIVE_B32";
        }
        if (data_type == H5.J2C((int)51)) {
            return "HDF5CDataTypes.JH5T_NATIVE_B64";
        }
        if (data_type == H5.J2C((int)52)) {
            return "HDF5CDataTypes.JH5T_NATIVE_B8";
        }
        if (data_type == H5.J2C((int)53)) {
            return "HDF5CDataTypes.JH5T_NATIVE_CHAR";
        }
        if (data_type == H5.J2C((int)54)) {
            return "HDF5CDataTypes.JH5T_NATIVE_DOUBLE";
        }
        if (data_type == H5.J2C((int)55)) {
            return "HDF5CDataTypes.JH5T_NATIVE_FLOAT";
        }
        if (data_type == H5.J2C((int)56)) {
            return "HDF5CDataTypes.JH5T_NATIVE_HBOOL";
        }
        if (data_type == H5.J2C((int)57)) {
            return "HDF5CDataTypes.JH5T_NATIVE_HERR";
        }
        if (data_type == H5.J2C((int)58)) {
            return "HDF5CDataTypes.JH5T_NATIVE_HSIZE";
        }
        if (data_type == H5.J2C((int)59)) {
            return "HDF5CDataTypes.JH5T_NATIVE_HSSIZE";
        }
        if (data_type == H5.J2C((int)60)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT";
        }
        if (data_type == H5.J2C((int)61)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_FAST16";
        }
        if (data_type == H5.J2C((int)62)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_FAST32";
        }
        if (data_type == H5.J2C((int)63)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_FAST64";
        }
        if (data_type == H5.J2C((int)64)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_FAST8";
        }
        if (data_type == H5.J2C((int)65)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_LEAST16";
        }
        if (data_type == H5.J2C((int)66)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_LEAST32";
        }
        if (data_type == H5.J2C((int)67)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_LEAST64";
        }
        if (data_type == H5.J2C((int)68)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT_LEAST8";
        }
        if (data_type == H5.J2C((int)69)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT16";
        }
        if (data_type == H5.J2C((int)70)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT32";
        }
        if (data_type == H5.J2C((int)71)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT64";
        }
        if (data_type == H5.J2C((int)72)) {
            return "HDF5CDataTypes.JH5T_NATIVE_INT8";
        }
        if (data_type == H5.J2C((int)73)) {
            return "HDF5CDataTypes.JH5T_NATIVE_LDOUBLE";
        }
        if (data_type == H5.J2C((int)74)) {
            return "HDF5CDataTypes.JH5T_NATIVE_LLONG";
        }
        if (data_type == H5.J2C((int)75)) {
            return "HDF5CDataTypes.JH5T_NATIVE_LONG";
        }
        if (data_type == H5.J2C((int)76)) {
            return "HDF5CDataTypes.JH5T_NATIVE_OPAQUE";
        }
        if (data_type == H5.J2C((int)77)) {
            return "HDF5CDataTypes.JH5T_NATIVE_SCHAR";
        }
        if (data_type == H5.J2C((int)78)) {
            return "HDF5CDataTypes.JH5T_NATIVE_SHORT";
        }
        if (data_type == H5.J2C((int)79)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UCHAR";
        }
        if (data_type == H5.J2C((int)80)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT";
        }
        if (data_type == H5.J2C((int)81)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_FAST16";
        }
        if (data_type == H5.J2C((int)82)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_FAST32";
        }
        if (data_type == H5.J2C((int)83)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_FAST64";
        }
        if (data_type == H5.J2C((int)84)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_FAST8";
        }
        if (data_type == H5.J2C((int)85)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_LEAST16";
        }
        if (data_type == H5.J2C((int)86)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_LEAST32";
        }
        if (data_type == H5.J2C((int)87)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_LEAST64";
        }
        if (data_type == H5.J2C((int)88)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT_LEAST8";
        }
        if (data_type == H5.J2C((int)89)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT16";
        }
        if (data_type == H5.J2C((int)90)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT32";
        }
        if (data_type == H5.J2C((int)91)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT64 ";
        }
        if (data_type == H5.J2C((int)92)) {
            return "HDF5CDataTypes.JH5T_NATIVE_UINT8";
        }
        if (data_type == H5.J2C((int)93)) {
            return "HDF5CDataTypes.JH5T_NATIVE_ULLONG";
        }
        if (data_type == H5.J2C((int)94)) {
            return "HDF5CDataTypes.JH5T_NATIVE_ULONG";
        }
        if (data_type == H5.J2C((int)95)) {
            return "HDF5CDataTypes.JH5T_NATIVE_USHORT";
        }
        if (data_type == H5.J2C((int)96)) {
            return "HDF5CDataTypes.JH5T_NCSET";
        }
        if (data_type == H5.J2C((int)97)) {
            return "HDF5CDataTypes.JH5T_NSTR";
        }
        if (data_type == H5.J2C((int)98)) {
            return "HDF5CDataTypes.JH5T_STD_B16BE";
        }
        if (data_type == H5.J2C((int)99)) {
            return "HDF5CDataTypes.JH5T_STD_B16LE";
        }
        if (data_type == H5.J2C((int)100)) {
            return "HDF5CDataTypes.JH5T_STD_B32BE";
        }
        if (data_type == H5.J2C((int)101)) {
            return "HDF5CDataTypes.JH5T_STD_B32LE";
        }
        if (data_type == H5.J2C((int)102)) {
            return "HDF5CDataTypes.JH5T_STD_B64BE";
        }
        if (data_type == H5.J2C((int)103)) {
            return "HDF5CDataTypes.JH5T_STD_B64LE";
        }
        if (data_type == H5.J2C((int)104)) {
            return "HDF5CDataTypes.JH5T_STD_B8BE";
        }
        if (data_type == H5.J2C((int)105)) {
            return "HDF5CDataTypes.JH5T_STD_B8LE";
        }
        if (data_type == H5.J2C((int)106)) {
            return "HDF5CDataTypes.JH5T_STD_I16BE";
        }
        if (data_type == H5.J2C((int)107)) {
            return "HDF5CDataTypes.JH5T_STD_I16LE";
        }
        if (data_type == H5.J2C((int)108)) {
            return "HDF5CDataTypes.JH5T_STD_I32BE";
        }
        if (data_type == H5.J2C((int)109)) {
            return "HDF5CDataTypes.JH5T_STD_I32LE";
        }
        if (data_type == H5.J2C((int)110)) {
            return "HDF5CDataTypes.JH5T_STD_I64BE";
        }
        if (data_type == H5.J2C((int)111)) {
            return "HDF5CDataTypes.JH5T_STD_I64LE";
        }
        if (data_type == H5.J2C((int)112)) {
            return "HDF5CDataTypes.JH5T_STD_I8BE";
        }
        if (data_type == H5.J2C((int)113)) {
            return "HDF5CDataTypes.JH5T_STD_I8LE";
        }
        if (data_type == H5.J2C((int)114)) {
            return "HDF5CDataTypes.JH5T_STD_REF_DSETREG";
        }
        if (data_type == H5.J2C((int)115)) {
            return "HDF5CDataTypes.JH5T_STD_REF_OBJ";
        }
        if (data_type == H5.J2C((int)116)) {
            return "HDF5CDataTypes.JH5T_STD_U16BE";
        }
        if (data_type == H5.J2C((int)117)) {
            return "HDF5CDataTypes.JH5T_STD_U16LE";
        }
        if (data_type == H5.J2C((int)118)) {
            return "HDF5CDataTypes.JH5T_STD_U32BE";
        }
        if (data_type == H5.J2C((int)119)) {
            return "HDF5CDataTypes.JH5T_STD_U32LE";
        }
        if (data_type == H5.J2C((int)120)) {
            return "HDF5CDataTypes.JH5T_STD_U64BE";
        }
        if (data_type == H5.J2C((int)121)) {
            return "HDF5CDataTypes.JH5T_STD_U64LE";
        }
        if (data_type == H5.J2C((int)122)) {
            return "HDF5CDataTypes.JH5T_STD_U8BE";
        }
        if (data_type == H5.J2C((int)123)) {
            return "HDF5CDataTypes.JH5T_STD_U8LE";
        }
        if (data_type == H5.J2C((int)124)) {
            return "HDF5CDataTypes.JH5T_UNIX_D32BE";
        }
        if (data_type == H5.J2C((int)125)) {
            return "HDF5CDataTypes.JH5T_UNIX_D32LE";
        }
        if (data_type == H5.J2C((int)126)) {
            return "HDF5CDataTypes.JH5T_UNIX_D64BE";
        }
        if (data_type == H5.J2C((int)127)) {
            return "HDF5CDataTypes.JH5T_UNIX_D64LE";
        }
        if (data_type == H5.J2C((int)76)) {
            return "H5T_NATIVE_OPAQUE";
        }
        return "Unknown";
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            H5.H5Tclose((int)this.id);
        }
    }
}

