/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdf5.hdf5objects;

import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import visad.data.hdf5.hdf5objects.HDF5Object;

public class HDF5Group
extends HDF5Object {
    protected Vector members;
    protected HDF5Group parent;

    public HDF5Group() {
        this.type = 1;
        this.members = new Vector();
    }

    public HDF5Group(int loc_id, String gname, int name_length) {
        super(gname);
        this.type = 1;
        this.members = new Vector();
        if (name_length <= 0) {
            name_length = gname.length();
        }
        try {
            this.id = H5.H5Gcreate((int)loc_id, (String)this.name, (int)name_length);
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Group: " + (Object)((Object)e));
            this.id = -1;
        }
    }

    public HDF5Group(int loc_id, String name) {
        super(name);
        this.type = 1;
        this.members = new Vector();
        try {
            this.id = H5.H5Gopen((int)loc_id, (String)name);
        }
        catch (HDF5Exception e) {
            System.err.println("HDF5Group: " + (Object)((Object)e));
            this.id = -1;
        }
    }

    public void setParent(HDF5Group p) {
        this.parent = p;
    }

    public boolean contains(Object member) {
        return this.members.contains(member);
    }

    public void addMember(Object member) {
        if (!this.contains(member)) {
            this.members.addElement(member);
        }
    }

    public void removeMemberAt(int index) {
        this.members.removeElementAt(index);
    }

    public boolean removeMember(Object member) {
        return this.members.removeElement(member);
    }

    public Vector getMembers() {
        return this.members;
    }

    public HDF5Group getParent() {
        return this.parent;
    }

    public Object getMemberAt(int memberIndex) {
        return this.members.elementAt(memberIndex);
    }

    public int getMemberCount() {
        if (this.members == null) {
            return -1;
        }
        return this.members.size();
    }

    public boolean isEmpty() {
        return this.members == null || this.members.size() <= 0;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    @Override
    public synchronized String toString() {
        return this.getClass().getName() + "[name=" + this.name + ",members=" + this.members.toString() + "]";
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            H5.H5Gclose((int)this.id);
        }
    }
}

