/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueVetter;

final class DoubleValueVetter
extends ValueVetter {
    private double doubleValue1;
    private double doubleValue2;
    private float floatValue1;
    private float floatValue2;
    private static final WeakHashMap map = new WeakHashMap();

    private DoubleValueVetter(double value1, double value2) {
        this.doubleValue1 = value1;
        this.doubleValue2 = value2;
        this.floatValue1 = (float)value1;
        this.floatValue2 = (float)value2;
    }

    static synchronized DoubleValueVetter doubleValueVetter(double value1, double value2) {
        DoubleValueVetter vetter = new DoubleValueVetter(value1, value2);
        WeakReference ref = (WeakReference)map.get(vetter);
        if (ref == null) {
            map.put(vetter, new WeakReference<DoubleValueVetter>(vetter));
        } else {
            DoubleValueVetter oldVetter = (DoubleValueVetter)ref.get();
            if (oldVetter == null) {
                map.put(vetter, new WeakReference<DoubleValueVetter>(vetter));
            } else {
                vetter = oldVetter;
            }
        }
        return vetter;
    }

    @Override
    public float process(float value) {
        return value == this.floatValue1 || value == this.floatValue2 ? Float.NaN : value;
    }

    @Override
    public double process(double value) {
        return value == this.doubleValue1 || value == this.doubleValue2 ? Double.NaN : value;
    }

    @Override
    public float[] process(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            float value = values[i];
            if (value != this.floatValue1 && value != this.floatValue2) continue;
            values[i] = Float.NaN;
        }
        return values;
    }

    @Override
    public double[] process(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            if (value != this.doubleValue1 && value != this.doubleValue2) continue;
            values[i] = Double.NaN;
        }
        return values;
    }

    public boolean equals(Object obj) {
        DoubleValueVetter that;
        boolean equals = !this.getClass().isInstance(obj) ? false : this == (that = (DoubleValueVetter)obj) || this.doubleValue1 == that.doubleValue1 && this.doubleValue2 == that.doubleValue2;
        return equals;
    }

    public int hashCode() {
        return new Double(this.doubleValue1).hashCode() ^ new Double(this.doubleValue2).hashCode();
    }
}

