/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.util.Enumeration;
import java.util.Vector;
import org.scijava.java3d.Switch;
import visad.AVControl;
import visad.AVHandler;
import visad.Control;
import visad.CoordinateSystem;
import visad.DataRenderer;
import visad.RealTupleType;
import visad.Set;
import visad.SetType;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.TrajectoryAVHandlerJ3D;

public abstract class AVControlJ3D
extends Control
implements AVControl {
    transient Vector switches = new Vector();
    private int interval = -1;

    public AVControlJ3D(DisplayImplJ3D d) {
        super(d);
    }

    public void addPair(Switch sw, Set se, DataRenderer re) {
        this.switches.addElement(new SwitchSet(sw, se, re));
    }

    public void addPair(Switch sw, Set se, DataRenderer re, TrajectoryAVHandlerJ3D adptr) {
        this.switches.addElement(new SwitchSet(sw, se, re, adptr));
    }

    @Override
    public void nullControl() {
        this.switches.removeAllElements();
        super.nullControl();
    }

    public abstract void init() throws VisADException;

    public void setInterval(int interval) {
        this.interval = interval;
    }

    private int getIndexForRange(Set set, double lower, double upper) throws VisADException {
        double[][] values = set.getDoubles(false);
        for (int i = 0; i < values[0].length; ++i) {
            if (!(values[0][i] >= lower) || !(values[0][i] < upper)) continue;
            return i;
        }
        return -1;
    }

    public void selectSwitches(double value, Set animation_set) throws VisADException {
        if (value != value) {
            return;
        }
        double[][] fvalues = new double[1][1];
        fvalues[0][0] = value;
        Enumeration pairs = ((Vector)this.switches.clone()).elements();
        while (pairs.hasMoreElements()) {
            int[] indices;
            SwitchSet ss = (SwitchSet)pairs.nextElement();
            Set set = ss.set;
            double[][] values = null;
            RealTupleType out = ((SetType)set.getType()).getDomain();
            if (animation_set != null) {
                RealTupleType in = ((SetType)animation_set.getType()).getDomain();
                values = CoordinateSystem.transformCoordinates(out, set.getCoordinateSystem(), set.getSetUnits(), null, in, animation_set.getCoordinateSystem(), animation_set.getSetUnits(), null, fvalues);
            } else {
                values = CoordinateSystem.transformCoordinates(out, set.getCoordinateSystem(), set.getSetUnits(), null, out, out.getCoordinateSystem(), out.getDefaultUnits(), null, fvalues);
            }
            if (this.interval == -1) {
                indices = set.getLength() == 1 ? new int[]{0} : set.doubleToIndex(values);
            } else {
                double resInSecs = (double)this.interval * 60.0;
                double lower = values[0][0] - resInSecs / 2.0;
                double upper = values[0][0] + resInSecs / 2.0;
                indices = new int[]{this.getIndexForRange(set, lower, upper)};
            }
            if (0 <= indices[0] && indices[0] < ss.swit.numChildren()) {
                ss.setWhichChild(indices[0]);
                continue;
            }
            ss.setWhichChild(-1);
        }
    }

    @Override
    public void clearSwitches(DataRenderer re) {
        Enumeration pairs = ((Vector)this.switches.clone()).elements();
        while (pairs.hasMoreElements()) {
            SwitchSet ss = (SwitchSet)pairs.nextElement();
            if (!ss.renderer.equals(re)) continue;
            this.switches.removeElement(ss);
        }
    }

    public Vector getSwitches() {
        return this.switches;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AVControlJ3D av = (AVControlJ3D)o;
        if (this.switches == null) {
            return av.switches == null;
        }
        if (av.switches != null) {
            if (this.switches.size() != av.switches.size()) {
                return false;
            }
            for (int i = this.switches.size() - 1; i > 0; --i) {
                if (this.switches.elementAt(i).equals(av.switches.elementAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    protected class SwitchSet {
        Switch swit;
        Set set;
        DataRenderer renderer;
        AVHandler handler;

        SwitchSet(Switch sw, Set se, DataRenderer re) {
            this.swit = sw;
            this.set = se;
            this.renderer = re;
        }

        SwitchSet(Switch sw, Set se, DataRenderer re, AVHandler adptr) {
            this.swit = sw;
            this.set = se;
            this.renderer = re;
            this.handler = adptr;
        }

        void setWhichChild(int idx) {
            if (this.handler == null) {
                this.swit.setWhichChild(idx);
            } else {
                this.handler.setWhichChild(idx);
            }
        }
    }
}

