/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DoubleSet;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.Function;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded2DSet;
import visad.Gridded3DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.data.DefaultFamily;

public class DumpType {
    private static boolean init = true;
    private static OutputStream os;

    public static void dumpDataType(Data d) {
        DumpType.dumpDataType(d, System.out);
    }

    public static void dumpDataType(Data d, OutputStream uos) {
        os = uos;
        DumpType.dumpDT(d, " ");
    }

    private static void dumpDT(Data d, String prefix) {
        PrintStream out;
        PrintStream printStream = out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        if (init) {
            out.println("VisAD Data analysis");
        }
        init = false;
        try {
            if (d instanceof FlatField) {
                int nr = ((FlatField)d).getRangeDimension();
                int nd = ((FlatField)d).getDomainDimension();
                Set ds = ((FlatField)d).getDomainSet();
                prefix = prefix + "  ";
                out.println(prefix + " FlatField of length = " + ((FlatField)d).getLength());
                out.println(prefix + " " + ((FlatField)d).getType().prettyString());
                prefix = prefix + "  ";
                out.println(prefix + " Domain has " + nd + " components:");
                DumpType.dumpDT(ds, prefix + "  ");
                DumpType.dumpDomainCS(ds, prefix + "  ");
                out.println(prefix + " Range has " + nr + " components:");
                Set[] dr = ((FlatField)d).getRangeSets();
                float[][] samples = ((FlatField)d).getFloats(false);
                for (int i = 0; i < dr.length; ++i) {
                    DumpType.dumpDT(dr[i], prefix + "   " + i + ".");
                    int nmiss = 0;
                    if (samples[i] == null) {
                        nmiss = ((FlatField)d).getLength();
                    } else {
                        for (int j = 0; j < samples[i].length; ++j) {
                            if (samples[i][j] == samples[i][j]) continue;
                            ++nmiss;
                        }
                    }
                    out.println(prefix + "   " + i + ". number missing = " + nmiss);
                }
            } else if (d instanceof FieldImpl) {
                int nd = ((FieldImpl)d).getDomainDimension();
                Set ds = ((FieldImpl)d).getDomainSet();
                out.println(prefix + " FieldImpl of length = " + ((FieldImpl)d).getLength());
                out.println(prefix + " " + ((FieldImpl)d).getType().prettyString());
                out.println(prefix + " Domain has " + nd + " components:");
                DumpType.dumpDT(ds, prefix + "  ");
                out.println(prefix + " first sample = ");
                DumpType.dumpDT(((FieldImpl)d).getSample(0, false), prefix + "   " + 0 + ".");
            } else if (d instanceof Field) {
                out.println(prefix + " Field: ");
            } else if (d instanceof Function) {
                out.println(prefix + " Function: ");
                out.println(prefix + "    Domain dimension= " + ((Function)d).getDomainDimension());
            } else if (d instanceof Irregular3DSet) {
                out.println(prefix + " Irregular3DSet " + DumpType.name(((Irregular3DSet)d).getType().toString()) + " Length = " + ((Irregular3DSet)d).getLength());
            } else if (d instanceof Irregular2DSet) {
                out.println(prefix + " Irregular2DSet " + DumpType.name(((Irregular2DSet)d).getType().toString()) + " Length = " + ((Irregular2DSet)d).getLength());
            } else if (d instanceof Irregular1DSet) {
                out.println(prefix + " Irregular1DSet " + DumpType.name(((Irregular1DSet)d).getType().toString()) + " Length = " + ((Irregular1DSet)d).getLength());
            } else if (d instanceof IrregularSet) {
                out.println(prefix + " IrregularSet " + DumpType.name(((IrregularSet)d).getType().toString()) + " Length = " + ((IrregularSet)d).getLength());
            } else if (d instanceof Integer3DSet) {
                out.println(prefix + " Integer3DSet: Length = " + ((Integer3DSet)d).getLength());
                for (int i = 0; i < 3; ++i) {
                    DumpType.dumpDT(((Linear3DSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                }
            } else if (d instanceof Linear3DSet) {
                out.println(prefix + " Linear3DSet: Length = " + ((Linear3DSet)d).getLength());
                for (int i = 0; i < 3; ++i) {
                    DumpType.dumpDT(((Linear3DSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                }
            } else if (d instanceof Gridded3DDoubleSet) {
                out.println(prefix + " Gridded3DDoubleSet " + DumpType.name(((Gridded3DDoubleSet)d).getType().toString()) + " Length = " + ((Gridded3DDoubleSet)d).getLength());
            } else if (d instanceof Gridded3DSet) {
                out.println(prefix + " Gridded3DSet " + DumpType.name(((Gridded3DSet)d).getType().toString()) + " Length = " + ((Gridded3DSet)d).getLength());
            } else if (d instanceof Integer2DSet) {
                out.println(prefix + " Integer2DSet: Length = " + ((Integer2DSet)d).getLength());
                for (int i = 0; i < 2; ++i) {
                    DumpType.dumpDT(((Linear2DSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                }
            } else if (d instanceof Linear2DSet) {
                out.println(prefix + " Linear2DSet: Length = " + ((Linear2DSet)d).getLength());
                for (int i = 0; i < 2; ++i) {
                    DumpType.dumpDT(((Linear2DSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                }
            } else if (d instanceof Gridded2DDoubleSet) {
                out.println(prefix + " Gridded2DDoubleSet " + DumpType.name(((Gridded2DDoubleSet)d).getType().toString()) + " Length = " + ((Gridded2DDoubleSet)d).getLength());
            } else if (d instanceof Gridded2DSet) {
                out.println(prefix + " Gridded2DSet " + DumpType.name(((Gridded2DSet)d).getType().toString()) + " Length = " + ((Gridded2DSet)d).getLength());
            } else if (d instanceof Integer1DSet) {
                out.println(prefix + " Integer1DSet " + DumpType.name(((Integer1DSet)d).getType().toString()) + " Range = 0 to " + (((Integer1DSet)d).getLength() - 1));
            } else if (d instanceof Linear1DSet) {
                out.println(prefix + " Linear1DSet " + DumpType.name(((Linear1DSet)d).getType().toString()) + " Range = " + ((Linear1DSet)d).getFirst() + " to " + ((Linear1DSet)d).getLast() + " step " + ((Linear1DSet)d).getStep());
            } else if (d instanceof Gridded1DDoubleSet) {
                out.println(prefix + " Gridded1DDoubleSet " + DumpType.name(((Gridded1DDoubleSet)d).getType().toString()) + "  Length = " + ((Gridded1DDoubleSet)d).getLength());
            } else if (d instanceof Gridded1DSet) {
                out.println(prefix + " Gridded1DSet " + DumpType.name(((Gridded1DSet)d).getType().toString()) + "  Length = " + ((Gridded1DSet)d).getLength());
            } else if (d instanceof IntegerNDSet) {
                out.println(prefix + " IntegerNDSet: Dimension = " + ((IntegerNDSet)d).getDimension());
                for (int i = 0; i < ((IntegerNDSet)d).getDimension(); ++i) {
                    DumpType.dumpDT(((LinearNDSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                }
            } else if (d instanceof LinearNDSet) {
                out.println(prefix + " LinearNDSet: Dimension = " + ((LinearNDSet)d).getDimension());
                for (int i = 0; i < ((LinearNDSet)d).getDimension(); ++i) {
                    DumpType.dumpDT(((LinearNDSet)d).getLinear1DComponent(i), prefix + "   " + i + ".");
                }
            } else if (d instanceof GriddedSet) {
                out.println(prefix + " GriddedSet " + DumpType.name(((GriddedSet)d).getType().toString()) + "  Dimension = " + ((GriddedSet)d).getDimension());
            } else if (d instanceof UnionSet) {
                out.println(prefix + " UnionSet " + DumpType.name(((UnionSet)d).getType().toString()) + "  Dimension = " + ((UnionSet)d).getDimension());
            } else if (d instanceof ProductSet) {
                out.println(prefix + " ProductSet " + DumpType.name(((ProductSet)d).getType().toString()) + "  Dimension = " + ((ProductSet)d).getDimension());
            } else if (d instanceof SampledSet) {
                out.println(prefix + " SampledSet " + DumpType.name(((SampledSet)d).getType().toString()) + "  Dimension = " + ((SampledSet)d).getDimension());
            } else if (d instanceof FloatSet) {
                out.println(prefix + " FloatSet " + DumpType.name(((FloatSet)d).getType().toString()) + " Dimension = " + ((FloatSet)d).getDimension());
            } else if (d instanceof DoubleSet) {
                out.println(prefix + " DoubleSet " + DumpType.name(((DoubleSet)d).getType().toString()) + "  Dimension = " + ((DoubleSet)d).getDimension());
            } else if (d instanceof SimpleSet) {
                out.println(prefix + " SimpleSet: ");
            } else if (d instanceof Set) {
                out.println(prefix + " Set: ");
            } else if (d instanceof RealTuple) {
                int n = ((RealTuple)d).getDimension();
                out.println(prefix + " RealTuple has " + n + " components:");
                RealTuple df = (RealTuple)d;
                for (int i = 0; i < n; ++i) {
                    DumpType.dumpDT(((RealTuple)d).getComponent(i), prefix + "   " + i + ".");
                }
            } else if (d instanceof Tuple) {
                int n = ((Tuple)d).getDimension();
                out.println(prefix + " Tuple has " + n + " components:");
                Tuple df = (Tuple)d;
                for (int i = 0; i < n; ++i) {
                    out.println("  ");
                    DumpType.dumpDT(((Tuple)d).getComponent(i), prefix + "   " + i + ".");
                }
            } else if (d instanceof Text) {
                out.println(prefix + " Text: " + d);
            } else if (d instanceof Real) {
                out.println(prefix + " Real: " + d);
            } else {
                out.println("Unknown type for " + d);
            }
        }
        catch (Exception e) {
            out.println("Exception:" + e);
            return;
        }
    }

    private static String name(String n) {
        return n.substring(n.lastIndexOf("("));
    }

    public static void dumpMathType(MathType t) {
        DumpType.dumpMathType(t, System.out);
    }

    public static void dumpMathType(MathType t, OutputStream uos) {
        os = uos;
        DumpType.dumpMT(t, " ");
    }

    private static void dumpMT(MathType t, String prefix) {
        PrintStream out;
        PrintStream printStream = out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        if (init) {
            out.println("VisAD MathType analysis");
        }
        init = false;
        try {
            if (t instanceof FunctionType) {
                out.println(prefix + " FunctionType: ");
                RealTupleType domain = ((FunctionType)t).getDomain();
                int num = domain.getDimension();
                out.println(prefix + " Domain has " + num + " components:");
                for (int i = 0; i < num; ++i) {
                    MathType comp = domain.getComponent(i);
                    DumpType.dumpMT(comp, prefix + "  " + i + ".");
                }
                out.println(prefix + " Range:");
                MathType range = ((FunctionType)t).getRange();
                DumpType.dumpMT(range, prefix + "  ");
            } else if (t instanceof SetType) {
                out.println(prefix + " SetType: " + t);
            } else if (t instanceof RealTupleType) {
                int num = ((RealTupleType)t).getDimension();
                out.println(prefix + " RealTupleType has " + num + " components:");
                for (int i = 0; i < num; ++i) {
                    MathType comp = ((RealTupleType)t).getComponent(i);
                    DumpType.dumpMT(comp, prefix + "  " + i + ".");
                }
            } else if (t instanceof TupleType) {
                int num = ((TupleType)t).getDimension();
                out.println(prefix + " TupleType has " + num + " components:");
                for (int i = 0; i < num; ++i) {
                    MathType comp = ((TupleType)t).getComponent(i);
                    DumpType.dumpMT(comp, prefix + "  " + i + ".");
                }
            } else if (t instanceof TextType) {
                out.println(prefix + " TextType: " + t);
            } else if (t instanceof RealType) {
                Set ds;
                out.println(prefix + " RealType: " + t);
                prefix = prefix + "  ";
                out.println(prefix + " Name = " + ((RealType)t).toString());
                Unit du = ((RealType)t).getDefaultUnit();
                String s = null;
                if (du != null) {
                    s = du.toString();
                }
                if (s != null) {
                    out.println(prefix + " Unit: " + s);
                }
                if ((ds = ((RealType)t).getDefaultSet()) != null) {
                    MathType dsmt = ds.getType();
                    out.println(prefix + " Set: " + dsmt);
                }
            } else if (t instanceof ScalarType) {
                out.println(prefix + " ScaleType: " + t);
            } else {
                out.println("Unknown type for " + t);
            }
        }
        catch (Exception e) {
            out.println("Exception:" + e);
            return;
        }
    }

    private static void dumpDomainCS(Set s, String prefix) {
        RealTupleType ref;
        RealTupleType rtt = ((SetType)s.getType()).getDomain();
        CoordinateSystem cs = s.getCoordinateSystem();
        if (cs != null && (ref = cs.getReference()) != null) {
            PrintStream out = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
            out.println(prefix + " CoordinateSystem: " + rtt.prettyString() + " ==> " + ref.prettyString());
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: visad.jmet.DumpType <infile> ");
            System.exit(1);
            return;
        }
        DefaultFamily fr = new DefaultFamily("sample");
        URL url = null;
        try {
            url = new URL(args[0]);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            if (url != null) {
                System.out.println("Trying URL " + url.toString());
            } else {
                System.out.println("Trying file " + args[0]);
            }
            DataImpl data = url == null ? fr.open(args[0]) : fr.open(url);
            System.out.println(args[0] + ": " + data.getType().prettyString());
            System.out.println("  ");
            if (data != null) {
                DumpType.dumpDataType(data, System.out);
                MathType t = data.getType();
                init = true;
                System.out.println("  ");
                DumpType.dumpMathType(t, System.out);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(1);
        }
        System.exit(0);
    }
}

