/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.spring;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.IdentitySetter;

public class SpringQuery
implements SqlQuery {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    JdbcTemplate jdbcTemplate;
    String queryString;
    List<String> scalars = new ArrayList<String>();
    Map<String, Object> scalarTypes = new HashMap<String, Object>();
    List<String> parameters = new ArrayList<String>();
    Map<String, Object> parameterValues = new HashMap<String, Object>();
    Map<String, Object> parameterTypes = new HashMap<String, Object>();
    List<String> identities = new ArrayList<String>();
    Map<String, IdentitySetter> identitySetters = new HashMap<String, IdentitySetter>();
    Map<String, Object> identityTypes = new HashMap<String, Object>();
    Integer timeout;
    Integer firstResult;
    Integer maxResults;

    public SpringQuery(JdbcTemplate jdbcTemplate, String queryString) {
        this.jdbcTemplate = jdbcTemplate;
        this.queryString = queryString;
    }

    public Object getQuery() {
        return this.jdbcTemplate;
    }

    public SqlQuery setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public SqlQuery setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public SqlQuery setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public List list() throws SqlProcessorException {
        String query;
        StringBuilder queryResult = this.maxResults != null ? new StringBuilder(this.queryString.length() + 100) : null;
        final SqlUtils.LimitType limitType = this.maxResults != null ? SqlUtils.limitQuery((String)this.queryString, (StringBuilder)queryResult, (Integer)this.firstResult, (Integer)this.maxResults) : null;
        String string = query = limitType != null ? queryResult.toString() : this.queryString;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("list, query=" + query);
        }
        PreparedStatementCreator psc = new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(query);
                if (SpringQuery.this.timeout != null) {
                    ps.setQueryTimeout(SpringQuery.this.timeout);
                }
                return ps;
            }
        };
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                SpringQuery.this.setParameters(ps, limitType);
            }
        };
        ResultSetExtractor<List> rse = new ResultSetExtractor<List>(){

            public List extractData(ResultSet rs) throws SQLException, DataAccessException {
                return SpringQuery.this.getResults(rs);
            }
        };
        try {
            List list = (List)this.jdbcTemplate.query(psc, pss, (ResultSetExtractor)rse);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("list, number of returned rows=" + (list != null ? Integer.valueOf(list.size()) : "null"));
            }
            return list;
        }
        catch (DataAccessException dae) {
            throw new SqlProcessorException((Throwable)dae);
        }
    }

    public Object uniqueResult() throws SqlProcessorException {
        List list = this.list();
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Object first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new SqlProcessorException("There's no unique result, the number of returned rows is " + list.size());
        }
        return first;
    }

    public int executeUpdate() throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("update, query=" + this.queryString);
        }
        PreparedStatementCreator psc = new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(SpringQuery.this.queryString);
                if (SpringQuery.this.timeout != null) {
                    ps.setQueryTimeout(SpringQuery.this.timeout);
                }
                return ps;
            }
        };
        PreparedStatementSetter pss = new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                SpringQuery.this.setParameters(ps, null);
            }
        };
        try {
            int updated = this.update(psc, pss);
            if (!this.identities.isEmpty()) {
                String identityName = this.identities.get(0);
                this.doIdentitySelect(identityName);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("update, number of updated rows=" + updated);
            }
            return updated;
        }
        catch (DataAccessException dae) {
            throw new SqlProcessorException((Throwable)dae);
        }
    }

    private void doIdentitySelect(final String identityName) {
        final IdentitySetter identitySetter = this.identitySetters.get(identityName);
        final Object identityType = this.identityTypes.get(identityName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("identity, name=" + identityName + ", select=" + identitySetter.getIdentitySelect() + ", identityType=" + identityType);
        }
        PreparedStatementCreator psc = new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(identitySetter.getIdentitySelect());
                return ps;
            }
        };
        ResultSetExtractor<Object> rse = new ResultSetExtractor<Object>(){

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                Object identityValue = null;
                while (rs.next()) {
                    identityValue = identityType != null && identityType instanceof JdbcSqlType ? ((JdbcSqlType)identityType).get(rs, identityName) : rs.getObject(1);
                    if (!rs.wasNull()) continue;
                    identityValue = null;
                }
                return identityValue;
            }
        };
        try {
            Object identityValue = this.jdbcTemplate.query(psc, null, (ResultSetExtractor)rse);
            identitySetter.setIdentity(identityValue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("identity, result=" + identityValue);
            }
        }
        catch (DataAccessException dae) {
            throw new SqlProcessorException((Throwable)dae);
        }
    }

    protected int update(PreparedStatementCreator psc, final PreparedStatementSetter pss) throws DataAccessException {
        this.logger.debug("Executing prepared SQL update");
        return (Integer)this.jdbcTemplate.execute(psc, (PreparedStatementCallback)new PreparedStatementCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    int rows = ps.executeUpdate();
                    if (SpringQuery.this.logger.isDebugEnabled()) {
                        SpringQuery.this.logger.debug("SQL update affected " + rows + " rows");
                    }
                    Integer n = rows;
                    return n;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)pss).cleanupParameters();
                    }
                }
            }
        });
    }

    public SqlQuery addScalar(String columnAlias) {
        this.scalars.add(columnAlias);
        return this;
    }

    public SqlQuery addScalar(String columnAlias, Object type) {
        this.scalars.add(columnAlias);
        this.scalarTypes.put(columnAlias, type);
        return this;
    }

    public SqlQuery setParameter(String name, Object val) throws SqlProcessorException {
        this.parameters.add(name);
        this.parameterValues.put(name, val);
        return this;
    }

    public SqlQuery setParameter(String name, Object val, Object type) throws SqlProcessorException {
        if (val != null && val instanceof IdentitySetter) {
            this.identities.add(name);
            this.identitySetters.put(name, (IdentitySetter)val);
            this.identityTypes.put(name, type);
        } else {
            this.parameters.add(name);
            this.parameterValues.put(name, val);
            this.parameterTypes.put(name, type);
        }
        return this;
    }

    public SqlQuery setParameterList(String name, Object[] vals) throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    public SqlQuery setParameterList(String name, Object[] vals, Object type) throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    protected void setParameters(PreparedStatement ps, SqlUtils.LimitType limitType) throws SQLException {
        int ix = 1;
        ix = this.setLimits(ps, limitType, ix, false);
        int n = this.parameters.size();
        for (int i = 0; i < n; ++i) {
            String name = this.parameters.get(i);
            Object value = this.parameterValues.get(name);
            Object type = this.parameterTypes.get(name);
            if (type != null) {
                if (type instanceof JdbcSqlType) {
                    ((JdbcSqlType)type).set(ps, ix++, value);
                    continue;
                }
                ps.setObject(ix++, value, (Integer)type);
                continue;
            }
            ps.setObject(ix++, value);
        }
        ix = this.setLimits(ps, limitType, ix, true);
    }

    protected int setLimits(PreparedStatement ps, SqlUtils.LimitType limitType, int ix, boolean afterSql) throws SQLException {
        if (limitType == null) {
            return ix;
        }
        if (afterSql && !limitType.afterSql) {
            return ix;
        }
        if (!afterSql && limitType.afterSql) {
            return ix;
        }
        if (limitType.maxBeforeFirst) {
            if (limitType.rowidBasedMax && limitType.alsoFirst) {
                ps.setInt(ix++, this.firstResult + this.maxResults);
            } else {
                ps.setInt(ix++, this.maxResults);
            }
        }
        if (limitType.alsoFirst) {
            if (limitType.zeroBasedFirst) {
                ps.setInt(ix++, this.firstResult);
            } else {
                ps.setInt(ix++, this.firstResult);
            }
        }
        if (!limitType.maxBeforeFirst) {
            if (limitType.rowidBasedMax && limitType.alsoFirst) {
                ps.setInt(ix++, this.firstResult + this.maxResults);
            } else {
                ps.setInt(ix++, this.maxResults);
            }
        }
        return ix;
    }

    protected List getResults(ResultSet rs) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            int n = this.scalars.size();
            for (int i = 0; i < n; ++i) {
                String name = this.scalars.get(i);
                Object type = this.scalarTypes.get(name);
                Object value = null;
                value = type != null && type instanceof JdbcSqlType ? ((JdbcSqlType)type).get(rs, name) : rs.getObject(name);
                if (rs.wasNull()) {
                    value = null;
                }
                row.add(value);
            }
            Object[] oo = row.toArray();
            if (oo.length == 1) {
                result.add(oo[0]);
                continue;
            }
            result.add(oo);
        }
        return result;
    }
}

