/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.impl.SqlMetaAndOrItem;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;

class SqlMetaAndOr
implements SqlMetaElement {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    List<SqlMetaAndOrItem> elements;
    Type type = Type.NO;

    SqlMetaAndOr(Type type) {
        this.elements = new ArrayList<SqlMetaAndOrItem>();
        this.type = type;
    }

    void addElement(SqlMetaAndOrItem element) {
        this.elements.add(element);
    }

    String getPrefix() {
        String operator = "";
        if (this.type == Type.AND) {
            operator = "AND ";
        } else if (this.type == Type.OR) {
            operator = "OR ";
        }
        return operator;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult();
        result.addFalse();
        StringBuilder s = new StringBuilder(this.getPrefix());
        result.setSql(s);
        for (SqlMetaAndOrItem item : this.elements) {
            SqlProcessResult itemResult;
            if (result.isAdd() || !(itemResult = item.process(ctx)).isAdd()) continue;
            s.append((CharSequence)itemResult.getSql());
            result.addInputValues(itemResult.getInputValues());
            result.addTrue();
        }
        return result;
    }

    static enum Type {
        NO,
        AND,
        OR;

    }
}

