/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.SQLQuery;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlMappingAttribute;
import org.sqlproc.engine.impl.SqlMappingIdentity;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.impl.type.SqlMetaType;

class SqlMappingItem
implements SqlMetaElement {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<SqlMappingAttribute> attributes;
    private String dbName;
    private StringBuilder fullName;
    private SqlType sqlType;
    private boolean identity;
    Map<String, String> values = new HashMap<String, String>();

    SqlMappingItem(String dbName) {
        this.attributes = new ArrayList<SqlMappingAttribute>();
        this.sqlType = new SqlType();
        this.dbName = dbName;
        this.fullName = new StringBuilder();
    }

    String getDbName() {
        return this.dbName;
    }

    SqlMappingAttribute addAttributeName(String name) {
        String[] names = name.split("=");
        if (this.fullName.length() > 0) {
            this.fullName.append(".");
        }
        this.fullName.append(names[0]);
        SqlMappingAttribute attr = new SqlMappingAttribute(this, this.fullName.toString(), names[0]);
        if (names.length > 1) {
            attr.setValues("type", names[1]);
        }
        if (names.length > 2) {
            attr.setValues("gtype", names[2]);
        }
        this.attributes.add(attr);
        return attr;
    }

    List<SqlMappingAttribute> getAttributes() {
        return this.attributes;
    }

    void setAttributes(List<SqlMappingAttribute> attributes) {
        this.attributes = attributes;
    }

    boolean isIdentity() {
        if (this.identity) {
            return true;
        }
        String id = SqlProcessContext.getFeature("ID");
        return id != null && id.equalsIgnoreCase(this.getName());
    }

    String getFullName() {
        if (this.fullName.length() > 0) {
            return this.fullName.toString();
        }
        return this.dbName;
    }

    String getName() {
        return this.attributes.isEmpty() ? this.dbName : this.attributes.get(this.attributes.size() - 1).getName();
    }

    void setMetaType(String sMetaType) {
        this.sqlType = new SqlType(sMetaType);
    }

    void setMetaType(SqlMetaType metaType) {
        this.sqlType = new SqlType(metaType);
    }

    SqlType getSqlType() {
        return this.sqlType;
    }

    void setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
    }

    void setValues(String value, String value2) {
        this.setValues(null, value, value2);
    }

    void setValues(String name, String value, String value2) {
        int ix = -1;
        if (value2 == null && (ix = value.indexOf(61)) >= 0) {
            value2 = value.substring(ix + 1);
            value = value.substring(0, ix);
        }
        if (value2 == null) {
            if ("id".equalsIgnoreCase(value)) {
                this.identity = true;
            } else {
                this.sqlType.setValue(value);
            }
        } else if (name == null) {
            this.values.put(value, value2);
        } else {
            this.values.put(name + value, value2);
        }
    }

    void setQueryResultMapping(Class<?> resultClass, Map<String, Class<?>> moreResultClasses, SQLQuery query) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>>  setQueryResultMapping, fullName=" + this.getFullName() + ", resultClass=" + resultClass + ", moreResultClasses=" + moreResultClasses);
        }
        Type hibernateType = null;
        if (this.sqlType.getMetaType() != SqlMetaType.DEFAULT) {
            hibernateType = this.sqlType.getHibernateType();
        } else {
            int count = this.attributes.size();
            boolean exit = false;
            Class<?> objClass = resultClass;
            for (int i = 0; i < count - 1 && !exit; ++i) {
                Class typeClass;
                SqlMappingAttribute attr = this.attributes.get(i);
                String name = attr.getName();
                Method m = BeanUtils.getGetter(objClass, name);
                if (m != null) {
                    objClass = m.getReturnType();
                } else if (SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) {
                    this.logger.error("There's no getter for '" + name + "' in " + objClass + ", complete attribute name is '" + attr.getFullName() + "'");
                    exit = true;
                } else {
                    throw new SqlRuntimeException("There's no getter for '" + name + "' in " + objClass + ", complete attribute name is '" + attr.getFullName() + "'");
                }
                if (exit) continue;
                boolean isCollection = false;
                for (Class<?> clazz : objClass.getInterfaces()) {
                    if (clazz != Collection.class) continue;
                    isCollection = true;
                    break;
                }
                if (!isCollection) continue;
                String typeName = moreResultClasses != null ? this.values.get(attr.getFullName() + "gtype") : null;
                Class clazz = typeClass = typeName != null ? moreResultClasses.get(typeName) : null;
                if (typeClass == null) {
                    ParameterizedType paramType = (ParameterizedType)m.getGenericReturnType();
                    typeClass = (Class)paramType.getActualTypeArguments()[0];
                }
                if (typeClass != null) {
                    objClass = typeClass;
                    continue;
                }
                if (SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) {
                    this.logger.error("There's no generic type defined for collection " + objClass + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                    exit = true;
                    continue;
                }
                throw new SqlRuntimeException("There's no generic type defined for collection " + objClass + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
            }
            if (!exit) {
                hibernateType = this.sqlType.getHibernateType(objClass, this.getName());
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("<<<  setQueryResultMapping, fullName=" + this.getFullName() + ", dbName=" + this.dbName + ", hibernateType=" + hibernateType);
        }
        if (hibernateType != null) {
            query.addScalar(this.dbName, hibernateType);
        } else {
            query.addScalar(this.dbName);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setQueryResultData(Object resultInstance, Object resultValue, Map<String, Object> instances, Set<String> allocatedCllections, boolean[] changedIdentities, Map<String, SqlMappingIdentity> identities, Map<String, Class<?>> moreResultClasses) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>>  setQueryResultData, fullName=" + this.getFullName() + ", resultInstance=" + resultInstance + ", resultValue=" + resultValue);
        }
        if (resultValue == null) {
            return;
        }
        boolean changed = SqlUtils.changedIdentity(changedIdentities, identities.get((Object)this.getFullName()).identityIndexes);
        if (!changed) {
            return;
        }
        boolean exit = false;
        Object obj = resultInstance;
        int count = this.attributes.size();
        for (int i = 0; i < count - 1 && !exit; ++i) {
            Method m;
            SqlMappingAttribute attr = this.attributes.get(i);
            String name = attr.getName();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("===  setQueryResultData, fullName=" + this.getFullName() + ", name=" + name + ", identities=" + identities.get(attr.getFullName()));
            }
            if ((m = BeanUtils.getGetter(obj, name)) != null) {
                Object nextObj = BeanUtils.invokeMethod(obj, m.getName(), null);
                if (nextObj == null) {
                    Class<?> clazz;
                    String typeName = this.values.get(attr.getFullName() + "type");
                    Class<?> clazz2 = clazz = typeName != null ? moreResultClasses.get(typeName) : null;
                    if (clazz == null) {
                        Class<?> clazz3 = m.getReturnType();
                        if (clazz3.isInterface()) {
                            if (clazz3 == List.class) {
                                Class<ArrayList> clazz4 = ArrayList.class;
                            } else if (clazz3 == Set.class) {
                                Class<HashSet> clazz5 = HashSet.class;
                            } else {
                                if (!SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) throw new SqlRuntimeException("There's no type defined for collection " + clazz3 + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                                this.logger.error("There's no type defined for collection " + clazz3 + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                                exit = true;
                            }
                        } else {
                            Class<?> clazz6 = clazz3;
                        }
                    }
                    if (!exit) {
                        void var18_23;
                        nextObj = BeanUtils.getInstance(var18_23);
                        if (nextObj != null) {
                            BeanUtils.setProperty(obj, name, nextObj);
                        } else {
                            if (!SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) throw new SqlRuntimeException("There's problem to instantiate " + var18_23 + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                            this.logger.error("There's problem to instantiate " + var18_23 + ", complete attribute name is '" + attr.getFullName() + "', possible type name is " + typeName);
                            exit = true;
                        }
                    }
                }
                if (!exit && nextObj instanceof Collection) {
                    SqlMappingIdentity ident = identities.get(attr.getFullName());
                    if (SqlUtils.changedIdentity(changedIdentities, ident.identityIndexes) && !allocatedCllections.contains(attr.getFullName())) {
                        Class typeClass;
                        allocatedCllections.add(attr.getFullName());
                        String string = moreResultClasses != null ? this.values.get(attr.getFullName() + "gtype") : null;
                        Class clazz = typeClass = string != null ? moreResultClasses.get(string) : null;
                        if (typeClass == null) {
                            ParameterizedType paramType = (ParameterizedType)m.getGenericReturnType();
                            typeClass = (Class)paramType.getActualTypeArguments()[0];
                        }
                        if (typeClass != null) {
                            Object itemObj = BeanUtils.getInstance(typeClass);
                            if (itemObj != null) {
                                ((Collection)nextObj).add(itemObj);
                                nextObj = itemObj;
                                instances.put(attr.getFullName(), nextObj);
                            } else {
                                if (!SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) throw new SqlRuntimeException("There's problem to instantiate " + typeClass + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                                this.logger.error("There's problem to instantiate " + typeClass + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                                exit = true;
                            }
                        } else {
                            if (!SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) throw new SqlRuntimeException("There's no generic type defined for collection " + nextObj + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                            this.logger.error("There's no generic type defined for collection " + nextObj + ", complete attribute name is " + attr.getFullName() + ", possible type name is " + string);
                            exit = true;
                        }
                    } else {
                        nextObj = instances.get(attr.getFullName());
                    }
                }
                obj = nextObj;
                continue;
            }
            if (!SqlProcessContext.isFeature("IGNORE_INPROPER_OUT")) throw new SqlRuntimeException("There's no getter for " + name + " in " + obj + ", complete attribute name is " + attr.getFullName());
            this.logger.error("There's no getter for " + name + " in " + obj + ", complete attribute name is " + attr.getFullName());
            exit = true;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("<<<  setQueryResultData, fullName=" + this.getFullName() + ", name=" + this.getName() + ", obj=" + obj + ", resultValue=" + resultValue);
        }
        this.sqlType.setResult(obj, this.getName(), resultValue);
    }

    SqlMappingItem merge(SqlMappingItem outputMapping) {
        SqlMappingItem resultMappingItem = new SqlMappingItem(this.dbName);
        if (this.attributes != null && this.attributes.size() > 0) {
            resultMappingItem.setAttributes(this.attributes);
            resultMappingItem.fullName = this.fullName;
            resultMappingItem.identity = this.identity;
            resultMappingItem.values = this.values;
        } else {
            resultMappingItem.setAttributes(outputMapping.getAttributes());
            resultMappingItem.fullName = outputMapping.fullName;
            resultMappingItem.identity = outputMapping.identity;
            resultMappingItem.values = outputMapping.values;
        }
        if (this.sqlType != null) {
            resultMappingItem.setSqlType(this.sqlType);
        } else {
            resultMappingItem.setSqlType(outputMapping.getSqlType());
        }
        return resultMappingItem;
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult(this.dbName);
        result.addOutputValue(this.dbName, this);
        return result;
    }

    public String toString() {
        return "SqlMappingItem [attributes=" + this.attributes + ", dbName=" + this.dbName + ", fullName=" + this.fullName + ", sqlType=" + this.sqlType + ", identity=" + this.identity + "]";
    }
}

