/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlEngineLoader;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.SqlPropertiesLoader;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlSimpleFactory
implements SqlEngineFactory {
    protected static final String DEFAULT_META_PROPS_NAME = "queries.properties";
    private String metaPropsName;
    private Properties metaProps;
    private SqlTypeFactory typeFactory;
    private String filter;
    private SqlMonitorFactory monitorFactory;
    private List<SqlInternalType> customTypes;
    private String[] selectQueries;
    private boolean jdbc;
    private SqlEngineLoader loader;

    public synchronized void init() {
        if (this.loader == null) {
            Properties metaProperties = this.metaProps;
            if (metaProperties == null) {
                SqlPropertiesLoader loader = new SqlPropertiesLoader(this.metaPropsName != null ? this.metaPropsName : DEFAULT_META_PROPS_NAME, this.getClass());
                metaProperties = loader.getProperties();
            }
            if (this.jdbc) {
                metaProperties.setProperty("SET_JDBC", "true");
            }
            this.loader = new SqlEngineLoader(metaProperties, this.typeFactory, this.filter, this.monitorFactory, this.customTypes, this.selectQueries);
            this.metaProps = metaProperties;
        }
    }

    @Override
    public SqlQueryEngine getQueryEngine(String name) {
        if (this.loader == null) {
            this.init();
        }
        return this.loader.getQueryEngine(name);
    }

    @Override
    public SqlCrudEngine getCrudEngine(String name) {
        if (this.loader == null) {
            this.init();
        }
        return this.loader.getCrudEngine(name);
    }

    public String getMetaPropsName() {
        return this.metaPropsName;
    }

    public void setMetaPropsName(String propsName) {
        this.metaPropsName = propsName;
    }

    public Properties getMetaProps() {
        return this.metaProps;
    }

    public void setMetaProps(Properties props) {
        this.metaProps = props;
    }

    public SqlTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void setTypeFactory(SqlTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public SqlMonitorFactory getMonitorFactory() {
        return this.monitorFactory;
    }

    public void setMonitorFactory(SqlMonitorFactory monitorFactory) {
        this.monitorFactory = monitorFactory;
    }

    public List<SqlInternalType> getCustomTypes() {
        return this.customTypes;
    }

    public void setCustomTypes(List<SqlInternalType> customTypes) {
        this.customTypes = customTypes;
    }

    public void addCustomType(SqlInternalType customType) {
        if (this.customTypes == null) {
            this.customTypes = new ArrayList<SqlInternalType>();
        }
        this.customTypes.add(customType);
    }

    public String[] getSelectQueries() {
        return this.selectQueries;
    }

    public void setSelectQueries(String[] selectQueries) {
        this.selectQueries = selectQueries;
    }

    public boolean isJdbc() {
        return this.jdbc;
    }

    public void setJdbc(boolean jdbc) {
        this.jdbc = jdbc;
    }

    public SqlEngineLoader getLoader() {
        return this.loader;
    }
}

