// $ANTLR 3.3 Nov 30, 2010 12:46:29 org/sqlproc/engine/impl/SqlStatement.g 2011-04-03 07:05:06
 
package org.sqlproc.engine.impl;

import java.util.Map;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.type.SqlMetaType;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

public class SqlStatementParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "IDENT_DOT", "IDENT", "WS", "NUMBER", "REST", "MINUS", "PLUS", "LPAREN", "RPAREN", "RBRACE", "QUESTI", "NOT", "BAND", "BOR", "HASH", "CARET", "EQUALS", "ESC_COLON", "ESC_STRING", "ESC_AT", "ESC_LBRACE", "ESC_RBRACE", "ESC_HASH", "ESC_BOR", "COLON", "STRING", "AT", "LBRACE", "AND", "OR", "DOT", "DIGIT"
    };
    public static final int EOF=-1;
    public static final int IDENT_DOT=4;
    public static final int IDENT=5;
    public static final int WS=6;
    public static final int NUMBER=7;
    public static final int REST=8;
    public static final int MINUS=9;
    public static final int PLUS=10;
    public static final int LPAREN=11;
    public static final int RPAREN=12;
    public static final int RBRACE=13;
    public static final int QUESTI=14;
    public static final int NOT=15;
    public static final int BAND=16;
    public static final int BOR=17;
    public static final int HASH=18;
    public static final int CARET=19;
    public static final int EQUALS=20;
    public static final int ESC_COLON=21;
    public static final int ESC_STRING=22;
    public static final int ESC_AT=23;
    public static final int ESC_LBRACE=24;
    public static final int ESC_RBRACE=25;
    public static final int ESC_HASH=26;
    public static final int ESC_BOR=27;
    public static final int COLON=28;
    public static final int STRING=29;
    public static final int AT=30;
    public static final int LBRACE=31;
    public static final int AND=32;
    public static final int OR=33;
    public static final int DOT=34;
    public static final int DIGIT=35;

    // delegates
    // delegators


        public SqlStatementParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public SqlStatementParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return SqlStatementParser.tokenNames; }
    public String getGrammarFileName() { return "org/sqlproc/engine/impl/SqlStatement.g"; }


      private Token getLastToken() {
        return input.LT(-1);
      }

      private List<ErrorMsg> errors = new ArrayList<ErrorMsg>();
      public List<ErrorMsg> getErrors() {
        return errors;
      }

      @Override
      public void reportError(RecognitionException e) {
        String msg = super.getErrorMessage(e,tokenNames);
        errors.add(ParserUtils.create(msg,e,tokenNames));
      }
      
      String getText(Token token) {
        if (token == null)
          return null;
        return token.getText();
      }
      
      void add(StringBuilder text) {
        int type = getLastToken().getType();
        if (type == ESC_COLON || type == ESC_STRING || type == ESC_AT || type == ESC_LBRACE || type == ESC_RBRACE || type == ESC_HASH || type == ESC_BOR)
          text.append(getLastToken().getText().substring(1));
        else
          text.append(getLastToken().getText());
      }
      
      void addText(Object target, StringBuilder text) {
        ParserUtils.addText(target, text);
      }
      
      void addColumn(Object target, SqlMappingItem col, StringBuilder text) {
        ParserUtils.addColumn(target, col, text);
      }
      
      SqlMappingItem newColumn(Token col) {
        return ParserUtils.newColumn(col.getText());
      }
      
      void addIdent(Object target, SqlMetaIdent ident, StringBuilder text) {
        ParserUtils.addIdent(target, ident, text);
      }
      
      SqlMetaIdent newIdent(Token ident, Token caseConversion) {
        return ParserUtils.newIdent(ident.getText(), getText(caseConversion));
      }
      
      void addConstant(Object target, SqlMetaConst cnst, StringBuilder text) {
        ParserUtils.addConstant(target, cnst, text);
      }
      
      SqlMetaConst newConstant(Token cnst, Token caseConversion) {
        return ParserUtils.newConstant(cnst.getText(), getText(caseConversion));
      }
      
      void addOperator(SqlMetaLogExpr expr, boolean isAnd) {
        if (isAnd)
          expr.addElement(new SqlMetaLogOperator(SqlMetaLogOperator.Type.AND));
        else
          expr.addElement(new SqlMetaLogOperator(SqlMetaLogOperator.Type.OR));
      }

      void setMetaType(SqlTypeFactory typeFactory, SqlMappingItem item, String sMetaType) {
        item.setMetaType(typeFactory.getMetaType(sMetaType));
      }

      void setMetaType(SqlTypeFactory typeFactory, SqlMetaIdent item, String sMetaType) {
        item.setMetaType(typeFactory.getMetaType(sMetaType));
      }

      void setMetaType(SqlTypeFactory typeFactory, SqlMetaConst item, String sMetaType) {
        item.setMetaType(typeFactory.getMetaType(sMetaType));
      }


    protected static class parse_scope {
        StringBuilder text;
        boolean hasOutputMapping;
        SqlTypeFactory typeFactory;
    }
    protected Stack parse_stack = new Stack();


    // $ANTLR start "parse"
    // org/sqlproc/engine/impl/SqlStatement.g:110:1: parse[SqlTypeFactory _typeFactory] returns [SqlMetaStatement metaStatement] : sql[metaStatement] EOF ;
    public final SqlMetaStatement parse(SqlTypeFactory _typeFactory) throws RecognitionException {
        parse_stack.push(new parse_scope());
        SqlMetaStatement metaStatement = null;

        metaStatement = new SqlMetaStatement(); ((parse_scope)parse_stack.peek()).text = new StringBuilder();((parse_scope)parse_stack.peek()).typeFactory =_typeFactory;
        try {
            // org/sqlproc/engine/impl/SqlStatement.g:114:2: ( sql[metaStatement] EOF )
            // org/sqlproc/engine/impl/SqlStatement.g:114:4: sql[metaStatement] EOF
            {
            pushFollow(FOLLOW_sql_in_parse65);
            sql(metaStatement);

            state._fsp--;

            match(input,EOF,FOLLOW_EOF_in_parse68); 

            }

            metaStatement.setHasOutputMapping(((parse_scope)parse_stack.peek()).hasOutputMapping);
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
            parse_stack.pop();
        }
        return metaStatement;
    }
    // $ANTLR end "parse"


    // $ANTLR start "sql"
    // org/sqlproc/engine/impl/SqlStatement.g:117:1: sql[SqlMetaStatement metaStatement] : ( ( IDENT_DOT | IDENT | WS | NUMBER | REST | MINUS | PLUS | LPAREN | RPAREN | RBRACE | QUESTI | NOT | BAND | BOR | HASH | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) ( sql[metaStatement] )? | COLON ident= identifier ( sql[metaStatement] )? | STRING cnst= constant ( sql[metaStatement] )? | AT col= column ( sql[metaStatement] )? | LBRACE metaSql[metaStatement] RBRACE ( sql[metaStatement] )? );
    public final void sql(SqlMetaStatement metaStatement) throws RecognitionException {
        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;

        SqlMappingItem col = null;


        try {
            // org/sqlproc/engine/impl/SqlStatement.g:119:2: ( ( IDENT_DOT | IDENT | WS | NUMBER | REST | MINUS | PLUS | LPAREN | RPAREN | RBRACE | QUESTI | NOT | BAND | BOR | HASH | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) ( sql[metaStatement] )? | COLON ident= identifier ( sql[metaStatement] )? | STRING cnst= constant ( sql[metaStatement] )? | AT col= column ( sql[metaStatement] )? | LBRACE metaSql[metaStatement] RBRACE ( sql[metaStatement] )? )
            int alt6=5;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
            case IDENT:
            case WS:
            case NUMBER:
            case REST:
            case MINUS:
            case PLUS:
            case LPAREN:
            case RPAREN:
            case RBRACE:
            case QUESTI:
            case NOT:
            case BAND:
            case BOR:
            case HASH:
            case CARET:
            case EQUALS:
            case ESC_COLON:
            case ESC_STRING:
            case ESC_AT:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_HASH:
            case ESC_BOR:
                {
                alt6=1;
                }
                break;
            case COLON:
                {
                alt6=2;
                }
                break;
            case STRING:
                {
                alt6=3;
                }
                break;
            case AT:
                {
                alt6=4;
                }
                break;
            case LBRACE:
                {
                alt6=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;
            }

            switch (alt6) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:121:2: ( IDENT_DOT | IDENT | WS | NUMBER | REST | MINUS | PLUS | LPAREN | RPAREN | RBRACE | QUESTI | NOT | BAND | BOR | HASH | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) ( sql[metaStatement] )?
                    {
                    if ( (input.LA(1)>=IDENT_DOT && input.LA(1)<=ESC_BOR) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    add(((parse_scope)parse_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlStatement.g:122:24: ( sql[metaStatement] )?
                    int alt1=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case RBRACE:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case BOR:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt1=1;
                            }
                            break;
                    }

                    switch (alt1) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:122:24: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql193);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:123:4: COLON ident= identifier ( sql[metaStatement] )?
                    {
                    match(input,COLON,FOLLOW_COLON_in_sql200); 
                    pushFollow(FOLLOW_identifier_in_sql204);
                    ident=identifier();

                    state._fsp--;

                    addIdent(metaStatement, ident, ((parse_scope)parse_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlStatement.g:124:51: ( sql[metaStatement] )?
                    int alt2=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case RBRACE:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case BOR:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt2=1;
                            }
                            break;
                    }

                    switch (alt2) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:124:51: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql211);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlStatement.g:125:9: STRING cnst= constant ( sql[metaStatement] )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_sql223); 
                    pushFollow(FOLLOW_constant_in_sql227);
                    cnst=constant();

                    state._fsp--;

                    addConstant(metaStatement, cnst, ((parse_scope)parse_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlStatement.g:126:58: ( sql[metaStatement] )?
                    int alt3=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case RBRACE:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case BOR:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt3=1;
                            }
                            break;
                    }

                    switch (alt3) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:126:58: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql239);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlStatement.g:127:9: AT col= column ( sql[metaStatement] )?
                    {
                    match(input,AT,FOLLOW_AT_in_sql251); 
                    pushFollow(FOLLOW_column_in_sql255);
                    col=column();

                    state._fsp--;

                    addColumn(metaStatement, col, ((parse_scope)parse_stack.peek()).text);((parse_scope)parse_stack.peek()).hasOutputMapping =true;
                    // org/sqlproc/engine/impl/SqlStatement.g:128:85: ( sql[metaStatement] )?
                    int alt4=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case RBRACE:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case BOR:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt4=1;
                            }
                            break;
                    }

                    switch (alt4) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:128:85: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql267);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 5 :
                    // org/sqlproc/engine/impl/SqlStatement.g:129:9: LBRACE metaSql[metaStatement] RBRACE ( sql[metaStatement] )?
                    {
                    match(input,LBRACE,FOLLOW_LBRACE_in_sql279); 
                    pushFollow(FOLLOW_metaSql_in_sql281);
                    metaSql(metaStatement);

                    state._fsp--;

                    match(input,RBRACE,FOLLOW_RBRACE_in_sql284); 
                    // org/sqlproc/engine/impl/SqlStatement.g:129:46: ( sql[metaStatement] )?
                    int alt5=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case RBRACE:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case BOR:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt5=1;
                            }
                            break;
                    }

                    switch (alt5) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:129:46: sql[metaStatement]
                            {
                            pushFollow(FOLLOW_sql_in_sql286);
                            sql(metaStatement);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;

            }
            addText(metaStatement, ((parse_scope)parse_stack.peek()).text);
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "sql"


    // $ANTLR start "metaSql"
    // org/sqlproc/engine/impl/SqlStatement.g:132:1: metaSql[SqlMetaStatement metaStatement] : ( ( IDENT_DOT | IDENT | WS | NUMBER | REST | COLON | STRING | MINUS | PLUS | LPAREN | RPAREN | NOT | AT | CARET | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null] | HASH orderId= NUMBER ordSql[metaOrd] );
    public final void metaSql(SqlMetaStatement metaStatement) throws RecognitionException {
        Token fragmentType=null;
        Token orderId=null;
        SqlMetaIfItem metaIfItem = null;

        SqlMetaLogExpr metaLogExpr = null;


        SqlMetaAndOr metaAndOr; SqlMetaIf metaIf; SqlMetaOrd metaOrd; SqlMetaSqlFragment sqlFragment; addText(metaStatement, ((parse_scope)parse_stack.peek()).text);
        try {
            // org/sqlproc/engine/impl/SqlStatement.g:134:2: ( ( IDENT_DOT | IDENT | WS | NUMBER | REST | COLON | STRING | MINUS | PLUS | LPAREN | RPAREN | NOT | AT | CARET | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )* | EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null] | HASH orderId= NUMBER ordSql[metaOrd] )
            int alt12=6;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
            case IDENT:
            case WS:
            case NUMBER:
            case REST:
            case MINUS:
            case PLUS:
            case LPAREN:
            case RPAREN:
            case NOT:
            case CARET:
            case ESC_COLON:
            case ESC_STRING:
            case ESC_AT:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_HASH:
            case ESC_BOR:
            case COLON:
            case STRING:
            case AT:
                {
                alt12=1;
                }
                break;
            case QUESTI:
                {
                alt12=2;
                }
                break;
            case BAND:
                {
                alt12=3;
                }
                break;
            case BOR:
                {
                alt12=4;
                }
                break;
            case EQUALS:
                {
                alt12=5;
                }
                break;
            case HASH:
                {
                alt12=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 12, 0, input);

                throw nvae;
            }

            switch (alt12) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:136:2: ( IDENT_DOT | IDENT | WS | NUMBER | REST | COLON | STRING | MINUS | PLUS | LPAREN | RPAREN | NOT | AT | CARET | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    if ( (input.LA(1)>=IDENT_DOT && input.LA(1)<=RPAREN)||input.LA(1)==NOT||input.LA(1)==CARET||(input.LA(1)>=ESC_COLON && input.LA(1)<=AT) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    add(((parse_scope)parse_stack.peek()).text); metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.NO);
                    pushFollow(FOLLOW_ifSql_in_metaSql405);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    metaAndOr.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlStatement.g:138:3: ( BOR metaIfItem= ifSql[null] )*
                    loop7:
                    do {
                        int alt7=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt7=1;
                            }
                            break;

                        }

                        switch (alt7) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:138:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql414); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql418);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    metaAndOr.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop7;
                        }
                    } while (true);

                    metaStatement.addElement(metaAndOr);

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:139:4: QUESTI metaLogExpr= ifSqlCond BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    match(input,QUESTI,FOLLOW_QUESTI_in_metaSql430); 
                    metaIf = new SqlMetaIf(); 
                    pushFollow(FOLLOW_ifSqlCond_in_metaSql436);
                    metaLogExpr=ifSqlCond();

                    state._fsp--;

                    metaIf.setExpression(metaLogExpr);
                    match(input,BOR,FOLLOW_BOR_in_metaSql443); 
                    pushFollow(FOLLOW_ifSql_in_metaSql447);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    metaIf.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlStatement.g:141:3: ( BOR metaIfItem= ifSql[null] )*
                    loop8:
                    do {
                        int alt8=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt8=1;
                            }
                            break;

                        }

                        switch (alt8) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:141:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql456); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql460);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    metaIf.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop8;
                        }
                    } while (true);

                    metaStatement.addElement(metaIf);

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlStatement.g:143:4: BAND metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    match(input,BAND,FOLLOW_BAND_in_metaSql475); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.AND);
                    pushFollow(FOLLOW_ifSql_in_metaSql481);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    metaAndOr.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlStatement.g:144:3: ( BOR metaIfItem= ifSql[null] )*
                    loop9:
                    do {
                        int alt9=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt9=1;
                            }
                            break;

                        }

                        switch (alt9) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:144:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql490); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql494);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    metaAndOr.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop9;
                        }
                    } while (true);

                    metaStatement.addElement(metaAndOr);

                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlStatement.g:145:4: BOR metaIfItem= ifSql[null] ( BOR metaIfItem= ifSql[null] )*
                    {
                    match(input,BOR,FOLLOW_BOR_in_metaSql506); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.OR);
                    pushFollow(FOLLOW_ifSql_in_metaSql512);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    metaAndOr.addElement(metaIfItem);
                    // org/sqlproc/engine/impl/SqlStatement.g:146:3: ( BOR metaIfItem= ifSql[null] )*
                    loop10:
                    do {
                        int alt10=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt10=1;
                            }
                            break;

                        }

                        switch (alt10) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:146:4: BOR metaIfItem= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_metaSql521); 
                    	    pushFollow(FOLLOW_ifSql_in_metaSql525);
                    	    metaIfItem=ifSql(null);

                    	    state._fsp--;

                    	    metaAndOr.addElement(metaIfItem);

                    	    }
                    	    break;

                    	default :
                    	    break loop10;
                        }
                    } while (true);

                    metaStatement.addElement(metaAndOr);

                    }
                    break;
                case 5 :
                    // org/sqlproc/engine/impl/SqlStatement.g:147:4: EQUALS ( WS )* fragmentType= IDENT metaIfItem= ifSql[null]
                    {
                    match(input,EQUALS,FOLLOW_EQUALS_in_metaSql537); 
                    // org/sqlproc/engine/impl/SqlStatement.g:147:11: ( WS )*
                    loop11:
                    do {
                        int alt11=2;
                        switch ( input.LA(1) ) {
                        case WS:
                            {
                            alt11=1;
                            }
                            break;

                        }

                        switch (alt11) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:147:11: WS
                    	    {
                    	    match(input,WS,FOLLOW_WS_in_metaSql539); 

                    	    }
                    	    break;

                    	default :
                    	    break loop11;
                        }
                    } while (true);

                    fragmentType=(Token)match(input,IDENT,FOLLOW_IDENT_in_metaSql544); 
                    sqlFragment = new SqlMetaSqlFragment(fragmentType.getText());
                    pushFollow(FOLLOW_ifSql_in_metaSql550);
                    metaIfItem=ifSql(null);

                    state._fsp--;

                    sqlFragment.addElement(metaIfItem);
                    metaStatement.addElement(sqlFragment);

                    }
                    break;
                case 6 :
                    // org/sqlproc/engine/impl/SqlStatement.g:149:4: HASH orderId= NUMBER ordSql[metaOrd]
                    {
                    match(input,HASH,FOLLOW_HASH_in_metaSql563); 
                    orderId=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_metaSql567); 
                    metaOrd = new SqlMetaOrd(Integer.parseInt(orderId.getText()));
                    pushFollow(FOLLOW_ordSql_in_metaSql571);
                    ordSql(metaOrd);

                    state._fsp--;

                    metaStatement.addElement(metaOrd);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "metaSql"


    // $ANTLR start "ifSql"
    // org/sqlproc/engine/impl/SqlStatement.g:152:1: ifSql[SqlMetaIfItem metaIfItemIn] returns [SqlMetaIfItem metaIfItem] : ( ( IDENT_DOT | IDENT | WS | NUMBER | REST | MINUS | PLUS | LPAREN | RPAREN | QUESTI | NOT | BAND | HASH | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) ( ifSql[metaIfItem] )? | COLON ident= identifier ( ifSql[metaIfItem] )? | STRING cnst= constant ( ifSql[metaIfItem] )? | AT col= column ( ifSql[metaIfItem] )? | LBRACE ifMetaSql[metaIfItem] RBRACE ( ifSql[metaIfItem] )? );
    public final SqlMetaIfItem ifSql(SqlMetaIfItem metaIfItemIn) throws RecognitionException {
        SqlMetaIfItem metaIfItem = null;

        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;

        SqlMappingItem col = null;


        metaIfItem = (metaIfItemIn !=null) ? metaIfItemIn : new SqlMetaIfItem();
        try {
            // org/sqlproc/engine/impl/SqlStatement.g:155:2: ( ( IDENT_DOT | IDENT | WS | NUMBER | REST | MINUS | PLUS | LPAREN | RPAREN | QUESTI | NOT | BAND | HASH | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) ( ifSql[metaIfItem] )? | COLON ident= identifier ( ifSql[metaIfItem] )? | STRING cnst= constant ( ifSql[metaIfItem] )? | AT col= column ( ifSql[metaIfItem] )? | LBRACE ifMetaSql[metaIfItem] RBRACE ( ifSql[metaIfItem] )? )
            int alt18=5;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
            case IDENT:
            case WS:
            case NUMBER:
            case REST:
            case MINUS:
            case PLUS:
            case LPAREN:
            case RPAREN:
            case QUESTI:
            case NOT:
            case BAND:
            case HASH:
            case CARET:
            case EQUALS:
            case ESC_COLON:
            case ESC_STRING:
            case ESC_AT:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_HASH:
            case ESC_BOR:
                {
                alt18=1;
                }
                break;
            case COLON:
                {
                alt18=2;
                }
                break;
            case STRING:
                {
                alt18=3;
                }
                break;
            case AT:
                {
                alt18=4;
                }
                break;
            case LBRACE:
                {
                alt18=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;
            }

            switch (alt18) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:157:2: ( IDENT_DOT | IDENT | WS | NUMBER | REST | MINUS | PLUS | LPAREN | RPAREN | QUESTI | NOT | BAND | HASH | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) ( ifSql[metaIfItem] )?
                    {
                    if ( (input.LA(1)>=IDENT_DOT && input.LA(1)<=RPAREN)||(input.LA(1)>=QUESTI && input.LA(1)<=BAND)||(input.LA(1)>=HASH && input.LA(1)<=ESC_BOR) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    add(((parse_scope)parse_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlStatement.g:158:24: ( ifSql[metaIfItem] )?
                    int alt13=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt13=1;
                            }
                            break;
                    }

                    switch (alt13) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:158:24: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql696);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:159:4: COLON ident= identifier ( ifSql[metaIfItem] )?
                    {
                    match(input,COLON,FOLLOW_COLON_in_ifSql703); 
                    pushFollow(FOLLOW_identifier_in_ifSql707);
                    ident=identifier();

                    state._fsp--;

                    addIdent(metaIfItem, ident, ((parse_scope)parse_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlStatement.g:160:48: ( ifSql[metaIfItem] )?
                    int alt14=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt14=1;
                            }
                            break;
                    }

                    switch (alt14) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:160:48: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql714);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlStatement.g:161:4: STRING cnst= constant ( ifSql[metaIfItem] )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_ifSql721); 
                    pushFollow(FOLLOW_constant_in_ifSql725);
                    cnst=constant();

                    state._fsp--;

                    addConstant(metaIfItem, cnst, ((parse_scope)parse_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlStatement.g:162:50: ( ifSql[metaIfItem] )?
                    int alt15=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt15=1;
                            }
                            break;
                    }

                    switch (alt15) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:162:50: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql732);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlStatement.g:163:9: AT col= column ( ifSql[metaIfItem] )?
                    {
                    match(input,AT,FOLLOW_AT_in_ifSql744); 
                    pushFollow(FOLLOW_column_in_ifSql748);
                    col=column();

                    state._fsp--;

                    addColumn(metaIfItem, col, ((parse_scope)parse_stack.peek()).text);((parse_scope)parse_stack.peek()).hasOutputMapping =true;
                    // org/sqlproc/engine/impl/SqlStatement.g:164:82: ( ifSql[metaIfItem] )?
                    int alt16=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt16=1;
                            }
                            break;
                    }

                    switch (alt16) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:164:82: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql760);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 5 :
                    // org/sqlproc/engine/impl/SqlStatement.g:165:4: LBRACE ifMetaSql[metaIfItem] RBRACE ( ifSql[metaIfItem] )?
                    {
                    match(input,LBRACE,FOLLOW_LBRACE_in_ifSql767); 
                    pushFollow(FOLLOW_ifMetaSql_in_ifSql769);
                    ifMetaSql(metaIfItem);

                    state._fsp--;

                    match(input,RBRACE,FOLLOW_RBRACE_in_ifSql772); 
                    // org/sqlproc/engine/impl/SqlStatement.g:165:40: ( ifSql[metaIfItem] )?
                    int alt17=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt17=1;
                            }
                            break;
                    }

                    switch (alt17) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:165:40: ifSql[metaIfItem]
                            {
                            pushFollow(FOLLOW_ifSql_in_ifSql774);
                            ifSql(metaIfItem);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;

            }
            addText(metaIfItem, ((parse_scope)parse_stack.peek()).text);
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return metaIfItem;
    }
    // $ANTLR end "ifSql"


    // $ANTLR start "ifMetaSql"
    // org/sqlproc/engine/impl/SqlStatement.g:168:1: ifMetaSql[SqlMetaIfItem metaIfItem] : ( ( IDENT_DOT | IDENT | WS | NUMBER | REST | COLON | STRING | MINUS | PLUS | LPAREN | RPAREN | NOT | HASH | AT | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* );
    public final void ifMetaSql(SqlMetaIfItem metaIfItem) throws RecognitionException {
        SqlMetaIfItem metaIfItem2 = null;

        SqlMetaLogExpr metaLogExpr = null;


        SqlMetaAndOr metaAndOr; SqlMetaIf metaIf; addText(metaIfItem, ((parse_scope)parse_stack.peek()).text);
        try {
            // org/sqlproc/engine/impl/SqlStatement.g:170:2: ( ( IDENT_DOT | IDENT | WS | NUMBER | REST | COLON | STRING | MINUS | PLUS | LPAREN | RPAREN | NOT | HASH | AT | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* | BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )* )
            int alt23=4;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
            case IDENT:
            case WS:
            case NUMBER:
            case REST:
            case MINUS:
            case PLUS:
            case LPAREN:
            case RPAREN:
            case NOT:
            case HASH:
            case CARET:
            case EQUALS:
            case ESC_COLON:
            case ESC_STRING:
            case ESC_AT:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_HASH:
            case ESC_BOR:
            case COLON:
            case STRING:
            case AT:
                {
                alt23=1;
                }
                break;
            case QUESTI:
                {
                alt23=2;
                }
                break;
            case BAND:
                {
                alt23=3;
                }
                break;
            case BOR:
                {
                alt23=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 23, 0, input);

                throw nvae;
            }

            switch (alt23) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:172:2: ( IDENT_DOT | IDENT | WS | NUMBER | REST | COLON | STRING | MINUS | PLUS | LPAREN | RPAREN | NOT | HASH | AT | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    if ( (input.LA(1)>=IDENT_DOT && input.LA(1)<=RPAREN)||input.LA(1)==NOT||(input.LA(1)>=HASH && input.LA(1)<=AT) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    add(((parse_scope)parse_stack.peek()).text); metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.NO);
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql903);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    metaAndOr.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlStatement.g:174:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop19:
                    do {
                        int alt19=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt19=1;
                            }
                            break;

                        }

                        switch (alt19) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:174:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql912); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql916);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    metaAndOr.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop19;
                        }
                    } while (true);

                    metaIfItem.addElement(metaAndOr);

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:175:4: QUESTI metaLogExpr= ifSqlCond BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    match(input,QUESTI,FOLLOW_QUESTI_in_ifMetaSql928); 
                    metaIf = new SqlMetaIf(); 
                    pushFollow(FOLLOW_ifSqlCond_in_ifMetaSql934);
                    metaLogExpr=ifSqlCond();

                    state._fsp--;

                    metaIf.setExpression(metaLogExpr);
                    match(input,BOR,FOLLOW_BOR_in_ifMetaSql941); 
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql945);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    metaIf.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlStatement.g:177:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop20:
                    do {
                        int alt20=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt20=1;
                            }
                            break;

                        }

                        switch (alt20) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:177:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql954); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql958);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    metaIf.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop20;
                        }
                    } while (true);

                    metaIfItem.addElement(metaIf);

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlStatement.g:179:4: BAND metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    match(input,BAND,FOLLOW_BAND_in_ifMetaSql973); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.AND);
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql979);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    metaAndOr.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlStatement.g:180:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop21:
                    do {
                        int alt21=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt21=1;
                            }
                            break;

                        }

                        switch (alt21) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:180:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql988); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql992);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    metaAndOr.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop21;
                        }
                    } while (true);

                    metaIfItem.addElement(metaAndOr);

                    }
                    break;
                case 4 :
                    // org/sqlproc/engine/impl/SqlStatement.g:181:4: BOR metaIfItem2= ifSql[null] ( BOR metaIfItem2= ifSql[null] )*
                    {
                    match(input,BOR,FOLLOW_BOR_in_ifMetaSql1004); 
                    metaAndOr = new SqlMetaAndOr(SqlMetaAndOr.Type.OR);
                    pushFollow(FOLLOW_ifSql_in_ifMetaSql1010);
                    metaIfItem2=ifSql(null);

                    state._fsp--;

                    metaAndOr.addElement(metaIfItem2);
                    // org/sqlproc/engine/impl/SqlStatement.g:182:3: ( BOR metaIfItem2= ifSql[null] )*
                    loop22:
                    do {
                        int alt22=2;
                        switch ( input.LA(1) ) {
                        case BOR:
                            {
                            alt22=1;
                            }
                            break;

                        }

                        switch (alt22) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:182:4: BOR metaIfItem2= ifSql[null]
                    	    {
                    	    match(input,BOR,FOLLOW_BOR_in_ifMetaSql1019); 
                    	    pushFollow(FOLLOW_ifSql_in_ifMetaSql1023);
                    	    metaIfItem2=ifSql(null);

                    	    state._fsp--;

                    	    metaAndOr.addElement(metaIfItem2);

                    	    }
                    	    break;

                    	default :
                    	    break loop22;
                        }
                    } while (true);

                    metaIfItem.addElement(metaAndOr);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "ifMetaSql"


    // $ANTLR start "ifSqlCond"
    // org/sqlproc/engine/impl/SqlStatement.g:185:1: ifSqlCond returns [SqlMetaLogExpr metaLogExpr] : ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )* ;
    public final SqlMetaLogExpr ifSqlCond() throws RecognitionException {
        SqlMetaLogExpr metaLogExpr = null;

        metaLogExpr = new SqlMetaLogExpr();
        try {
            // org/sqlproc/engine/impl/SqlStatement.g:187:2: ( ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )* )
            // org/sqlproc/engine/impl/SqlStatement.g:188:2: ( WS )* ifSqlBool[metaLogExpr] ( WS )* ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )*
            {
            // org/sqlproc/engine/impl/SqlStatement.g:188:2: ( WS )*
            loop24:
            do {
                int alt24=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt24=1;
                    }
                    break;

                }

                switch (alt24) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlStatement.g:188:2: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_ifSqlCond1050); 

            	    }
            	    break;

            	default :
            	    break loop24;
                }
            } while (true);

            pushFollow(FOLLOW_ifSqlBool_in_ifSqlCond1053);
            ifSqlBool(metaLogExpr);

            state._fsp--;

            // org/sqlproc/engine/impl/SqlStatement.g:188:29: ( WS )*
            loop25:
            do {
                int alt25=2;
                switch ( input.LA(1) ) {
                case WS:
                    {
                    alt25=1;
                    }
                    break;

                }

                switch (alt25) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlStatement.g:188:29: WS
            	    {
            	    match(input,WS,FOLLOW_WS_in_ifSqlCond1056); 

            	    }
            	    break;

            	default :
            	    break loop25;
                }
            } while (true);

            // org/sqlproc/engine/impl/SqlStatement.g:188:33: ( ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )* )*
            loop29:
            do {
                int alt29=2;
                switch ( input.LA(1) ) {
                case AND:
                case OR:
                    {
                    alt29=1;
                    }
                    break;

                }

                switch (alt29) {
            	case 1 :
            	    // org/sqlproc/engine/impl/SqlStatement.g:188:34: ( AND | OR ) ( WS )* ifSqlBool[metaLogExpr] ( WS )*
            	    {
            	    // org/sqlproc/engine/impl/SqlStatement.g:188:34: ( AND | OR )
            	    int alt26=2;
            	    switch ( input.LA(1) ) {
            	    case AND:
            	        {
            	        alt26=1;
            	        }
            	        break;
            	    case OR:
            	        {
            	        alt26=2;
            	        }
            	        break;
            	    default:
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 26, 0, input);

            	        throw nvae;
            	    }

            	    switch (alt26) {
            	        case 1 :
            	            // org/sqlproc/engine/impl/SqlStatement.g:188:35: AND
            	            {
            	            match(input,AND,FOLLOW_AND_in_ifSqlCond1061); 
            	            addOperator(metaLogExpr,true);

            	            }
            	            break;
            	        case 2 :
            	            // org/sqlproc/engine/impl/SqlStatement.g:188:74: OR
            	            {
            	            match(input,OR,FOLLOW_OR_in_ifSqlCond1067); 
            	            addOperator(metaLogExpr,false);

            	            }
            	            break;

            	    }

            	    // org/sqlproc/engine/impl/SqlStatement.g:188:112: ( WS )*
            	    loop27:
            	    do {
            	        int alt27=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt27=1;
            	            }
            	            break;

            	        }

            	        switch (alt27) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlStatement.g:188:112: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_ifSqlCond1072); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop27;
            	        }
            	    } while (true);

            	    pushFollow(FOLLOW_ifSqlBool_in_ifSqlCond1077);
            	    ifSqlBool(metaLogExpr);

            	    state._fsp--;

            	    // org/sqlproc/engine/impl/SqlStatement.g:189:26: ( WS )*
            	    loop28:
            	    do {
            	        int alt28=2;
            	        switch ( input.LA(1) ) {
            	        case WS:
            	            {
            	            alt28=1;
            	            }
            	            break;

            	        }

            	        switch (alt28) {
            	    	case 1 :
            	    	    // org/sqlproc/engine/impl/SqlStatement.g:189:26: WS
            	    	    {
            	    	    match(input,WS,FOLLOW_WS_in_ifSqlCond1080); 

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop28;
            	        }
            	    } while (true);


            	    }
            	    break;

            	default :
            	    break loop29;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return metaLogExpr;
    }
    // $ANTLR end "ifSqlCond"


    // $ANTLR start "ifSqlBool"
    // org/sqlproc/engine/impl/SqlStatement.g:192:1: ifSqlBool[SqlMetaLogExpr metaLogExpr] : ( (not= NOT )? COLON ident= identifier | (not= NOT )? STRING cnst= constant | (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN );
    public final void ifSqlBool(SqlMetaLogExpr metaLogExpr) throws RecognitionException {
        Token not=null;
        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;

        SqlMetaLogExpr newMetaLogExpr = null;


        try {
            // org/sqlproc/engine/impl/SqlStatement.g:193:2: ( (not= NOT )? COLON ident= identifier | (not= NOT )? STRING cnst= constant | (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN )
            int alt33=3;
            switch ( input.LA(1) ) {
            case NOT:
                {
                switch ( input.LA(2) ) {
                case COLON:
                    {
                    alt33=1;
                    }
                    break;
                case STRING:
                    {
                    alt33=2;
                    }
                    break;
                case LPAREN:
                    {
                    alt33=3;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 33, 1, input);

                    throw nvae;
                }

                }
                break;
            case COLON:
                {
                alt33=1;
                }
                break;
            case STRING:
                {
                alt33=2;
                }
                break;
            case LPAREN:
                {
                alt33=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 33, 0, input);

                throw nvae;
            }

            switch (alt33) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:194:2: (not= NOT )? COLON ident= identifier
                    {
                    // org/sqlproc/engine/impl/SqlStatement.g:194:5: (not= NOT )?
                    int alt30=2;
                    switch ( input.LA(1) ) {
                        case NOT:
                            {
                            alt30=1;
                            }
                            break;
                    }

                    switch (alt30) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:194:5: not= NOT
                            {
                            not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1100); 

                            }
                            break;

                    }

                    match(input,COLON,FOLLOW_COLON_in_ifSqlBool1103); 
                    pushFollow(FOLLOW_identifier_in_ifSqlBool1107);
                    ident=identifier();

                    state._fsp--;

                    ident.setNot(not!=null); addIdent(metaLogExpr, ident, ((parse_scope)parse_stack.peek()).text);

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:195:4: (not= NOT )? STRING cnst= constant
                    {
                    // org/sqlproc/engine/impl/SqlStatement.g:195:7: (not= NOT )?
                    int alt31=2;
                    switch ( input.LA(1) ) {
                        case NOT:
                            {
                            alt31=1;
                            }
                            break;
                    }

                    switch (alt31) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:195:7: not= NOT
                            {
                            not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1116); 

                            }
                            break;

                    }

                    match(input,STRING,FOLLOW_STRING_in_ifSqlBool1119); 
                    pushFollow(FOLLOW_constant_in_ifSqlBool1123);
                    cnst=constant();

                    state._fsp--;

                    cnst.setNot(not!=null); addConstant(metaLogExpr, cnst, ((parse_scope)parse_stack.peek()).text);

                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlStatement.g:196:4: (not= NOT )? LPAREN newMetaLogExpr= ifSqlCond RPAREN
                    {
                    // org/sqlproc/engine/impl/SqlStatement.g:196:7: (not= NOT )?
                    int alt32=2;
                    switch ( input.LA(1) ) {
                        case NOT:
                            {
                            alt32=1;
                            }
                            break;
                    }

                    switch (alt32) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:196:7: not= NOT
                            {
                            not=(Token)match(input,NOT,FOLLOW_NOT_in_ifSqlBool1132); 

                            }
                            break;

                    }

                    match(input,LPAREN,FOLLOW_LPAREN_in_ifSqlBool1135); 
                    pushFollow(FOLLOW_ifSqlCond_in_ifSqlBool1139);
                    newMetaLogExpr=ifSqlCond();

                    state._fsp--;

                    match(input,RPAREN,FOLLOW_RPAREN_in_ifSqlBool1141); 
                    metaLogExpr.addElement(newMetaLogExpr);

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "ifSqlBool"


    // $ANTLR start "ordSql"
    // org/sqlproc/engine/impl/SqlStatement.g:199:1: ordSql[SqlMetaOrd ord] : ( ( IDENT_DOT | IDENT | WS | NUMBER | REST | MINUS | PLUS | LPAREN | RPAREN | LBRACE | QUESTI | NOT | BAND | BOR | HASH | AT | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) ( ordSql[ord] )? | COLON ident= identifier ( ordSql[ord] )? | STRING cnst= constant ( ordSql[ord] )? );
    public final void ordSql(SqlMetaOrd ord) throws RecognitionException {
        SqlMetaIdent ident = null;

        SqlMetaConst cnst = null;


        try {
            // org/sqlproc/engine/impl/SqlStatement.g:201:3: ( ( IDENT_DOT | IDENT | WS | NUMBER | REST | MINUS | PLUS | LPAREN | RPAREN | LBRACE | QUESTI | NOT | BAND | BOR | HASH | AT | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) ( ordSql[ord] )? | COLON ident= identifier ( ordSql[ord] )? | STRING cnst= constant ( ordSql[ord] )? )
            int alt37=3;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
            case IDENT:
            case WS:
            case NUMBER:
            case REST:
            case MINUS:
            case PLUS:
            case LPAREN:
            case RPAREN:
            case QUESTI:
            case NOT:
            case BAND:
            case BOR:
            case HASH:
            case CARET:
            case EQUALS:
            case ESC_COLON:
            case ESC_STRING:
            case ESC_AT:
            case ESC_LBRACE:
            case ESC_RBRACE:
            case ESC_HASH:
            case ESC_BOR:
            case AT:
            case LBRACE:
                {
                alt37=1;
                }
                break;
            case COLON:
                {
                alt37=2;
                }
                break;
            case STRING:
                {
                alt37=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 37, 0, input);

                throw nvae;
            }

            switch (alt37) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:203:2: ( IDENT_DOT | IDENT | WS | NUMBER | REST | MINUS | PLUS | LPAREN | RPAREN | LBRACE | QUESTI | NOT | BAND | BOR | HASH | AT | CARET | EQUALS | ESC_COLON | ESC_STRING | ESC_AT | ESC_LBRACE | ESC_RBRACE | ESC_HASH | ESC_BOR ) ( ordSql[ord] )?
                    {
                    if ( (input.LA(1)>=IDENT_DOT && input.LA(1)<=RPAREN)||(input.LA(1)>=QUESTI && input.LA(1)<=ESC_BOR)||(input.LA(1)>=AT && input.LA(1)<=LBRACE) ) {
                        input.consume();
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }

                    add(((parse_scope)parse_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlStatement.g:204:24: ( ordSql[ord] )?
                    int alt34=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case BOR:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt34=1;
                            }
                            break;
                    }

                    switch (alt34) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:204:24: ordSql[ord]
                            {
                            pushFollow(FOLLOW_ordSql_in_ordSql1271);
                            ordSql(ord);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:205:4: COLON ident= identifier ( ordSql[ord] )?
                    {
                    match(input,COLON,FOLLOW_COLON_in_ordSql1278); 
                    pushFollow(FOLLOW_identifier_in_ordSql1282);
                    ident=identifier();

                    state._fsp--;

                    addIdent(ord, ident, ((parse_scope)parse_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlStatement.g:206:41: ( ordSql[ord] )?
                    int alt35=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case BOR:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt35=1;
                            }
                            break;
                    }

                    switch (alt35) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:206:41: ordSql[ord]
                            {
                            pushFollow(FOLLOW_ordSql_in_ordSql1289);
                            ordSql(ord);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // org/sqlproc/engine/impl/SqlStatement.g:207:4: STRING cnst= constant ( ordSql[ord] )?
                    {
                    match(input,STRING,FOLLOW_STRING_in_ordSql1296); 
                    pushFollow(FOLLOW_constant_in_ordSql1300);
                    cnst=constant();

                    state._fsp--;

                    addConstant(ord, cnst, ((parse_scope)parse_stack.peek()).text);
                    // org/sqlproc/engine/impl/SqlStatement.g:208:43: ( ordSql[ord] )?
                    int alt36=2;
                    switch ( input.LA(1) ) {
                        case IDENT_DOT:
                        case IDENT:
                        case WS:
                        case NUMBER:
                        case REST:
                        case MINUS:
                        case PLUS:
                        case LPAREN:
                        case RPAREN:
                        case QUESTI:
                        case NOT:
                        case BAND:
                        case BOR:
                        case HASH:
                        case CARET:
                        case EQUALS:
                        case ESC_COLON:
                        case ESC_STRING:
                        case ESC_AT:
                        case ESC_LBRACE:
                        case ESC_RBRACE:
                        case ESC_HASH:
                        case ESC_BOR:
                        case COLON:
                        case STRING:
                        case AT:
                        case LBRACE:
                            {
                            alt36=1;
                            }
                            break;
                    }

                    switch (alt36) {
                        case 1 :
                            // org/sqlproc/engine/impl/SqlStatement.g:208:43: ordSql[ord]
                            {
                            pushFollow(FOLLOW_ordSql_in_ordSql1306);
                            ordSql(ord);

                            state._fsp--;


                            }
                            break;

                    }


                    }
                    break;

            }
            addText(ord, ((parse_scope)parse_stack.peek()).text);
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "ordSql"


    // $ANTLR start "column"
    // org/sqlproc/engine/impl/SqlStatement.g:211:1: column returns [SqlMappingItem result] : (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? ;
    public final SqlMappingItem column() throws RecognitionException {
        SqlMappingItem result = null;

        Token col=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        try {
            // org/sqlproc/engine/impl/SqlStatement.g:212:2: ( (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )
            // org/sqlproc/engine/impl/SqlStatement.g:213:2: (col= IDENT_DOT | col= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            {
            // org/sqlproc/engine/impl/SqlStatement.g:213:2: (col= IDENT_DOT | col= IDENT )
            int alt38=2;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt38=1;
                }
                break;
            case IDENT:
                {
                alt38=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 38, 0, input);

                throw nvae;
            }

            switch (alt38) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:213:3: col= IDENT_DOT
                    {
                    col=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_column1328); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:213:19: col= IDENT
                    {
                    col=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1334); 

                    }
                    break;

            }

            result = newColumn(col);
            // org/sqlproc/engine/impl/SqlStatement.g:215:3: ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            int alt42=2;
            switch ( input.LA(1) ) {
                case CARET:
                    {
                    switch ( input.LA(2) ) {
                        case IDENT:
                            {
                            alt42=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt42) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:215:29: CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    {
                    match(input,CARET,FOLLOW_CARET_in_column1353); 
                    type=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1357); 
                     setMetaType(((parse_scope)parse_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 
                    // org/sqlproc/engine/impl/SqlStatement.g:216:4: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    loop41:
                    do {
                        int alt41=2;
                        switch ( input.LA(1) ) {
                        case CARET:
                            {
                            switch ( input.LA(2) ) {
                            case IDENT:
                                {
                                alt41=1;
                                }
                                break;
                            case NUMBER:
                                {
                                alt41=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt41) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:216:30: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    {
                    	    match(input,CARET,FOLLOW_CARET_in_column1374); 
                    	    // org/sqlproc/engine/impl/SqlStatement.g:216:36: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    int alt40=2;
                    	    switch ( input.LA(1) ) {
                    	    case IDENT:
                    	        {
                    	        alt40=1;
                    	        }
                    	        break;
                    	    case NUMBER:
                    	        {
                    	        alt40=2;
                    	        }
                    	        break;
                    	    default:
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 40, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt40) {
                    	        case 1 :
                    	            // org/sqlproc/engine/impl/SqlStatement.g:216:37: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            {
                    	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1379); 
                    	            // org/sqlproc/engine/impl/SqlStatement.g:216:49: ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            int alt39=2;
                    	            switch ( input.LA(1) ) {
                    	                case EQUALS:
                    	                    {
                    	                    switch ( input.LA(2) ) {
                    	                        case IDENT:
                    	                            {
                    	                            alt39=1;
                    	                            }
                    	                            break;
                    	                    }

                    	                    }
                    	                    break;
                    	            }

                    	            switch (alt39) {
                    	                case 1 :
                    	                    // org/sqlproc/engine/impl/SqlStatement.g:216:74: EQUALS value2= IDENT
                    	                    {
                    	                    match(input,EQUALS,FOLLOW_EQUALS_in_column1390); 
                    	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_column1394); 

                    	                    }
                    	                    break;

                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // org/sqlproc/engine/impl/SqlStatement.g:216:98: value= NUMBER
                    	            {
                    	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_column1402); 

                    	            }
                    	            break;

                    	    }

                    	     result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop41;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "column"


    // $ANTLR start "constant"
    // org/sqlproc/engine/impl/SqlStatement.g:221:1: constant returns [SqlMetaConst result] : (caseCnst= PLUS | caseCnst= MINUS )? (cnst= IDENT_DOT | cnst= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? ;
    public final SqlMetaConst constant() throws RecognitionException {
        SqlMetaConst result = null;

        Token caseCnst=null;
        Token cnst=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        try {
            // org/sqlproc/engine/impl/SqlStatement.g:222:2: ( (caseCnst= PLUS | caseCnst= MINUS )? (cnst= IDENT_DOT | cnst= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )
            // org/sqlproc/engine/impl/SqlStatement.g:223:2: (caseCnst= PLUS | caseCnst= MINUS )? (cnst= IDENT_DOT | cnst= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            {
            // org/sqlproc/engine/impl/SqlStatement.g:223:2: (caseCnst= PLUS | caseCnst= MINUS )?
            int alt43=3;
            switch ( input.LA(1) ) {
                case PLUS:
                    {
                    alt43=1;
                    }
                    break;
                case MINUS:
                    {
                    alt43=2;
                    }
                    break;
            }

            switch (alt43) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:223:3: caseCnst= PLUS
                    {
                    caseCnst=(Token)match(input,PLUS,FOLLOW_PLUS_in_constant1436); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:223:19: caseCnst= MINUS
                    {
                    caseCnst=(Token)match(input,MINUS,FOLLOW_MINUS_in_constant1442); 

                    }
                    break;

            }

            // org/sqlproc/engine/impl/SqlStatement.g:223:36: (cnst= IDENT_DOT | cnst= IDENT )
            int alt44=2;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt44=1;
                }
                break;
            case IDENT:
                {
                alt44=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 44, 0, input);

                throw nvae;
            }

            switch (alt44) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:223:37: cnst= IDENT_DOT
                    {
                    cnst=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_constant1449); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:223:54: cnst= IDENT
                    {
                    cnst=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1455); 

                    }
                    break;

            }

            result = newConstant(cnst, caseCnst);
            // org/sqlproc/engine/impl/SqlStatement.g:225:3: ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            int alt48=2;
            switch ( input.LA(1) ) {
                case CARET:
                    {
                    switch ( input.LA(2) ) {
                        case IDENT:
                            {
                            alt48=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt48) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:225:29: CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    {
                    match(input,CARET,FOLLOW_CARET_in_constant1474); 
                    type=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1478); 
                     setMetaType(((parse_scope)parse_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 
                    // org/sqlproc/engine/impl/SqlStatement.g:226:4: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    loop47:
                    do {
                        int alt47=2;
                        switch ( input.LA(1) ) {
                        case CARET:
                            {
                            switch ( input.LA(2) ) {
                            case IDENT:
                                {
                                alt47=1;
                                }
                                break;
                            case NUMBER:
                                {
                                alt47=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt47) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:226:30: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    {
                    	    match(input,CARET,FOLLOW_CARET_in_constant1495); 
                    	    // org/sqlproc/engine/impl/SqlStatement.g:226:36: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    int alt46=2;
                    	    switch ( input.LA(1) ) {
                    	    case IDENT:
                    	        {
                    	        alt46=1;
                    	        }
                    	        break;
                    	    case NUMBER:
                    	        {
                    	        alt46=2;
                    	        }
                    	        break;
                    	    default:
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 46, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt46) {
                    	        case 1 :
                    	            // org/sqlproc/engine/impl/SqlStatement.g:226:37: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            {
                    	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1500); 
                    	            // org/sqlproc/engine/impl/SqlStatement.g:226:49: ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            int alt45=2;
                    	            switch ( input.LA(1) ) {
                    	                case EQUALS:
                    	                    {
                    	                    switch ( input.LA(2) ) {
                    	                        case IDENT:
                    	                            {
                    	                            alt45=1;
                    	                            }
                    	                            break;
                    	                    }

                    	                    }
                    	                    break;
                    	            }

                    	            switch (alt45) {
                    	                case 1 :
                    	                    // org/sqlproc/engine/impl/SqlStatement.g:226:74: EQUALS value2= IDENT
                    	                    {
                    	                    match(input,EQUALS,FOLLOW_EQUALS_in_constant1511); 
                    	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_constant1515); 

                    	                    }
                    	                    break;

                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // org/sqlproc/engine/impl/SqlStatement.g:226:98: value= NUMBER
                    	            {
                    	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_constant1523); 

                    	            }
                    	            break;

                    	    }

                    	     result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop47;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "constant"


    // $ANTLR start "identifier"
    // org/sqlproc/engine/impl/SqlStatement.g:231:1: identifier returns [SqlMetaIdent result] : (caseIdent= PLUS | caseIdent= MINUS )? (ident= IDENT_DOT | ident= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? ;
    public final SqlMetaIdent identifier() throws RecognitionException {
        SqlMetaIdent result = null;

        Token caseIdent=null;
        Token ident=null;
        Token type=null;
        Token value=null;
        Token value2=null;

        try {
            // org/sqlproc/engine/impl/SqlStatement.g:232:2: ( (caseIdent= PLUS | caseIdent= MINUS )? (ident= IDENT_DOT | ident= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )? )
            // org/sqlproc/engine/impl/SqlStatement.g:233:2: (caseIdent= PLUS | caseIdent= MINUS )? (ident= IDENT_DOT | ident= IDENT ) ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            {
            // org/sqlproc/engine/impl/SqlStatement.g:233:2: (caseIdent= PLUS | caseIdent= MINUS )?
            int alt49=3;
            switch ( input.LA(1) ) {
                case PLUS:
                    {
                    alt49=1;
                    }
                    break;
                case MINUS:
                    {
                    alt49=2;
                    }
                    break;
            }

            switch (alt49) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:233:3: caseIdent= PLUS
                    {
                    caseIdent=(Token)match(input,PLUS,FOLLOW_PLUS_in_identifier1557); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:233:20: caseIdent= MINUS
                    {
                    caseIdent=(Token)match(input,MINUS,FOLLOW_MINUS_in_identifier1563); 

                    }
                    break;

            }

            // org/sqlproc/engine/impl/SqlStatement.g:233:38: (ident= IDENT_DOT | ident= IDENT )
            int alt50=2;
            switch ( input.LA(1) ) {
            case IDENT_DOT:
                {
                alt50=1;
                }
                break;
            case IDENT:
                {
                alt50=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 50, 0, input);

                throw nvae;
            }

            switch (alt50) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:233:39: ident= IDENT_DOT
                    {
                    ident=(Token)match(input,IDENT_DOT,FOLLOW_IDENT_DOT_in_identifier1570); 

                    }
                    break;
                case 2 :
                    // org/sqlproc/engine/impl/SqlStatement.g:233:57: ident= IDENT
                    {
                    ident=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1576); 

                    }
                    break;

            }

            result = newIdent(ident, caseIdent);
            // org/sqlproc/engine/impl/SqlStatement.g:235:3: ( options {greedy=true; } : CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )* )?
            int alt54=2;
            switch ( input.LA(1) ) {
                case CARET:
                    {
                    switch ( input.LA(2) ) {
                        case IDENT:
                            {
                            alt54=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt54) {
                case 1 :
                    // org/sqlproc/engine/impl/SqlStatement.g:235:29: CARET type= IDENT ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    {
                    match(input,CARET,FOLLOW_CARET_in_identifier1595); 
                    type=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1599); 
                     setMetaType(((parse_scope)parse_stack.peek()).typeFactory, result, (type!=null?type.getText():null)); 
                    // org/sqlproc/engine/impl/SqlStatement.g:236:4: ( options {greedy=true; } : CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER ) )*
                    loop53:
                    do {
                        int alt53=2;
                        switch ( input.LA(1) ) {
                        case CARET:
                            {
                            switch ( input.LA(2) ) {
                            case IDENT:
                                {
                                alt53=1;
                                }
                                break;
                            case NUMBER:
                                {
                                alt53=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt53) {
                    	case 1 :
                    	    // org/sqlproc/engine/impl/SqlStatement.g:236:30: CARET (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    {
                    	    match(input,CARET,FOLLOW_CARET_in_identifier1616); 
                    	    // org/sqlproc/engine/impl/SqlStatement.g:236:36: (value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )? | value= NUMBER )
                    	    int alt52=2;
                    	    switch ( input.LA(1) ) {
                    	    case IDENT:
                    	        {
                    	        alt52=1;
                    	        }
                    	        break;
                    	    case NUMBER:
                    	        {
                    	        alt52=2;
                    	        }
                    	        break;
                    	    default:
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 52, 0, input);

                    	        throw nvae;
                    	    }

                    	    switch (alt52) {
                    	        case 1 :
                    	            // org/sqlproc/engine/impl/SqlStatement.g:236:37: value= IDENT ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            {
                    	            value=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1621); 
                    	            // org/sqlproc/engine/impl/SqlStatement.g:236:49: ( options {greedy=true; } : EQUALS value2= IDENT )?
                    	            int alt51=2;
                    	            switch ( input.LA(1) ) {
                    	                case EQUALS:
                    	                    {
                    	                    switch ( input.LA(2) ) {
                    	                        case IDENT:
                    	                            {
                    	                            alt51=1;
                    	                            }
                    	                            break;
                    	                    }

                    	                    }
                    	                    break;
                    	            }

                    	            switch (alt51) {
                    	                case 1 :
                    	                    // org/sqlproc/engine/impl/SqlStatement.g:236:74: EQUALS value2= IDENT
                    	                    {
                    	                    match(input,EQUALS,FOLLOW_EQUALS_in_identifier1632); 
                    	                    value2=(Token)match(input,IDENT,FOLLOW_IDENT_in_identifier1636); 

                    	                    }
                    	                    break;

                    	            }


                    	            }
                    	            break;
                    	        case 2 :
                    	            // org/sqlproc/engine/impl/SqlStatement.g:236:98: value= NUMBER
                    	            {
                    	            value=(Token)match(input,NUMBER,FOLLOW_NUMBER_in_identifier1644); 

                    	            }
                    	            break;

                    	    }

                    	     result.setValues((value!=null?value.getText():null), (value2!=null?value2.getText():null)); 

                    	    }
                    	    break;

                    	default :
                    	    break loop53;
                        }
                    } while (true);


                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return result;
    }
    // $ANTLR end "identifier"

    // Delegated rules


 

    public static final BitSet FOLLOW_sql_in_parse65 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_parse68 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_sql92 = new BitSet(new long[]{0x00000000FFFFFFF2L});
    public static final BitSet FOLLOW_sql_in_sql193 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLON_in_sql200 = new BitSet(new long[]{0x0000000000000630L});
    public static final BitSet FOLLOW_identifier_in_sql204 = new BitSet(new long[]{0x00000000FFFFFFF2L});
    public static final BitSet FOLLOW_sql_in_sql211 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_sql223 = new BitSet(new long[]{0x0000000000000630L});
    public static final BitSet FOLLOW_constant_in_sql227 = new BitSet(new long[]{0x00000000FFFFFFF2L});
    public static final BitSet FOLLOW_sql_in_sql239 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AT_in_sql251 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_column_in_sql255 = new BitSet(new long[]{0x00000000FFFFFFF2L});
    public static final BitSet FOLLOW_sql_in_sql267 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LBRACE_in_sql279 = new BitSet(new long[]{0x000000007FFFDFF0L});
    public static final BitSet FOLLOW_metaSql_in_sql281 = new BitSet(new long[]{0x0000000000002000L});
    public static final BitSet FOLLOW_RBRACE_in_sql284 = new BitSet(new long[]{0x00000000FFFFFFF2L});
    public static final BitSet FOLLOW_sql_in_sql286 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_metaSql315 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql405 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BOR_in_metaSql414 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql418 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_QUESTI_in_metaSql430 = new BitSet(new long[]{0x0000000030008840L});
    public static final BitSet FOLLOW_ifSqlCond_in_metaSql436 = new BitSet(new long[]{0x0000000000020000L});
    public static final BitSet FOLLOW_BOR_in_metaSql443 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql447 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BOR_in_metaSql456 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql460 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BAND_in_metaSql475 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql481 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BOR_in_metaSql490 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql494 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BOR_in_metaSql506 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql512 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BOR_in_metaSql521 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql525 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_EQUALS_in_metaSql537 = new BitSet(new long[]{0x0000000000000060L});
    public static final BitSet FOLLOW_WS_in_metaSql539 = new BitSet(new long[]{0x0000000000000060L});
    public static final BitSet FOLLOW_IDENT_in_metaSql544 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_metaSql550 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_HASH_in_metaSql563 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_NUMBER_in_metaSql567 = new BitSet(new long[]{0x00000000FFFFDFF0L});
    public static final BitSet FOLLOW_ordSql_in_metaSql571 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_ifSql604 = new BitSet(new long[]{0x00000000FFFDDFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql696 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLON_in_ifSql703 = new BitSet(new long[]{0x0000000000000630L});
    public static final BitSet FOLLOW_identifier_in_ifSql707 = new BitSet(new long[]{0x00000000FFFDDFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql714 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_ifSql721 = new BitSet(new long[]{0x0000000000000630L});
    public static final BitSet FOLLOW_constant_in_ifSql725 = new BitSet(new long[]{0x00000000FFFDDFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql732 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_AT_in_ifSql744 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_column_in_ifSql748 = new BitSet(new long[]{0x00000000FFFDDFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql760 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LBRACE_in_ifSql767 = new BitSet(new long[]{0x000000007FFFDFF0L});
    public static final BitSet FOLLOW_ifMetaSql_in_ifSql769 = new BitSet(new long[]{0x0000000000002000L});
    public static final BitSet FOLLOW_RBRACE_in_ifSql772 = new BitSet(new long[]{0x00000000FFFDDFF2L});
    public static final BitSet FOLLOW_ifSql_in_ifSql774 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_ifMetaSql804 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql903 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql912 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql916 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_QUESTI_in_ifMetaSql928 = new BitSet(new long[]{0x0000000030008840L});
    public static final BitSet FOLLOW_ifSqlCond_in_ifMetaSql934 = new BitSet(new long[]{0x0000000000020000L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql941 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql945 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql954 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql958 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BAND_in_ifMetaSql973 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql979 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql988 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql992 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql1004 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql1010 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_BOR_in_ifMetaSql1019 = new BitSet(new long[]{0x00000000FFFDDFF0L});
    public static final BitSet FOLLOW_ifSql_in_ifMetaSql1023 = new BitSet(new long[]{0x0000000000020002L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1050 = new BitSet(new long[]{0x0000000030008840L});
    public static final BitSet FOLLOW_ifSqlBool_in_ifSqlCond1053 = new BitSet(new long[]{0x0000000300000042L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1056 = new BitSet(new long[]{0x0000000300000042L});
    public static final BitSet FOLLOW_AND_in_ifSqlCond1061 = new BitSet(new long[]{0x0000000030008840L});
    public static final BitSet FOLLOW_OR_in_ifSqlCond1067 = new BitSet(new long[]{0x0000000030008840L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1072 = new BitSet(new long[]{0x0000000030008840L});
    public static final BitSet FOLLOW_ifSqlBool_in_ifSqlCond1077 = new BitSet(new long[]{0x0000000300000042L});
    public static final BitSet FOLLOW_WS_in_ifSqlCond1080 = new BitSet(new long[]{0x0000000300000042L});
    public static final BitSet FOLLOW_NOT_in_ifSqlBool1100 = new BitSet(new long[]{0x0000000010000000L});
    public static final BitSet FOLLOW_COLON_in_ifSqlBool1103 = new BitSet(new long[]{0x0000000000000630L});
    public static final BitSet FOLLOW_identifier_in_ifSqlBool1107 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_ifSqlBool1116 = new BitSet(new long[]{0x0000000020000000L});
    public static final BitSet FOLLOW_STRING_in_ifSqlBool1119 = new BitSet(new long[]{0x0000000000000630L});
    public static final BitSet FOLLOW_constant_in_ifSqlBool1123 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NOT_in_ifSqlBool1132 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_LPAREN_in_ifSqlBool1135 = new BitSet(new long[]{0x0000000030008840L});
    public static final BitSet FOLLOW_ifSqlCond_in_ifSqlBool1139 = new BitSet(new long[]{0x0000000000001000L});
    public static final BitSet FOLLOW_RPAREN_in_ifSqlBool1141 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_ordSql1167 = new BitSet(new long[]{0x00000000FFFFDFF2L});
    public static final BitSet FOLLOW_ordSql_in_ordSql1271 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COLON_in_ordSql1278 = new BitSet(new long[]{0x0000000000000630L});
    public static final BitSet FOLLOW_identifier_in_ordSql1282 = new BitSet(new long[]{0x00000000FFFFDFF2L});
    public static final BitSet FOLLOW_ordSql_in_ordSql1289 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_ordSql1296 = new BitSet(new long[]{0x0000000000000630L});
    public static final BitSet FOLLOW_constant_in_ordSql1300 = new BitSet(new long[]{0x00000000FFFFDFF2L});
    public static final BitSet FOLLOW_ordSql_in_ordSql1306 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENT_DOT_in_column1328 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_IDENT_in_column1334 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_CARET_in_column1353 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_column1357 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_CARET_in_column1374 = new BitSet(new long[]{0x00000000000000A0L});
    public static final BitSet FOLLOW_IDENT_in_column1379 = new BitSet(new long[]{0x0000000000180002L});
    public static final BitSet FOLLOW_EQUALS_in_column1390 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_column1394 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_NUMBER_in_column1402 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_PLUS_in_constant1436 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_MINUS_in_constant1442 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_IDENT_DOT_in_constant1449 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_IDENT_in_constant1455 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_CARET_in_constant1474 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_constant1478 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_CARET_in_constant1495 = new BitSet(new long[]{0x00000000000000A0L});
    public static final BitSet FOLLOW_IDENT_in_constant1500 = new BitSet(new long[]{0x0000000000180002L});
    public static final BitSet FOLLOW_EQUALS_in_constant1511 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_constant1515 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_NUMBER_in_constant1523 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_PLUS_in_identifier1557 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_MINUS_in_identifier1563 = new BitSet(new long[]{0x0000000000000030L});
    public static final BitSet FOLLOW_IDENT_DOT_in_identifier1570 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_IDENT_in_identifier1576 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_CARET_in_identifier1595 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_identifier1599 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_CARET_in_identifier1616 = new BitSet(new long[]{0x00000000000000A0L});
    public static final BitSet FOLLOW_IDENT_in_identifier1621 = new BitSet(new long[]{0x0000000000180002L});
    public static final BitSet FOLLOW_EQUALS_in_identifier1632 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_IDENT_in_identifier1636 = new BitSet(new long[]{0x0000000000080002L});
    public static final BitSet FOLLOW_NUMBER_in_identifier1644 = new BitSet(new long[]{0x0000000000080002L});

}