/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlPropertiesLoader {
    protected final Logger logger;
    private Properties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SqlPropertiesLoader(String fileName, Class<?> loaderClass) {
        block22: {
            this.logger = LoggerFactory.getLogger(this.getClass());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(">> SqlPropertiesLoader, fileName=" + fileName + ", loaderClass=" + loaderClass);
            }
            try {
                String configFile = "/" + fileName;
                InputStream is = loaderClass.getResourceAsStream(configFile);
                if (is == null) {
                    configFile = fileName;
                    is = loaderClass.getResourceAsStream(configFile);
                }
                if (is == null) {
                    try {
                        configFile = "/" + fileName;
                        is = new FileInputStream(configFile);
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                if (is == null) {
                    try {
                        configFile = System.getProperty("user.home") + configFile;
                        is = new FileInputStream(configFile);
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                this.properties = new Properties();
                if (is == null) break block22;
                this.properties.load(is);
                try {
                    is.close();
                }
                catch (IOException ignore) {}
                break block22;
                catch (IOException ioe) {
                    try {
                        is.close();
                    }
                    catch (IOException ignore) {}
                    break block22;
                    catch (Throwable throwable) {
                        try {
                            is.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            finally {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("<< SqlPropertiesLoader, properties=" + this.properties);
                }
            }
        }
    }

    public String get(String name) {
        return this.properties.getProperty(name);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Queries: ");
        boolean first = true;
        for (String name : this.properties.stringPropertyNames()) {
            if (!first) {
                sb.append("\n");
            } else {
                first = false;
            }
            sb.append(name).append("=").append(this.properties.getProperty(name));
        }
        return sb.toString();
    }
}

