/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.IdentitySetter;

public class JdbcQuery
implements SqlQuery {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    Connection connection;
    String queryString;
    List<String> scalars = new ArrayList<String>();
    Map<String, Object> scalarTypes = new HashMap<String, Object>();
    List<String> parameters = new ArrayList<String>();
    Map<String, Object> parameterValues = new HashMap<String, Object>();
    Map<String, Object> parameterTypes = new HashMap<String, Object>();
    List<String> identities = new ArrayList<String>();
    Map<String, IdentitySetter> identitySetters = new HashMap<String, IdentitySetter>();
    Map<String, Object> identityTypes = new HashMap<String, Object>();
    Integer timeout;
    Integer firstResult;
    Integer maxResults;

    public JdbcQuery(Connection connection, String queryString) {
        this.connection = connection;
        this.queryString = queryString;
    }

    @Override
    public Object getQuery() {
        return this.connection;
    }

    @Override
    public SqlQuery setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public SqlQuery setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public SqlQuery setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public List list() throws SqlProcessorException {
        String query;
        StringBuilder queryResult = this.maxResults != null ? new StringBuilder(this.queryString.length() + 100) : null;
        SqlUtils.LimitType limitType = this.maxResults != null ? SqlUtils.limitQuery(this.queryString, queryResult, this.firstResult, this.maxResults) : null;
        String string = query = limitType != null ? queryResult.toString() : this.queryString;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("list, query=" + query);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement(query);
            if (this.timeout != null) {
                ps.setQueryTimeout(this.timeout);
            }
            this.setParameters(ps, limitType);
            rs = ps.executeQuery();
            List list = this.getResults(rs);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("list, number of returned rows=" + (list != null ? Integer.valueOf(list.size()) : "null"));
            }
            List list2 = list;
            return list2;
        }
        catch (SQLException he) {
            throw new SqlProcessorException(he);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    @Override
    public Object uniqueResult() throws SqlProcessorException {
        List list = this.list();
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Object first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new SqlProcessorException("There's no unique result, the number of returned rows is " + list.size());
        }
        return first;
    }

    @Override
    public int executeUpdate() throws SqlProcessorException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("update, query=" + this.queryString);
        }
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(this.queryString);
            if (this.timeout != null) {
                ps.setQueryTimeout(this.timeout);
            }
            this.setParameters(ps, null);
            int updated = ps.executeUpdate();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("update, number of updated rows=" + updated);
            }
            if (!this.identities.isEmpty()) {
                String identityName = this.identities.get(0);
                this.doIdentitySelect(identityName);
            }
            int n = updated;
            return n;
        }
        catch (SQLException he) {
            throw new SqlProcessorException(he);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    protected void doIdentitySelect(String identityName) {
        IdentitySetter identitySetter = this.identitySetters.get(identityName);
        Object identityType = this.identityTypes.get(identityName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("identity, name=" + identityName + ", select=" + identitySetter.getIdentitySelect() + ", identityType=" + identityType);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Object identityValue = null;
        try {
            ps = this.connection.prepareStatement(identitySetter.getIdentitySelect());
            rs = ps.executeQuery();
            while (rs.next()) {
                identityValue = identityType != null && identityType instanceof JdbcSqlType ? ((JdbcSqlType)identityType).get(rs, identityName) : rs.getObject(1);
                if (!rs.wasNull()) continue;
                identityValue = null;
            }
            identitySetter.setIdentity(identityValue);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("identity, result=" + identityValue);
            }
        }
        catch (SQLException he) {
            throw new SqlProcessorException(he);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ignore) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException ignore) {}
            }
        }
    }

    @Override
    public SqlQuery addScalar(String columnAlias) {
        this.scalars.add(columnAlias);
        return this;
    }

    @Override
    public SqlQuery addScalar(String columnAlias, Object type) {
        this.scalars.add(columnAlias);
        this.scalarTypes.put(columnAlias, type);
        return this;
    }

    @Override
    public SqlQuery setParameter(String name, Object val) throws SqlProcessorException {
        this.parameters.add(name);
        this.parameterValues.put(name, val);
        return this;
    }

    @Override
    public SqlQuery setParameter(String name, Object val, Object type) throws SqlProcessorException {
        if (val != null && val instanceof IdentitySetter) {
            this.identities.add(name);
            this.identitySetters.put(name, (IdentitySetter)val);
            this.identityTypes.put(name, type);
        } else {
            this.parameters.add(name);
            this.parameterValues.put(name, val);
            this.parameterTypes.put(name, type);
        }
        return this;
    }

    @Override
    public SqlQuery setParameterList(String name, Object[] vals) throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlQuery setParameterList(String name, Object[] vals, Object type) throws SqlProcessorException {
        throw new UnsupportedOperationException();
    }

    protected void setParameters(PreparedStatement ps, SqlUtils.LimitType limitType) throws SQLException {
        int ix = 1;
        ix = this.setLimits(ps, limitType, ix, false);
        int n = this.parameters.size();
        for (int i = 0; i < n; ++i) {
            String name = this.parameters.get(i);
            Object value = this.parameterValues.get(name);
            Object type = this.parameterTypes.get(name);
            if (type != null) {
                if (type instanceof JdbcSqlType) {
                    ((JdbcSqlType)type).set(ps, ix++, value);
                    continue;
                }
                ps.setObject(ix++, value, (Integer)type);
                continue;
            }
            ps.setObject(ix++, value);
        }
        ix = this.setLimits(ps, limitType, ix, true);
    }

    protected int setLimits(PreparedStatement ps, SqlUtils.LimitType limitType, int ix, boolean afterSql) throws SQLException {
        if (limitType == null) {
            return ix;
        }
        if (afterSql && !limitType.afterSql) {
            return ix;
        }
        if (!afterSql && limitType.afterSql) {
            return ix;
        }
        if (limitType.maxBeforeFirst) {
            if (limitType.rowidBasedMax && limitType.alsoFirst) {
                ps.setInt(ix++, this.firstResult + this.maxResults);
            } else {
                ps.setInt(ix++, this.maxResults);
            }
        }
        if (limitType.alsoFirst) {
            if (limitType.zeroBasedFirst) {
                ps.setInt(ix++, this.firstResult);
            } else {
                ps.setInt(ix++, this.firstResult);
            }
        }
        if (!limitType.maxBeforeFirst) {
            if (limitType.rowidBasedMax && limitType.alsoFirst) {
                ps.setInt(ix++, this.firstResult + this.maxResults);
            } else {
                ps.setInt(ix++, this.maxResults);
            }
        }
        return ix;
    }

    protected List getResults(ResultSet rs) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        while (rs.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            int n = this.scalars.size();
            for (int i = 0; i < n; ++i) {
                String name = this.scalars.get(i);
                Object type = this.scalarTypes.get(name);
                Object value = null;
                value = type != null && type instanceof JdbcSqlType ? ((JdbcSqlType)type).get(rs, name) : rs.getObject(name);
                if (rs.wasNull()) {
                    value = null;
                }
                row.add(value);
            }
            Object[] oo = row.toArray();
            if (oo.length == 1) {
                result.add(oo[0]);
                continue;
            }
            result.add(oo);
        }
        return result;
    }
}

