/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMappingItem;
import org.sqlproc.engine.impl.SqlProcessContext;

public class SqlProcessResult
implements Comparable<SqlProcessResult> {
    private boolean add;
    private List<String> allInputValues = new ArrayList<String>();
    private Map<String, SqlInputValue> inputValues;
    private Map<String, SqlMappingItem> outputValues;
    private Map<String, SqlInputValue> identities;
    private StringBuilder sql;
    private Integer orderIndex;
    private SqlProcessContext ctx;
    private boolean skipNextText;

    SqlProcessResult(SqlProcessContext ctx) {
        this();
        this.ctx = ctx;
    }

    SqlProcessResult() {
        this.inputValues = new LinkedHashMap<String, SqlInputValue>();
        this.outputValues = new LinkedHashMap<String, SqlMappingItem>();
        this.identities = new HashMap<String, SqlInputValue>();
        this.sql = new StringBuilder();
    }

    SqlProcessResult(String sql) {
        this.inputValues = new HashMap<String, SqlInputValue>();
        this.outputValues = new LinkedHashMap<String, SqlMappingItem>();
        this.identities = new HashMap<String, SqlInputValue>();
        if (sql != null) {
            this.sql = new StringBuilder(sql);
            this.add = true;
        } else {
            this.sql = null;
            this.add = false;
        }
    }

    void addFalse() {
        this.add = false;
    }

    void addTrue() {
        this.add = true;
    }

    void add(boolean add) {
        this.add = add;
    }

    boolean isAdd() {
        return this.add;
    }

    void addInputValue(String key, SqlInputValue value) {
        this.allInputValues.add(key);
        if (!this.inputValues.containsKey(key)) {
            this.inputValues.put(key, value);
        }
    }

    void addInputValues(List<String> inputValues) {
        if (inputValues != null) {
            this.allInputValues.addAll(inputValues);
        }
    }

    void addMappedInputValues(Map<String, SqlInputValue> inputValues) {
        if (inputValues != null) {
            this.inputValues.putAll(inputValues);
        }
    }

    List<String> getInputValues() {
        return this.allInputValues;
    }

    Map<String, SqlInputValue> getMappedInputValues() {
        return this.inputValues;
    }

    SqlInputValue getInputValue(String name) {
        return this.inputValues.get(name);
    }

    void addOutputValue(String key, SqlMappingItem value) {
        if (!this.outputValues.containsKey(key)) {
            this.outputValues.put(key, value);
        }
    }

    void addOutputValues(Map<String, SqlMappingItem> outputValues) {
        if (outputValues != null) {
            this.outputValues.putAll(outputValues);
        }
    }

    Map<String, SqlMappingItem> getOutputValues() {
        return this.outputValues;
    }

    void addIdentity(String key, SqlInputValue value) {
        if (!this.identities.containsKey(key)) {
            this.identities.put(key, value);
        }
    }

    void addIdentities(Map<String, SqlInputValue> identities) {
        if (identities != null) {
            this.identities.putAll(identities);
        }
    }

    Map<String, SqlInputValue> getIdentities() {
        return this.identities;
    }

    void setSql(StringBuilder sql) {
        this.sql = sql;
    }

    public StringBuilder getSql() {
        return this.sql;
    }

    void setOrderIndex(Integer orderIndex) {
        this.orderIndex = orderIndex;
    }

    Integer getOrderIndex() {
        return this.orderIndex;
    }

    boolean isSkipNextText() {
        return this.skipNextText;
    }

    void setSkipNextText(boolean skipNextText) {
        this.skipNextText = skipNextText;
    }

    public void setQueryParams(SqlSession session, SqlQuery query) throws SqlRuntimeException {
        for (String paramName : this.allInputValues) {
            SqlInputValue inputValue = this.inputValues.get(paramName);
            inputValue.setQueryParam(session, query, paramName);
        }
    }

    public void postProcess() throws SqlRuntimeException {
        for (String paramName : this.identities.keySet()) {
            SqlInputValue inputValue = this.identities.get(paramName);
            inputValue.setIdentityResult(paramName);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SqlProcessResult:");
        sb.append(" add=").append(this.add);
        if (this.inputValues != null) {
            for (String paramName : this.inputValues.keySet()) {
                SqlInputValue value = this.inputValues.get(paramName);
                sb.append(", ident=").append(paramName).append(", value=").append(value);
            }
        }
        sb.append(" s='").append((CharSequence)this.sql).append("'");
        return sb.toString();
    }

    @Override
    public int compareTo(SqlProcessResult o) {
        if (this.getOrderIndex() == null || o.getOrderIndex() == null) {
            throw new RuntimeException("Compared non-order processing results");
        }
        return this.getOrderIndex().compareTo(o.getOrderIndex());
    }
}

