/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.type.IdentitySetter;
import org.sqlproc.engine.type.OutValueSetter;

class SqlInputValue {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Type valueType;
    private Code caseConversion;
    private Mode inOutMode;
    private Object inputValue;
    private Object parentInputValue;
    Class<?> inputValueType;
    private String likeChar;
    private int minLikeLength;
    private SqlType type;
    private String sequence;
    private String identitySelect;
    private Object identity;
    private Object outValue;

    SqlInputValue(Type valueType, Object inputValue, Object parentInputValue, Class<?> inputValueType, Code caseConversion, Mode inOutMode, SqlType type) {
        this.valueType = valueType;
        this.inputValue = inputValue;
        this.parentInputValue = parentInputValue;
        this.inputValueType = inputValueType;
        this.caseConversion = caseConversion;
        this.inOutMode = inOutMode;
        this.type = type;
    }

    SqlInputValue(Type valueType, Object inputValue, Object parentInputValue, Class<?> inputValueType, String sequenceOrIdentitySelect, SqlType type) {
        this.valueType = valueType;
        this.inputValue = inputValue;
        this.parentInputValue = parentInputValue;
        this.inputValueType = inputValueType;
        if (valueType == Type.SEQUENCE_BASED) {
            this.sequence = sequenceOrIdentitySelect;
        } else {
            this.identitySelect = sequenceOrIdentitySelect;
        }
        this.type = type;
    }

    void setQueryParam(SqlSession session, SqlQuery query, String paramName) throws SqlRuntimeException {
        if (this.sequence != null) {
            SqlQuery seqQuery = session.createSqlQuery(this.sequence);
            SqlProcessContext.getTypeFactory().getDefaultType().addScalar(seqQuery, "1", this.inputValueType);
            this.identity = seqQuery.unique();
            this.type.setParameter(query, paramName, this.identity, this.inputValueType);
        } else if (this.identitySelect != null) {
            SqlProcessContext.getTypeFactory().getIdentityType().setParameter(query, paramName, new IdentitySetter(){

                @Override
                public void setIdentity(Object identity) {
                    SqlInputValue.this.identity = identity;
                }

                @Override
                public String getIdentitySelect() {
                    return SqlInputValue.this.identitySelect;
                }
            }, this.inputValueType, SqlProcessContext.isFeature("IGNORE_INPROPER_IN"));
        } else if (this.inOutMode == Mode.IN || this.inOutMode == Mode.INOUT) {
            Object o = this.inputValue;
            if (this.inputValue instanceof String) {
                if (this.caseConversion == Code.NONE) {
                    o = this.processLike(this.inputValue);
                } else if (this.caseConversion == Code.LOWER) {
                    o = this.inputValue != null ? this.processLike(this.inputValue).toLowerCase() : (String)null;
                } else if (this.caseConversion == Code.UPPER) {
                    o = this.inputValue != null ? this.processLike(this.inputValue).toUpperCase() : (String)null;
                }
            }
            this.type.setParameter(query, paramName, o, this.inputValueType);
            if (this.inOutMode == Mode.INOUT) {
                this.type.setParameter(query, paramName, new OutValueSetter(){

                    @Override
                    public void setOutValue(Object outValue) {
                        SqlInputValue.this.outValue = outValue;
                    }
                }, this.inputValueType);
            }
        } else if (this.inOutMode == Mode.OUT) {
            this.type.setParameter(query, paramName, new OutValueSetter(){

                @Override
                public void setOutValue(Object outValue) {
                    SqlInputValue.this.outValue = outValue;
                }
            }, this.inputValueType);
        }
    }

    void setIdentityResult(String paramName) throws SqlRuntimeException {
        this.type.setResult(this.parentInputValue, paramName, this.identity);
    }

    void setOutValueResult(String paramName) throws SqlRuntimeException {
        if (Character.isDigit(paramName.charAt(0))) {
            return;
        }
        this.type.setResult(this.parentInputValue, paramName, this.outValue);
    }

    void setLike(String likeChar, Integer minLikeLength) {
        this.likeChar = likeChar;
        this.minLikeLength = minLikeLength == null ? 1 : minLikeLength;
    }

    private String processLike(Object val) {
        String param = (String)val;
        if (this.likeChar != null && param != null) {
            param = param.trim();
            int length = param.length();
            boolean startsWith = param.startsWith(this.likeChar);
            boolean endsWith = param.endsWith(this.likeChar);
            if (startsWith && endsWith) {
                return param;
            }
            if (startsWith) {
                if (length >= this.minLikeLength + 1) {
                    return param + this.likeChar;
                }
                return param;
            }
            if (endsWith) {
                if (length >= this.minLikeLength + 1) {
                    return this.likeChar + param;
                }
                return param;
            }
            if (length >= this.minLikeLength) {
                return this.likeChar + param + this.likeChar;
            }
            return param;
        }
        return param;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SqlInputValue:");
        sb.append(" caseConversion=").append((Object)this.caseConversion);
        sb.append(" value='").append(this.inputValue).append("'");
        return sb.toString();
    }

    static enum Mode {
        IN,
        OUT,
        INOUT;

    }

    static enum Code {
        NONE,
        UPPER,
        LOWER;

    }

    static enum Type {
        PROVIDED,
        SEQUENCE_BASED,
        IDENTITY_SELECT;

    }
}

