/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.plugin;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.IsEmptyPlugin;
import org.sqlproc.engine.plugin.IsTruePlugin;
import org.sqlproc.engine.plugin.SqlCountPlugin;
import org.sqlproc.engine.plugin.SqlFromToPlugin;
import org.sqlproc.engine.plugin.SqlIdentityPlugin;
import org.sqlproc.engine.plugin.SqlSequencePlugin;
import org.sqlproc.engine.type.SqlMetaType;

public class DefaultSqlPlugins
implements IsEmptyPlugin,
IsTruePlugin,
SqlCountPlugin,
SqlFromToPlugin,
SqlSequencePlugin,
SqlIdentityPlugin {
    public static final String MODIFIER_NOTNULL = "notnull";
    public static final String MODIFIER_ANY = "any";
    public static final String MODIFIER_NULL = "null";
    public static final String MODIFIER_CALL = "call";

    @Override
    public boolean isNotEmpty(String attributeName, Object obj, Object parentObj, SqlMetaType sqlMetaType, String inOutModifier, boolean inSqlSetOrInsert, Map<String, String> values, Map<String, Object> features) throws IllegalArgumentException {
        String value;
        Boolean delegatedResult = this.callMethod(attributeName, parentObj, values);
        if (delegatedResult != null) {
            return delegatedResult;
        }
        String string = value = inOutModifier != null ? inOutModifier.toLowerCase() : null;
        if (MODIFIER_NOTNULL.equalsIgnoreCase(value) && obj == null) {
            throw new IllegalArgumentException(MODIFIER_NOTNULL);
        }
        if (inSqlSetOrInsert) {
            Object o;
            boolean isEmptyUseMethodIsNull = false;
            if (obj == null && attributeName != null && parentObj != null && (o = features.get("EMPTY_USE_METHOD_IS_NULL")) != null && o instanceof Boolean && ((Boolean)o).booleanValue()) {
                isEmptyUseMethodIsNull = true;
            }
            Object isNullObj = null;
            if (isEmptyUseMethodIsNull) {
                try {
                    isNullObj = MethodUtils.invokeMethod((Object)parentObj, (String)"isNull", (Object)attributeName);
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (isNullObj != null && isNullObj instanceof Boolean && ((Boolean)isNullObj).booleanValue()) {
                return true;
            }
            boolean isEmptyForNull = isEmptyUseMethodIsNull;
            if (obj == null) {
                Object o2 = features.get("EMPTY_FOR_NULL");
                if (o2 != null && o2 instanceof Boolean && ((Boolean)o2).booleanValue()) {
                    isEmptyForNull = true;
                }
                if (!isEmptyForNull) {
                    return true;
                }
            }
        }
        if (MODIFIER_ANY.equalsIgnoreCase(value)) {
            return true;
        }
        if (MODIFIER_NULL.equalsIgnoreCase(value)) {
            return obj == null;
        }
        if (obj == null) {
            return false;
        }
        return !(obj instanceof Collection ? ((Collection)obj).isEmpty() : obj.toString().length() <= 0);
    }

    @Override
    public boolean isTrue(String attributeName, Object obj, Object parentObj, SqlMetaType sqlMetaType, String inOutModifier, Map<String, String> values, Map<String, Object> features) {
        Boolean delegatedResult = this.callMethod(attributeName, parentObj, values);
        if (delegatedResult != null) {
            return delegatedResult;
        }
        if (inOutModifier == null) {
            if (obj != null) {
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                if (obj instanceof String) {
                    String str = ((String)obj).trim();
                    return str.length() > 0 && !str.equalsIgnoreCase("false");
                }
                if (obj instanceof Number) {
                    return ((Number)obj).longValue() > 0L;
                }
                if (obj.getClass().isEnum()) {
                    return true;
                }
                return true;
            }
            return false;
        }
        if (obj == null) {
            return inOutModifier.toLowerCase().equalsIgnoreCase(MODIFIER_NULL);
        }
        if (obj.getClass().isEnum()) {
            if (obj.toString().equals(inOutModifier)) {
                return true;
            }
            if (sqlMetaType == SqlProcessContext.getTypeFactory().getEnumStringType()) {
                return inOutModifier.equals(SqlUtils.getEnumToValue(obj));
            }
            if (sqlMetaType == SqlProcessContext.getTypeFactory().getEnumIntegerType()) {
                return inOutModifier.equals(SqlUtils.getEnumToValue(obj).toString());
            }
            Object enumVal = SqlUtils.getEnumToValue(obj);
            return enumVal.toString().equals(inOutModifier);
        }
        return obj.toString().equals(inOutModifier);
    }

    @Override
    public String sqlCount(StringBuilder sql) {
        String s = sql.toString().toUpperCase();
        int start = s.indexOf("ID");
        int end = s.indexOf("FROM");
        StringBuilder sb = sql;
        if (start < 0 || end < 0 || start > end) {
            return "select count(*) as vysledek from (" + sb.toString() + ") derived";
        }
        String s1 = sb.substring(0, start + 2);
        String s2 = sb.substring(end);
        start = s1.toUpperCase().indexOf("SELECT");
        if (start < 0) {
            return "select count(*) as vysledek from (" + sb.toString() + ") derived";
        }
        return s1.substring(0, start) + "select count(" + s1.substring(start + 6) + ") as vysledek " + s2;
    }

    @Override
    public SqlFromToPlugin.LimitType limitQuery(String queryString, StringBuilder queryResult, Integer firstResult, Integer maxResults, boolean ordered) {
        String limitPattern;
        SqlFromToPlugin.LimitType limitType = new SqlFromToPlugin.LimitType();
        if (maxResults == null || maxResults <= 0) {
            return null;
        }
        if (firstResult != null && firstResult > 0) {
            String limitPattern2;
            limitType.alsoFirst = true;
            String string = limitPattern2 = ordered ? SqlProcessContext.getFeature("LIMIT_FROM_TO_ORDERED") : SqlProcessContext.getFeature("LIMIT_FROM_TO");
            if (limitPattern2 == null && ordered) {
                limitPattern2 = SqlProcessContext.getFeature("LIMIT_FROM_TO");
            }
            limitType = this.limitQuery(limitPattern2, limitType, queryString, queryResult, firstResult, maxResults);
            return limitType;
        }
        String string = limitPattern = ordered ? SqlProcessContext.getFeature("LIMIT_TO_ORDERED") : SqlProcessContext.getFeature("LIMIT_TO");
        if (limitPattern == null && ordered) {
            limitPattern = SqlProcessContext.getFeature("LIMIT_TO");
        }
        limitType = this.limitQuery(limitPattern, limitType, queryString, queryResult, firstResult, maxResults);
        return limitType;
    }

    private Boolean callMethod(String attributeName, Object parentObj, Map<String, String> values) {
        if (attributeName == null || parentObj == null || values == null) {
            return null;
        }
        String methodName = values.get(MODIFIER_CALL);
        if (methodName == null) {
            return null;
        }
        Object result = null;
        try {
            result = MethodUtils.invokeMethod((Object)parentObj, (String)methodName, (Object)attributeName);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (result == null || !(result instanceof Boolean)) {
            return null;
        }
        return (Boolean)result;
    }

    private SqlFromToPlugin.LimitType limitQuery(String limitPattern, SqlFromToPlugin.LimitType limitType, String queryString, StringBuilder queryResult, Integer firstResult, Integer maxResults) {
        if (limitPattern == null) {
            return null;
        }
        int ix = limitPattern.indexOf("$S");
        if (ix >= 0) {
            limitType.afterSql = limitPattern.indexOf("$", ix + 1) > 0;
            queryResult.append(limitPattern.substring(0, ix));
            queryResult.append(queryString);
            queryResult.append(limitPattern.substring(ix + 2));
        } else {
            ix = limitPattern.indexOf("$s");
            if (ix >= 0) {
                limitType.afterSql = limitPattern.indexOf("$", ix + 1) > 0;
                int ix2 = queryString.toLowerCase().indexOf("select");
                if (ix2 < 0) {
                    return null;
                }
                queryResult.append(limitPattern.substring(0, ix));
                queryResult.append(queryString.substring(ix2 + 6));
                queryResult.append(limitPattern.substring(ix + 2));
            } else {
                return null;
            }
        }
        if (limitType.alsoFirst) {
            ix = queryResult.indexOf("$F");
            if (ix >= 0) {
                if (queryResult.indexOf("$m", ix) < 0 && queryResult.indexOf("$M", ix) < 0) {
                    limitType.maxBeforeFirst = true;
                }
                queryResult.replace(ix, ix + 2, "?");
            } else {
                ix = queryResult.indexOf("$f");
                if (ix >= 0) {
                    limitType.zeroBasedFirst = true;
                    if (queryResult.indexOf("$m", ix) < 0 && queryResult.indexOf("$M", ix) < 0) {
                        limitType.maxBeforeFirst = true;
                    }
                    queryResult.replace(ix, ix + 2, "?");
                } else {
                    return null;
                }
            }
        }
        if ((ix = queryResult.indexOf("$M")) >= 0) {
            queryResult.replace(ix, ix + 2, "?");
        } else {
            ix = queryResult.indexOf("$m");
            if (ix >= 0) {
                limitType.rowidBasedMax = true;
                queryResult.replace(ix, ix + 2, "?");
            } else {
                return null;
            }
        }
        return limitType;
    }

    @Override
    public String identitySelect(String identitySelectName, String tableName, String columnName) {
        String identitySelect;
        String string = identitySelect = "idsel".equals(identitySelectName) ? null : SqlProcessContext.getFeature(identitySelectName);
        if (identitySelect != null) {
            return identitySelect;
        }
        return SqlProcessContext.getFeature("IDSEL");
    }

    @Override
    public String sequenceSelect(String sequenceName) {
        String sequence = SqlProcessContext.getFeature(sequenceName);
        if (sequence != null) {
            return sequence;
        }
        String sequencePattern = SqlProcessContext.getFeature("SEQ");
        if (sequencePattern == null) {
            return null;
        }
        int ix = sequencePattern.indexOf("$n");
        if (ix < 0) {
            return sequencePattern;
        }
        if ("seq".equals(sequenceName)) {
            return sequencePattern.substring(0, ix) + "SQLPROC_SEQUENCE" + sequencePattern.substring(ix + 2);
        }
        return sequencePattern.substring(0, ix) + sequenceName + sequencePattern.substring(ix + 2);
    }
}

