/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlProcessContext {
    SqlMetaStatement.Type sqlStatementType;
    Object dynamicInputValues;
    Object staticInputValues;
    List<SqlOrder> order;
    boolean inSqlSetOrInsert;
    private static final ThreadLocal<Map<String, Object>> currentFeatures = new ThreadLocal();
    private static final ThreadLocal<SqlTypeFactory> currentTypeFactory = new ThreadLocal();
    private static final ThreadLocal<SqlPluginFactory> currentPluginFactory = new ThreadLocal();

    SqlProcessContext(SqlMetaStatement.Type sqlStatementType, Object dynamicInputValues, Object staticInputValues, List<SqlOrder> order, Map<String, Object> features, Map<String, Object> runtimeFeatures, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        this.sqlStatementType = sqlStatementType;
        this.dynamicInputValues = dynamicInputValues;
        this.staticInputValues = staticInputValues;
        this.order = order;
        SqlProcessContext.setFeatures(features, runtimeFeatures);
        SqlProcessContext.setTypeFactory(typeFactory);
        SqlProcessContext.setPluginFactory(pluginFactory);
    }

    public SqlMetaStatement.Type getSqlStatementType() {
        return this.sqlStatementType;
    }

    public static String getFeature(String name) {
        Object o = SqlProcessContext.getFeatures().get(name);
        return o != null && o instanceof String ? (String)o : null;
    }

    public static String[] getFeatures(String name) {
        Object o = SqlProcessContext.getFeatures().get(name);
        if (o != null && o instanceof String[]) {
            return (String[])o;
        }
        if (o != null && o instanceof String) {
            return new String[]{(String)o};
        }
        return null;
    }

    public static boolean isFeature(String name) {
        Object o = SqlProcessContext.getFeatures().get(name);
        return o != null && o instanceof Boolean && (Boolean)o != false;
    }

    public static Integer getFeatureAsInt(String name) {
        Object o = SqlProcessContext.getFeatures().get(name);
        if (o == null) {
            o = SqlProcessContext.getFeatures().get("DEFAULT_" + name);
        }
        if (o == null || !(o instanceof String)) {
            return null;
        }
        try {
            return Integer.parseInt((String)o);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    int getOrderIndex(int orderId) {
        if (this.order == null || this.order.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < this.order.size(); ++i) {
            SqlOrder sqlOrder = this.order.get(i);
            if (sqlOrder.getOrderId() != orderId) continue;
            return i;
        }
        return -1;
    }

    SqlOrder.Order getOrder(int orderIndex) {
        if (orderIndex < 0 || orderIndex >= this.order.size()) {
            return SqlOrder.Order.NONE;
        }
        return this.order.get(orderIndex).getOrderDirection();
    }

    static Map<String, Object> getFeatures() {
        Map<String, Object> features = currentFeatures.get();
        if (features == null) {
            throw new RuntimeException("There are no features attached to current thread " + Thread.currentThread().getName());
        }
        return features;
    }

    static void setFeatures(Map<String, Object> features, Map<String, Object> runtimeFeatures) {
        if (features == null) {
            throw new IllegalArgumentException("Argument features can not be null");
        }
        currentFeatures.set(features);
        if (runtimeFeatures == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : runtimeFeatures.entrySet()) {
            currentFeatures.get().put(entry.getKey(), entry.getValue());
            String oppositeName = SqlUtils.oppositeFeature(entry.getKey());
            if (oppositeName == null) continue;
            currentFeatures.get().remove(oppositeName);
        }
    }

    static void nullFeatures() {
        currentFeatures.set(null);
    }

    public static SqlTypeFactory getTypeFactory() {
        SqlTypeFactory typeFactory = currentTypeFactory.get();
        if (typeFactory == null) {
            throw new RuntimeException("There is no typeFactory attached to current thread " + Thread.currentThread().getName());
        }
        return typeFactory;
    }

    static void setTypeFactory(SqlTypeFactory typeFactory) {
        if (typeFactory == null) {
            throw new IllegalArgumentException("Argument typeFactory can not be null");
        }
        currentTypeFactory.set(typeFactory);
    }

    static void nullTypeFactory() {
        currentTypeFactory.set(null);
    }

    public static SqlPluginFactory getPluginFactory() {
        SqlPluginFactory pluginFactory = currentPluginFactory.get();
        if (pluginFactory == null) {
            throw new RuntimeException("There is no pluginFactory attached to current thread " + Thread.currentThread().getName());
        }
        return pluginFactory;
    }

    static void setPluginFactory(SqlPluginFactory pluginFactory) {
        if (pluginFactory == null) {
            throw new IllegalArgumentException("Argument pluginFactory can not be null");
        }
        currentPluginFactory.set(pluginFactory);
    }

    static void nullPluginFactory() {
        currentPluginFactory.set(null);
    }
}

