/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessor;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlComposedTypeFactory;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.validation.SqlValidator;
import org.sqlproc.engine.validation.SqlValidatorFactory;

public class SqlProcessorLoader
implements SqlEngineFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlTypeFactory composedTypeFactory;
    private SqlPluginFactory pluginFactory;
    private Map<String, SqlEngine> engines = new HashMap<String, SqlEngine>();
    private Map<String, SqlMetaStatement> sqls;
    private Map<String, SqlMetaStatement> cruds;
    private Map<String, SqlMetaStatement> calls;
    private Map<String, SqlMappingRule> outs;
    private Map<String, Object> features;
    private Map<String, Map<String, Object>> statementsFeatures;
    private Map<String, Set<String>> statementsFeaturesUnset;

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, (String)null, (SqlMonitorFactory)null, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, (SqlMonitorFactory)null, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, String ... onlyStatements) {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, (List<SqlInternalType>)null, onlyStatements);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, List<SqlInternalType> customTypes, String ... onlyStatements) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, null, customTypes, onlyStatements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, SqlValidatorFactory validatorFactory, List<SqlInternalType> customTypes, String ... onlyStatements) throws SqlEngineException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">> SqlProcessorLoader, sbStatements=" + sbStatements + ", typeFactory=" + typeFactory + ", pluginFactory=" + pluginFactory + ", monitorFactory=" + monitorFactory + ", validatorFactory=" + validatorFactory + ", filter=" + filter + ", customTypes=" + customTypes + ", onlyStatements=" + onlyStatements);
        }
        if (sbStatements == null) {
            throw new SqlEngineException("Missing SQL META queries/statements/output mappings");
        }
        if (typeFactory == null) {
            throw new SqlEngineException("Missing the META types factory");
        }
        this.composedTypeFactory = new SqlComposedTypeFactory(typeFactory, customTypes);
        this.pluginFactory = pluginFactory;
        try {
            SqlMonitor monitor;
            SqlMappingRule mapping;
            SqlMetaStatement stmt;
            HashSet<String> setSelectQueries = onlyStatements != null && onlyStatements.length > 0 ? new HashSet<String>(Arrays.asList(onlyStatements)) : null;
            filter = filter != null ? filter.toUpperCase() : null;
            Map<String, Object> defaultFeatures = SqlUtils.getDefaultFeatures(filter);
            StringBuilder errors = new StringBuilder();
            SqlProcessor processor = null;
            try {
                processor = SqlProcessor.getInstance(sbStatements, this.composedTypeFactory, defaultFeatures, setSelectQueries, filter);
            }
            catch (SqlEngineException see) {
                errors.append(see.getMessage());
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
            if (!processor.getWarnings().isEmpty()) {
                this.logger.warn("There're warnings in the process of statements parsing: " + processor.getWarnings());
            }
            this.sqls = processor.getMetaStatements(SqlProcessor.StatementType.QRY);
            this.cruds = processor.getMetaStatements(SqlProcessor.StatementType.CRUD);
            this.calls = processor.getMetaStatements(SqlProcessor.StatementType.CALL);
            this.outs = processor.getMappingRules(SqlProcessor.MappingType.OUT);
            this.features = processor.getFeatures();
            this.statementsFeatures = processor.getStatementsFeatures();
            this.statementsFeaturesUnset = processor.getStatementsFeaturesUnset();
            for (String name : this.outs.keySet()) {
                if (this.sqls.containsKey(name) || this.calls.containsKey(name) || this.cruds.containsKey(name)) continue;
                errors.append("For the OUT/FIELDS there's no QRY: ").append(name).append("\n");
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
            for (String name : this.sqls.keySet()) {
                stmt = this.sqls.get(name);
                mapping = null;
                if (!stmt.isHasOutputMapping() && !this.outs.containsKey(name)) {
                    errors.append("For the QRY there's no OUT: ").append(name).append("\n");
                } else {
                    mapping = this.outs.containsKey(name) ? this.outs.get(name) : new SqlMappingRule();
                }
                SqlMonitor sqlMonitor = monitor = monitorFactory != null ? monitorFactory.getSqlMonitor(name, this.features) : null;
                if (stmt == null) continue;
                this.engines.put(name, new SqlQueryEngine(name, stmt, mapping, monitor, this.features, this.composedTypeFactory, this.pluginFactory));
                this.loadStatementFeatures(name);
            }
            for (String name : this.cruds.keySet()) {
                SqlMonitor monitor2;
                SqlValidator validator = validatorFactory != null ? validatorFactory.getSqlValidator() : null;
                SqlMetaStatement stmt2 = this.cruds.get(name);
                SqlMappingRule mapping2 = null;
                if (this.outs.containsKey(name)) {
                    mapping2 = this.outs.get(name);
                }
                SqlMonitor sqlMonitor = monitor2 = monitorFactory != null ? monitorFactory.getSqlMonitor(name, this.features) : null;
                if (stmt2 == null) continue;
                this.engines.put(name, new SqlCrudEngine(name, stmt2, mapping2, monitor2, this.features, this.composedTypeFactory, this.pluginFactory));
                this.engines.get(name).setValidator(validator);
                this.loadStatementFeatures(name);
            }
            for (String name : this.calls.keySet()) {
                stmt = this.calls.get(name);
                mapping = null;
                mapping = this.outs.containsKey(name) ? this.outs.get(name) : new SqlMappingRule();
                SqlMonitor sqlMonitor = monitor = monitorFactory != null ? monitorFactory.getSqlMonitor(name, this.features) : null;
                if (stmt == null) continue;
                this.engines.put(name, new SqlProcedureEngine(name, stmt, mapping, monitor, this.features, this.composedTypeFactory, this.pluginFactory));
                this.loadStatementFeatures(name);
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< SqlProcessorLoader, engines=" + this.engines + ", sqls=" + this.sqls + ", cruds=" + this.cruds + ", fields=" + this.outs + ", features=" + this.features);
            }
        }
    }

    private void loadStatementFeatures(String name) {
        Set<String> statementFeaturesUnset;
        SqlEngine sqlEngine = this.engines.get(name);
        Map<String, Object> statementFeatures = this.statementsFeatures.get(name);
        if (statementFeatures != null) {
            for (Map.Entry<String, Object> entry : statementFeatures.entrySet()) {
                sqlEngine.setFeature(entry.getKey(), entry.getValue());
            }
        }
        if ((statementFeaturesUnset = this.statementsFeaturesUnset.get(name)) != null) {
            sqlEngine.unsetFeatures(statementFeaturesUnset);
        }
    }

    public Collection<String> getNames() {
        return this.engines.keySet();
    }

    @Override
    public SqlQueryEngine getQueryEngine(String name) {
        SqlEngine o = this.engines.get(name);
        if (o != null && o instanceof SqlQueryEngine) {
            return (SqlQueryEngine)o;
        }
        return null;
    }

    @Override
    public SqlCrudEngine getCrudEngine(String name) {
        SqlEngine o = this.engines.get(name);
        if (o != null && o instanceof SqlCrudEngine) {
            return (SqlCrudEngine)o;
        }
        return null;
    }

    @Override
    public SqlProcedureEngine getProcedureEngine(String name) {
        SqlEngine o = this.engines.get(name);
        if (o != null && o instanceof SqlProcedureEngine) {
            return (SqlProcedureEngine)o;
        }
        return null;
    }

    @Override
    public SqlQueryEngine getCheckedQueryEngine(String name) throws SqlEngineException {
        SqlQueryEngine queryEngine = this.getQueryEngine(name);
        if (queryEngine == null) {
            throw new SqlEngineException("Missing SqlQueryEngine " + name);
        }
        return queryEngine;
    }

    @Override
    public SqlCrudEngine getCheckedCrudEngine(String name) {
        SqlCrudEngine queryEngine = this.getCrudEngine(name);
        if (queryEngine == null) {
            throw new SqlEngineException("Missing SqlQueryEngine " + name);
        }
        return queryEngine;
    }

    @Override
    public SqlProcedureEngine getCheckedProcedureEngine(String name) {
        SqlProcedureEngine procedureEngine = this.getProcedureEngine(name);
        if (procedureEngine == null) {
            throw new SqlEngineException("Missing SqlQueryEngine " + name);
        }
        return procedureEngine;
    }
}

