/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.SqlMappingAttribute;
import org.sqlproc.engine.impl.SqlMappingIdentity;
import org.sqlproc.engine.impl.SqlMappingItem;
import org.sqlproc.engine.impl.SqlMappingRule;

public class SqlMappingResult {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, SqlMappingItem> mappings = new LinkedHashMap<String, SqlMappingItem>();
    Map<String, SqlMappingIdentity> identities = new LinkedHashMap<String, SqlMappingIdentity>();
    List<Integer> identitiesIndexes = new ArrayList<Integer>();
    Integer mainIdentityIndex;

    SqlMappingResult(SqlMappingRule mapping, Map<String, SqlMappingItem> outputMappings) {
        this.merge(mapping, outputMappings);
    }

    public Integer getMainIdentityIndex() {
        return this.mainIdentityIndex;
    }

    public List<Integer> getIdentitiesIndexes() {
        return this.identitiesIndexes;
    }

    void addMapping(SqlMappingItem item) {
        this.mappings.put(item.getDbName(), item);
        if (item.getAttributes().isEmpty()) {
            String name = item.getName();
            if (!this.identities.containsKey(name)) {
                SqlMappingIdentity ident = new SqlMappingIdentity(item);
                this.identities.put(name, ident);
            }
        } else {
            for (SqlMappingAttribute attr : item.getAttributes()) {
                if (this.identities.containsKey(attr.getFullName())) continue;
                SqlMappingIdentity ident = new SqlMappingIdentity(item, attr);
                this.identities.put(attr.getFullName(), ident);
            }
        }
    }

    void calculateIdentities() {
        SqlMappingIdentity ident;
        int identityIndex = 0;
        for (SqlMappingItem item : this.mappings.values()) {
            if (item.isIdentity()) {
                this.identitiesIndexes.add(identityIndex);
                if (item.getName().equals(item.getFullName())) {
                    SqlMappingIdentity ident2 = this.identities.get(item.getName());
                    ident2.addIdentityIndex(identityIndex, true);
                    ident2.idenityDistance = 0;
                    this.mainIdentityIndex = identityIndex;
                } else {
                    int size = item.getAttributes().size();
                    int distance = 0;
                    int i = size - 1;
                    while (i >= 0) {
                        SqlMappingAttribute attr = item.getAttributes().get(i);
                        SqlMappingIdentity ident3 = this.identities.get(attr.getFullName());
                        if (ident3.identityIndexes == null || ident3.idenityDistance >= distance) {
                            if (ident3.identityIndexes != null && ident3.idenityDistance == distance) {
                                ident3.addIdentityIndex(identityIndex, false);
                            } else {
                                ident3.addIdentityIndex(identityIndex, true);
                                ident3.idenityDistance = distance;
                            }
                        }
                        --i;
                        ++distance;
                    }
                }
            }
            ++identityIndex;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("===  calculateIdentities, identities=" + this.identities);
        }
        if (this.identitiesIndexes.isEmpty()) {
            return;
        }
        for (SqlMappingItem item : this.mappings.values()) {
            if (item.isIdentity()) continue;
            if (item.getAttributes().isEmpty()) {
                SqlMappingIdentity ident4 = this.identities.get(item.getName());
                ident4.addIdentityIndex(this.mainIdentityIndex, true);
                continue;
            }
            int size = item.getAttributes().size();
            block3: for (int i = size - 1; i >= 0; --i) {
                SqlMappingAttribute attr = item.getAttributes().get(i);
                ident = this.identities.get(attr.getFullName());
                if (ident.identityIndexes != null || i <= 0) continue;
                for (int j = i - 1; j >= 0; --j) {
                    SqlMappingAttribute attr2 = item.getAttributes().get(j);
                    SqlMappingIdentity ident2 = this.identities.get(attr2.getFullName());
                    if (ident2.identityIndexes == null) continue;
                    ident.identityIndexes = ident2.identityIndexes;
                    continue block3;
                }
            }
        }
        HashMap parentIdentityIndexes = new HashMap();
        ArrayList<Integer> mainIdentityIndexes = new ArrayList<Integer>();
        mainIdentityIndexes.add(this.mainIdentityIndex);
        for (Map.Entry<String, SqlMappingIdentity> entry : this.identities.entrySet()) {
            String fullName = entry.getKey();
            ident = entry.getValue();
            ident.allIdentityIndexes = new ArrayList<List<Integer>>();
            ident.allIdentityIndexes.add(mainIdentityIndexes);
            List<Integer> lastIdentityIndexes = null;
            int size = ident.item.getAttributes().size();
            for (int i = 0; i < size; ++i) {
                SqlMappingAttribute attr = ident.item.getAttributes().get(i);
                SqlMappingIdentity ident2 = this.identities.get(attr.getFullName());
                if (ident2.identityIndexes == lastIdentityIndexes) continue;
                boolean theSame = true;
                if (lastIdentityIndexes != null && ident2.identityIndexes.size() == lastIdentityIndexes.size()) {
                    for (int j = 0; j < lastIdentityIndexes.size(); ++j) {
                        if (ident2.identityIndexes.get(j).equals(lastIdentityIndexes.get(j))) continue;
                        theSame = false;
                        break;
                    }
                    if (theSame) continue;
                    lastIdentityIndexes = ident2.identityIndexes;
                    ident.allIdentityIndexes.add(lastIdentityIndexes);
                    continue;
                }
                lastIdentityIndexes = ident2.identityIndexes;
                ident.allIdentityIndexes.add(lastIdentityIndexes);
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("<<<  calculateIdentities, identities=" + this.identities + ", identitiesIndexes=" + this.identitiesIndexes + ", mainIdentityIndex=" + this.mainIdentityIndex);
        }
    }

    public void setQueryResultMapping(Class<?> resultClass, Map<String, Class<?>> moreResultClasses, SqlQuery query) throws SqlRuntimeException {
        for (SqlMappingItem item : this.mappings.values()) {
            item.setQueryResultMapping(resultClass, moreResultClasses, query);
        }
    }

    public void setQueryResultData(Object resultInstance, Object[] resultValues, Map<String, Object> ids, Map<String, Class<?>> moreResultClasses) throws SqlRuntimeException {
        int i = 0;
        HashMap<String, Object> idsProcessed = new HashMap<String, Object>();
        for (SqlMappingItem sqlMappingItem : this.mappings.values()) {
            sqlMappingItem.setQueryResultData(resultInstance, i, resultValues, ids, idsProcessed, this.identities, moreResultClasses);
            ++i;
        }
        if (ids != null) {
            for (Map.Entry entry : idsProcessed.entrySet()) {
                ids.put((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private void merge(SqlMappingRule mapping, Map<String, SqlMappingItem> outputMappings) {
        if (outputMappings == null || outputMappings.isEmpty()) {
            for (SqlMappingItem mappingItem : mapping.getMappings().values()) {
                this.addMapping(mappingItem);
            }
        } else {
            for (SqlMappingItem mappingItem : outputMappings.values()) {
                if (mapping != null && mapping.getMappings().containsKey(mappingItem.getDbName())) {
                    this.addMapping(mapping.getMappings().get(mappingItem.getDbName()).merge(mappingItem));
                    continue;
                }
                this.addMapping(mappingItem);
            }
        }
        this.calculateIdentities();
    }

    public Map<String, Object> getIds() {
        if (this.getMainIdentityIndex() == null || this.getIdentitiesIndexes() == null) {
            return null;
        }
        HashMap<String, Object> ids = new HashMap<String, Object>();
        return ids;
    }
}

