/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlProcessor;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlComposedTypeFactory;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.validation.SqlValidatorFactory;

public class SqlProcessorLoader
implements SqlEngineFactory {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlTypeFactory composedTypeFactory;
    private SqlPluginFactory pluginFactory;
    private SqlMonitorFactory monitorFactory;
    private SqlValidatorFactory validatorFactory;
    private Map<String, SqlEngine> engines = new HashMap<String, SqlEngine>();
    private Map<String, SqlEngine> dynamicEngines = new ConcurrentHashMap<String, SqlEngine>();
    private Map<String, SqlMetaStatement> sqls;
    private Map<String, SqlMetaStatement> cruds;
    private Map<String, SqlMetaStatement> calls;
    private Map<String, SqlMappingRule> outs;
    private Map<String, Object> features;
    private Map<String, Map<String, Object>> statementsFeatures;
    private Map<String, Set<String>> statementsFeaturesUnset;
    private boolean lazyInit;
    private Map<String, Map<String, SqlProcessResult>> commonProcessingCache = new ConcurrentHashMap<String, Map<String, SqlProcessResult>>();

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, (String)null, (SqlMonitorFactory)null, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, (SqlMonitorFactory)null, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, (List<SqlInternalType>)null, (String[])null);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, String ... onlyStatements) {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, (List<SqlInternalType>)null, onlyStatements);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, List<SqlInternalType> customTypes, String ... onlyStatements) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, null, customTypes, onlyStatements);
    }

    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, SqlValidatorFactory validatorFactory, List<SqlInternalType> customTypes, String ... onlyStatements) throws SqlEngineException {
        this(sbStatements, typeFactory, pluginFactory, filter, monitorFactory, validatorFactory, customTypes, false, onlyStatements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlProcessorLoader(StringBuilder sbStatements, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory, String filter, SqlMonitorFactory monitorFactory, SqlValidatorFactory validatorFactory, List<SqlInternalType> customTypes, boolean lazyInit, String ... onlyStatements) throws SqlEngineException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">> SqlProcessorLoader, sbStatements=" + sbStatements + ", typeFactory=" + typeFactory + ", pluginFactory=" + pluginFactory + ", monitorFactory=" + monitorFactory + ", validatorFactory=" + validatorFactory + ", filter=" + filter + ", customTypes=" + customTypes + ", lazyInit=" + lazyInit + ", onlyStatements=" + onlyStatements);
        }
        long start = System.currentTimeMillis();
        if (sbStatements == null) {
            throw new SqlEngineException("Missing SQL META queries/statements/output mappings");
        }
        if (typeFactory == null) {
            throw new SqlEngineException("Missing the META types factory");
        }
        this.composedTypeFactory = new SqlComposedTypeFactory(typeFactory, customTypes);
        this.pluginFactory = pluginFactory;
        this.validatorFactory = validatorFactory;
        this.monitorFactory = monitorFactory;
        this.lazyInit = lazyInit;
        try {
            HashSet<String> setSelectQueries = onlyStatements != null && onlyStatements.length > 0 ? new HashSet<String>(Arrays.asList(onlyStatements)) : null;
            filter = filter != null ? filter.toUpperCase() : null;
            Map<String, Object> defaultFeatures = SqlUtils.getDefaultFeatures(filter);
            StringBuilder errors = new StringBuilder();
            SqlProcessor processor = null;
            try {
                processor = lazyInit ? SqlProcessor.getLazyInstance(sbStatements, this.composedTypeFactory, defaultFeatures, setSelectQueries, filter) : SqlProcessor.getInstance(sbStatements, this.composedTypeFactory, defaultFeatures, setSelectQueries, filter);
            }
            catch (SqlEngineException see) {
                errors.append(see.getMessage());
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
            if (!processor.getWarnings().isEmpty()) {
                this.logger.warn("There're warnings in the process of statements parsing: " + processor.getWarnings());
            }
            this.sqls = processor.getMetaStatements(SqlProcessor.StatementType.QRY);
            this.cruds = processor.getMetaStatements(SqlProcessor.StatementType.CRUD);
            this.calls = processor.getMetaStatements(SqlProcessor.StatementType.CALL);
            this.outs = processor.getMappingRules(SqlProcessor.MappingType.OUT);
            this.features = processor.getFeatures();
            this.statementsFeatures = processor.getStatementsFeatures();
            this.statementsFeaturesUnset = processor.getStatementsFeaturesUnset();
            for (String name : this.outs.keySet()) {
                if (this.sqls.containsKey(name) || this.calls.containsKey(name) || this.cruds.containsKey(name)) continue;
                errors.append("For the OUT/FIELDS there's no QRY: ").append(name).append("\n");
            }
            if (errors.length() > 0) {
                throw new SqlEngineException(errors.toString());
            }
            if (!lazyInit) {
                for (String name : this.sqls.keySet()) {
                    try {
                        this.getQueryEngine(name);
                    }
                    catch (SqlEngineException ex) {
                        errors.append(ex.getMessage()).append("\n");
                    }
                }
                for (String name : this.cruds.keySet()) {
                    try {
                        this.getCrudEngine(name);
                    }
                    catch (SqlEngineException ex) {
                        errors.append(ex.getMessage()).append("\n");
                    }
                }
                for (String name : this.calls.keySet()) {
                    try {
                        this.getProcedureEngine(name);
                    }
                    catch (SqlEngineException ex) {
                        errors.append(ex.getMessage()).append("\n");
                    }
                }
                if (errors.length() > 0) {
                    throw new SqlEngineException(errors.toString());
                }
            }
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                this.logger.debug("== SqlProcessorLoader, lazyInit=" + lazyInit + ", duration in ms=" + (end - start));
                this.logger.debug("<< SqlProcessorLoader, engines=" + this.engines + ", sqls=" + this.sqls + ", cruds=" + this.cruds + ", fields=" + this.outs + ", features=" + this.features);
            }
        }
    }

    private void loadStatementFeatures(String name, SqlEngine sqlEngine) {
        Set<String> statementFeaturesUnset;
        Map<String, Object> statementFeatures = this.statementsFeatures.get(name);
        if (statementFeatures != null) {
            for (Map.Entry<String, Object> entry : statementFeatures.entrySet()) {
                sqlEngine.setFeature(entry.getKey(), entry.getValue());
            }
        }
        if ((statementFeaturesUnset = this.statementsFeaturesUnset.get(name)) != null) {
            sqlEngine.unsetFeatures(statementFeaturesUnset);
        }
    }

    @Override
    public Collection<String> getNames() {
        return this.engines.keySet();
    }

    @Override
    public Collection<String> getDynamicNames() {
        return this.dynamicEngines.keySet();
    }

    @Override
    public Map<String, SqlEngine> getEngines() {
        return this.engines;
    }

    @Override
    public Map<String, SqlEngine> getDynamicEngines() {
        return this.dynamicEngines;
    }

    private SqlEngine createEngine(String name, EngineType engineType, SqlMetaStatement stmt, String sqlStatement) {
        SqlMonitor monitor;
        SqlMetaStatement stmt2 = null;
        stmt2 = sqlStatement != null ? SqlMetaStatement.getInstance(name, sqlStatement, this.composedTypeFactory) : (this.lazyInit ? SqlMetaStatement.getInstance(name, stmt.getRaw(), this.composedTypeFactory) : stmt);
        if (engineType == EngineType.Query && !stmt2.isHasOutputMapping() && !this.outs.containsKey(name)) {
            throw new SqlEngineException("For the QRY there's no OUT: " + name);
        }
        SqlMappingRule mapping = null;
        if (this.outs.containsKey(name)) {
            mapping = this.outs.get(name);
            if (this.lazyInit) {
                mapping = SqlMappingRule.getInstance(name, mapping.getRaw(), this.composedTypeFactory);
            }
        } else {
            mapping = new SqlMappingRule();
        }
        SqlMonitor sqlMonitor = monitor = this.monitorFactory != null ? this.monitorFactory.getSqlMonitor(name, this.features) : null;
        SqlEngine sqlEngine = engineType == EngineType.Query ? new SqlQueryEngine(name, stmt2, mapping, monitor, this.features, this.composedTypeFactory, this.pluginFactory) : (engineType == EngineType.Crud ? new SqlCrudEngine(name, stmt2, mapping, monitor, this.features, this.composedTypeFactory, this.pluginFactory) : new SqlProcedureEngine(name, stmt2, mapping, monitor, this.features, this.composedTypeFactory, this.pluginFactory));
        sqlEngine.setValidator(this.validatorFactory != null ? this.validatorFactory.getSqlValidator() : null);
        this.loadStatementFeatures(name, sqlEngine);
        return sqlEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlEngine getStaticEngine(String name, EngineType engineType) {
        this.dynamicEngines.remove(name);
        SqlEngine sqlEngine = this.engines.get(name);
        Map<String, SqlMetaStatement> stmts = this.getStatements(engineType);
        if (sqlEngine == null && stmts.containsKey(name)) {
            SqlMetaStatement stmt;
            SqlMetaStatement sqlMetaStatement = stmt = stmts.get(name);
            synchronized (sqlMetaStatement) {
                sqlEngine = this.engines.get(name);
                if (sqlEngine == null) {
                    sqlEngine = this.createEngine(name, engineType, stmt, null);
                    this.engines.put(name, sqlEngine);
                }
                this.commonProcessingCache.put(name, new ConcurrentHashMap());
                sqlEngine.setProcessingCache(this.commonProcessingCache.get(name));
            }
        }
        return sqlEngine;
    }

    @Override
    public SqlQueryEngine getStaticQueryEngine(String name) {
        return (SqlQueryEngine)this.getStaticEngine(name, EngineType.Query);
    }

    @Override
    public SqlCrudEngine getStaticCrudEngine(String name) {
        return (SqlCrudEngine)this.getStaticEngine(name, EngineType.Crud);
    }

    @Override
    public SqlProcedureEngine getStaticProcedureEngine(String name) {
        return (SqlProcedureEngine)this.getStaticEngine(name, EngineType.Procedure);
    }

    private SqlEngine getEngine(String name, EngineType engineType) {
        SqlEngine sqlEngine = this.dynamicEngines.get(name);
        if (sqlEngine != null) {
            return sqlEngine;
        }
        return this.getStaticEngine(name, engineType);
    }

    @Override
    public SqlQueryEngine getQueryEngine(String name) {
        return (SqlQueryEngine)this.getEngine(name, EngineType.Query);
    }

    @Override
    public SqlCrudEngine getCrudEngine(String name) {
        return (SqlCrudEngine)this.getEngine(name, EngineType.Crud);
    }

    @Override
    public SqlProcedureEngine getProcedureEngine(String name) {
        return (SqlProcedureEngine)this.getEngine(name, EngineType.Procedure);
    }

    private SqlEngine getDynamicEngine(String name, EngineType engineType, String sqlStatement) {
        Map<String, SqlMetaStatement> stmts = this.getStatements(engineType);
        if (!stmts.containsKey(name)) {
            throw new SqlEngineException("Missing SQL Engine " + name);
        }
        if (sqlStatement == null) {
            throw new SqlEngineException("SQL statement for SQL Engine " + name + " is null");
        }
        SqlEngine sqlEngine = this.createEngine(name, engineType, null, sqlStatement);
        this.dynamicEngines.put(name, sqlEngine);
        this.commonProcessingCache.put(name, new ConcurrentHashMap());
        sqlEngine.setProcessingCache(this.commonProcessingCache.get(name));
        return sqlEngine;
    }

    @Override
    public SqlQueryEngine getDynamicQueryEngine(String name, String sqlStatement) {
        return (SqlQueryEngine)this.getDynamicEngine(name, EngineType.Query, sqlStatement);
    }

    @Override
    public SqlCrudEngine getDynamicCrudEngine(String name, String sqlStatement) {
        return (SqlCrudEngine)this.getDynamicEngine(name, EngineType.Crud, sqlStatement);
    }

    @Override
    public SqlProcedureEngine getDynamicProcedureEngine(String name, String sqlStatement) {
        return (SqlProcedureEngine)this.getDynamicEngine(name, EngineType.Procedure, sqlStatement);
    }

    private Map<String, SqlMetaStatement> getStatements(EngineType engineType) {
        if (engineType == EngineType.Query) {
            return this.sqls;
        }
        if (engineType == EngineType.Crud) {
            return this.cruds;
        }
        return this.calls;
    }

    @Override
    public SqlQueryEngine getCheckedQueryEngine(String name) throws SqlEngineException {
        SqlQueryEngine sqlEngine = this.getQueryEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getCheckedCrudEngine(String name) {
        SqlCrudEngine sqlEngine = this.getCrudEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getCheckedProcedureEngine(String name) {
        SqlProcedureEngine sqlEngine = this.getProcedureEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlQueryEngine getCheckedStaticQueryEngine(String name) throws SqlEngineException {
        SqlQueryEngine sqlEngine = this.getStaticQueryEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlCrudEngine getCheckedStaticCrudEngine(String name) {
        SqlCrudEngine sqlEngine = this.getStaticCrudEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    @Override
    public SqlProcedureEngine getCheckedStaticProcedureEngine(String name) {
        SqlProcedureEngine sqlEngine = this.getStaticProcedureEngine(name);
        this.check(name, sqlEngine);
        return sqlEngine;
    }

    private void check(String name, SqlEngine sqlEngine) {
        if (sqlEngine == null) {
            throw new SqlEngineException("Missing SqlEngine " + name);
        }
    }

    @Override
    public boolean isLazyInit() {
        return this.lazyInit;
    }

    static enum EngineType {
        Query,
        Crud,
        Procedure;

    }
}

