/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlExtendedMonitor;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlMappingResult;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlStandardControl;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.validation.SqlValidationException;

public class SqlCrudEngine
extends SqlEngine {
    public SqlCrudEngine(String name, String statement, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), null, null, null, typeFactory, pluginFactory);
    }

    public SqlCrudEngine(String name, String statement, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), null, monitor, features, typeFactory, pluginFactory);
    }

    public SqlCrudEngine(String name, SqlMetaStatement statement, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, null, null, null, typeFactory, pluginFactory);
    }

    public SqlCrudEngine(String name, SqlMetaStatement statement, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, null, monitor, features, typeFactory, pluginFactory);
    }

    public SqlCrudEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, mapping, monitor, features, typeFactory, pluginFactory);
    }

    public int insert(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.insert(session, dynamicInputValues, null);
    }

    public int insert(SqlSession session, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.insert(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public int insert(SqlSession session, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.insert(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException, SqlValidationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> insert, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlProcessResult processResult = SqlCrudEngine.this.process(SqlMetaStatement.Type.CREATE, dynamicInputValues, sqlControl);
                    processResult.validate(SqlCrudEngine.this.validator);
                    String sql = SqlCrudEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlCrudEngine.this.name, processResult.getSql().toString());
                    sql = SqlUtils.handleInsertSql(processResult.getIdentities(), sql);
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    if (SqlEngine.getMaxTimeout(sqlControl) > 0) {
                        query.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
                    }
                    processResult.setQueryParams(session, query);
                    if (SqlCrudEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlCrudEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return SqlCrudEngine.this.insert(query, processResult);
                            }
                        }, Integer.class);
                    }
                    return SqlCrudEngine.this.insert(query, processResult);
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< insert, result=" + count);
            }
        }
    }

    private Integer insert(SqlQuery query, SqlProcessResult processResult) {
        Integer count = query.update(processResult.getRuntimeContext());
        processResult.postProcess();
        return count;
    }

    public <E> E get(SqlSession session, Class<E> resultClass, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.get(session, resultClass, dynamicInputValues, (SqlControl)null);
    }

    public <E> E get(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.get(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public <E> E get(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, Map<String, Class<?>> moreResultClasses) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.get(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setMoreResultClasses(moreResultClasses));
    }

    public <E> E get(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.get(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    public <E> E get(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, int maxTimeout, Map<String, Class<?>> moreResultClasses) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.get(session, resultClass, dynamicInputValues, (SqlControl)new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout).setMoreResultClasses(moreResultClasses));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E get(final SqlSession session, final Class<E> resultClass, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> get, session=" + session + ", resultClass=" + resultClass + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        E result = null;
        try {
            E e = result = (E)this.monitor.run(new SqlMonitor.Runner(){

                public E run() {
                    SqlProcessResult processResult = SqlCrudEngine.this.process(SqlMetaStatement.Type.RETRIEVE, dynamicInputValues, sqlControl);
                    String sql = SqlCrudEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlCrudEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    if (SqlEngine.getMaxTimeout(sqlControl) > 0) {
                        query.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
                    }
                    if (SqlEngine.getFetchSize(sqlControl) > 0) {
                        query.setFetchSize(SqlEngine.getFetchSize(sqlControl));
                    }
                    processResult.setQueryParams(session, query);
                    final SqlMappingResult mappingResult = SqlMappingRule.merge(SqlCrudEngine.this.mapping, processResult);
                    mappingResult.setQueryResultMapping(resultClass, SqlEngine.getMoreResultClasses(sqlControl), query);
                    if (SqlCrudEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlCrudEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            public E run() {
                                return SqlCrudEngine.this.get(query, mappingResult, resultClass, sqlControl);
                            }
                        }, resultClass);
                    }
                    return SqlCrudEngine.this.get(query, mappingResult, resultClass, sqlControl);
                }
            }, resultClass);
            return e;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< get, result=" + result);
            }
        }
    }

    private <E> E get(SqlQuery query, SqlMappingResult mappingResult, Class<E> resultClass, SqlControl sqlControl) {
        List list = query.list(mappingResult.getRuntimeContext());
        Object resultInstance = null;
        Object[] resultValue = null;
        Map<String, Object> ids = mappingResult.getIds();
        for (Object resultRow : list) {
            String idsKey;
            Object[] objectArray;
            if (resultRow instanceof Object[]) {
                objectArray = (Object[])resultRow;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = resultRow;
            }
            resultValue = objectArray;
            boolean changedIdentity = true;
            if (ids != null && ids.containsKey(idsKey = SqlUtils.getIdsKey(resultValue, mappingResult.getMainIdentityIndex()))) {
                changedIdentity = false;
            }
            if (changedIdentity) {
                if (resultInstance != null) {
                    throw new SqlProcessorException("There's no unique result");
                }
                resultInstance = BeanUtils.getInstance(resultClass);
                if (resultInstance == null) {
                    throw new SqlRuntimeException("There's problem to instantiate " + resultClass);
                }
            }
            mappingResult.setQueryResultData(resultInstance, resultValue, ids, SqlCrudEngine.getMoreResultClasses(sqlControl));
            if (!changedIdentity || ids == null) continue;
            idsKey = SqlUtils.getIdsKey(resultValue, mappingResult.getMainIdentityIndex());
            ids.put(idsKey, resultInstance);
        }
        return (E)resultInstance;
    }

    public int update(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.update(session, dynamicInputValues, null);
    }

    public int update(SqlSession session, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.update(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public int update(SqlSession session, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.update(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException, SqlValidationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> update, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlProcessResult processResult = SqlCrudEngine.this.process(SqlMetaStatement.Type.UPDATE, dynamicInputValues, sqlControl);
                    processResult.validate(SqlCrudEngine.this.validator);
                    String sql = SqlCrudEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlCrudEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    if (SqlEngine.getMaxTimeout(sqlControl) > 0) {
                        query.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
                    }
                    processResult.setQueryParams(session, query);
                    if (SqlCrudEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlCrudEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return SqlCrudEngine.this.update(query, processResult);
                            }
                        }, Integer.class);
                    }
                    return SqlCrudEngine.this.update(query, processResult);
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< update, result=" + count);
            }
        }
    }

    private Integer update(SqlQuery query, SqlProcessResult processResult) {
        return query.update(processResult.getRuntimeContext());
    }

    public int delete(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.delete(session, dynamicInputValues, null);
    }

    public int delete(SqlSession session, Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.delete(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues));
    }

    public int delete(SqlSession session, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.delete(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> delete, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlProcessResult processResult = SqlCrudEngine.this.process(SqlMetaStatement.Type.DELETE, dynamicInputValues, sqlControl);
                    String sql = SqlCrudEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlCrudEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    if (SqlEngine.getMaxTimeout(sqlControl) > 0) {
                        query.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
                    }
                    processResult.setQueryParams(session, query);
                    if (SqlCrudEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlCrudEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return SqlCrudEngine.this.delete(query, processResult);
                            }
                        }, Integer.class);
                    }
                    return SqlCrudEngine.this.delete(query, processResult);
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< delete, result=" + count);
            }
        }
    }

    private Integer delete(SqlQuery query, SqlProcessResult processResult) {
        return query.update(processResult.getRuntimeContext());
    }

    public String getInsertSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.CREATE);
    }

    public String getGetSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.RETRIEVE);
    }

    public String getUpdateSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.UPDATE);
    }

    public String getDeleteSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.DELETE);
    }

    public String getSql(Object dynamicInputValues, Object staticInputValues, SqlMetaStatement.Type statementType) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.getSql(dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues), statementType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(final Object dynamicInputValues, final SqlControl sqlControl, final SqlMetaStatement.Type statementType) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> getSql, dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        String sql = null;
        try {
            String string = sql = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public String run() {
                    SqlProcessResult processResult = SqlCrudEngine.this.process(statementType, dynamicInputValues, sqlControl);
                    String sql = SqlCrudEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlCrudEngine.this.name, processResult.getSql().toString());
                    return sql;
                }
            }, String.class);
            return string;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< getSql, sql=" + sql);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public SqlMonitor getMonitor() {
        return this.monitor;
    }
}

