/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.IdentitySetter;
import org.sqlproc.engine.type.OutValueSetter;

class SqlInputValue {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlProcessContext ctx;
    private Type valueType;
    private Code caseConversion;
    private Mode inOutMode;
    private Object inputValue;
    private String inputName;
    private String fullInputName;
    private Object parentInputValue;
    Class<?> inputValueType;
    private String likeChar;
    private int minLikeLength;
    private boolean partialLike;
    private SqlType type;
    private String sequence;
    private String identitySelect;
    private Object identity;
    private Object outValue;
    private Map<String, String> replaceChars;
    private String dbIdentityName;

    SqlInputValue(SqlProcessContext ctx, Type valueType, Object inputValue, Object parentInputValue, Class<?> inputValueType, Code caseConversion, Mode inOutMode, SqlType type, String inputName, String fullInputName) {
        this.ctx = ctx;
        this.valueType = valueType;
        this.inputValue = inputValue;
        this.parentInputValue = parentInputValue;
        this.inputValueType = inputValueType;
        this.caseConversion = caseConversion;
        this.inOutMode = inOutMode;
        this.type = type;
        this.inputName = inputName;
        this.fullInputName = fullInputName;
    }

    SqlInputValue(SqlProcessContext ctx, Type valueType, Object inputValue, Object parentInputValue, Class<?> inputValueType, String sequenceOrIdentitySelect, SqlType type, String dbIdentityName) {
        this.ctx = ctx;
        this.valueType = valueType;
        this.inputValue = inputValue;
        this.parentInputValue = parentInputValue;
        this.inputValueType = inputValueType;
        if (this.valueType == Type.SEQUENCE_BASED) {
            this.sequence = sequenceOrIdentitySelect;
        } else {
            this.identitySelect = sequenceOrIdentitySelect;
        }
        this.type = type;
        this.dbIdentityName = dbIdentityName;
    }

    SqlInputValue(SqlProcessContext ctx, String name, SqlInputValue sqlInputValue, Object dynamicInputValues) {
        this.ctx = ctx;
        this.valueType = sqlInputValue.valueType;
        this.caseConversion = sqlInputValue.caseConversion;
        this.inOutMode = sqlInputValue.inOutMode;
        this.parentInputValue = dynamicInputValues;
        if (sqlInputValue.fullInputName != null || sqlInputValue.inputName != null) {
            String[] stringArray;
            if (sqlInputValue.fullInputName != null) {
                stringArray = sqlInputValue.fullInputName.split(",");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = sqlInputValue.inputName;
            }
            String[] ss = stringArray;
            for (int i = 0; i < ss.length; ++i) {
                this.inputValue = ctx.getAttribute(i == 0 ? dynamicInputValues : this.inputValue, ss[i]);
                if (i >= ss.length - 1) continue;
                this.parentInputValue = this.inputValue;
            }
        }
        this.inputName = sqlInputValue.inputName;
        this.fullInputName = sqlInputValue.fullInputName;
        this.inputValueType = sqlInputValue.inputValueType;
        this.likeChar = sqlInputValue.likeChar;
        this.minLikeLength = sqlInputValue.minLikeLength;
        this.partialLike = sqlInputValue.partialLike;
        this.type = sqlInputValue.type;
        this.sequence = sqlInputValue.sequence;
        this.identitySelect = sqlInputValue.identitySelect;
        this.identity = sqlInputValue.identity;
        this.outValue = sqlInputValue.outValue;
        this.replaceChars = sqlInputValue.replaceChars;
        this.dbIdentityName = sqlInputValue.dbIdentityName;
    }

    void setQueryParam(SqlSession session, SqlQuery query, String paramName) throws SqlRuntimeException {
        if (this.sequence != null) {
            SqlQuery seqQuery = session.createSqlQuery(this.sequence);
            this.ctx.getTypeFactory().getDefaultType().addScalar(seqQuery, "1", this.inputValueType);
            this.identity = seqQuery.unique(this.ctx);
            this.type.setParameter(this.ctx, query, paramName, this.identity, this.inputValueType);
        } else if (this.identitySelect != null) {
            this.ctx.getTypeFactory().getIdentityType().setParameter(this.ctx, query, paramName, new IdentitySetter(){

                @Override
                public void setIdentity(Object identity) {
                    if (identity != null && identity instanceof BigDecimal) {
                        SqlInputValue.this.identity = SqlUtils.convertBigDecimal(SqlInputValue.this.inputValueType, identity);
                    } else {
                        SqlInputValue.this.identity = SqlUtils.convertBigInteger(SqlInputValue.this.inputValueType, identity);
                    }
                }

                @Override
                public String getIdentitySelect() {
                    return SqlInputValue.this.identitySelect;
                }
            }, this.inputValueType, this.ctx.isFeature("IGNORE_INPROPER_IN"));
        } else if (this.inOutMode == Mode.IN || this.inOutMode == Mode.INOUT) {
            Object o = this.inputValue;
            if (this.inputValue instanceof String) {
                if (this.caseConversion == Code.NONE) {
                    o = this.processReplaceChars(this.processLike(this.inputValue));
                } else if (this.caseConversion == Code.LOWER) {
                    o = this.inputValue != null ? this.processReplaceChars(this.processLike(this.inputValue)).toLowerCase() : (String)null;
                } else if (this.caseConversion == Code.UPPER) {
                    o = this.inputValue != null ? this.processReplaceChars(this.processLike(this.inputValue)).toUpperCase() : (String)null;
                }
            }
            this.type.setParameter(this.ctx, query, paramName, o, this.inputValueType);
            if (this.inOutMode == Mode.INOUT) {
                this.type.setParameter(this.ctx, query, paramName, new OutValueSetter(){

                    @Override
                    public void setOutValue(Object outValue) {
                        SqlInputValue.this.outValue = outValue;
                    }
                }, this.inputValueType);
            }
        } else if (this.inOutMode == Mode.OUT) {
            this.type.setParameter(this.ctx, query, paramName, new OutValueSetter(){

                @Override
                public void setOutValue(Object outValue) {
                    SqlInputValue.this.outValue = outValue;
                }
            }, this.inputValueType);
        }
    }

    void setIdentityResult(String paramName) throws SqlRuntimeException {
        this.type.setResult(this.ctx, this.parentInputValue, paramName, this.identity);
    }

    void setOutValueResult(String paramName) throws SqlRuntimeException {
        if (Character.isDigit(paramName.charAt(0))) {
            return;
        }
        this.type.setResult(this.ctx, this.parentInputValue, paramName, this.outValue);
    }

    void setLike(String likeChar, Integer minLikeLength, boolean partialLike) {
        this.likeChar = likeChar;
        this.minLikeLength = minLikeLength == null ? 1 : minLikeLength;
        this.partialLike = partialLike;
    }

    void setReplaceChars(Map<String, String> replaceChars) {
        this.replaceChars = replaceChars;
    }

    private String processLike(Object val) {
        String param = (String)val;
        if (this.partialLike) {
            if (this.likeChar != null && param != null) {
                param = param.trim();
                int length = param.length();
                boolean endsWith = param.endsWith(this.likeChar);
                if (endsWith) {
                    return param;
                }
                if (length >= this.minLikeLength) {
                    return param + this.likeChar;
                }
                return param;
            }
        } else if (this.likeChar != null && param != null) {
            param = param.trim();
            int length = param.length();
            boolean startsWith = param.startsWith(this.likeChar);
            boolean endsWith = param.endsWith(this.likeChar);
            if (startsWith && endsWith) {
                return param;
            }
            if (startsWith) {
                if (length >= this.minLikeLength + 1) {
                    return param + this.likeChar;
                }
                return param;
            }
            if (endsWith) {
                if (length >= this.minLikeLength + 1) {
                    return this.likeChar + param;
                }
                return param;
            }
            if (length >= this.minLikeLength) {
                return this.likeChar + param + this.likeChar;
            }
            return param;
        }
        return param;
    }

    private String processReplaceChars(Object val) {
        String param = (String)val;
        if (this.replaceChars == null || this.replaceChars.isEmpty()) {
            return param;
        }
        for (Map.Entry<String, String> entry : this.replaceChars.entrySet()) {
            param = param.replace(entry.getKey(), entry.getValue());
        }
        return param;
    }

    Object getInputValue() {
        return this.inputValue;
    }

    String getInputName() {
        return this.inputName;
    }

    Object getParentInputValue() {
        return this.parentInputValue;
    }

    public Type getValueType() {
        return this.valueType;
    }

    public String getDbIdentityName() {
        return this.dbIdentityName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SqlInputValue[");
        sb.append(" valueType=").append((Object)this.valueType);
        sb.append(", caseConversion=").append((Object)this.caseConversion);
        sb.append(", inOutMode=").append((Object)this.inOutMode);
        sb.append(", inputValue=").append(this.inputValue);
        sb.append(", inputName=").append(this.inputName);
        sb.append(", fullInputName=").append(this.fullInputName);
        sb.append(", parentInputValue=").append(this.parentInputValue);
        sb.append(", inputValueType=").append(this.inputValueType);
        sb.append(", likeChar=").append(this.likeChar);
        sb.append(", minLikeLength=").append(this.minLikeLength);
        sb.append(", partialLike=").append(this.partialLike);
        sb.append(", type=").append(this.type);
        sb.append(", sequence=").append(this.sequence);
        sb.append(", identitySelect=").append(this.identitySelect);
        sb.append(", identity=").append(this.identity);
        sb.append(", outValue=").append(this.outValue);
        sb.append(", replaceChars=").append(this.replaceChars != null ? this.replaceChars : null);
        sb.append(", dbIdentityName=").append(this.dbIdentityName);
        return sb.append("]").toString();
    }

    static enum Mode {
        IN,
        OUT,
        INOUT;

    }

    static enum Code {
        NONE,
        UPPER,
        LOWER;

    }

    static enum Type {
        PROVIDED,
        SEQUENCE_BASED,
        IDENTITY_SELECT;

    }
}

