/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jmx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBException;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.config.SqlEngineConfiguration;

public class SqlSimpleFactoryMXBean {
    private SqlEngineFactory sqlEngineFactory;

    public int initQueryEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            for (String name : this.sqlEngineFactory.getNames()) {
                try {
                    this.sqlEngineFactory.getCheckedQueryEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.sqlEngineFactory.getCheckedQueryEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nInitialized engines: ").append(count).toString());
    }

    public int initCrudEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            for (String name : this.sqlEngineFactory.getNames()) {
                try {
                    this.sqlEngineFactory.getCheckedCrudEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.sqlEngineFactory.getCheckedCrudEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nInitialized engines: ").append(count).toString());
    }

    public int initProcedureEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        if ("*".equals(names)) {
            for (String name : this.sqlEngineFactory.getNames()) {
                try {
                    this.sqlEngineFactory.getCheckedProcedureEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        } else {
            for (String name : names.split(",")) {
                try {
                    this.sqlEngineFactory.getCheckedProcedureEngine(name);
                    ++count;
                }
                catch (SqlEngineException ex) {
                    errors.append(ex.getMessage()).append("\n");
                }
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nInitialized engines: ").append(count).toString());
    }

    public int resetQueryEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticQueryEngine(name);
                ++count;
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engines: ").append(count).toString());
    }

    public int resetCrudEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticCrudEngine(name);
                ++count;
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engines: ").append(count).toString());
    }

    public int resetProcedureEngines(String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        for (String name : names.split(",")) {
            try {
                this.sqlEngineFactory.getCheckedStaticProcedureEngine(name);
                ++count;
            }
            catch (SqlEngineException ex) {
                errors.append(ex.getMessage()).append("\n");
            }
        }
        if (errors.length() == 0) {
            this.storeConfiguration();
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engines: ").append(count).toString());
    }

    public void newQueryEngine(String name, String sqlStatement) throws SqlEngineException {
        try {
            this.sqlEngineFactory.getDynamicQueryEngine(name, sqlStatement);
            this.storeConfiguration();
        }
        catch (SqlEngineException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void newCrudEngine(String name, String sqlStatement) {
        try {
            this.sqlEngineFactory.getDynamicCrudEngine(name, sqlStatement);
            this.storeConfiguration();
        }
        catch (SqlEngineException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void newProcedureEngine(String name, String sqlStatement) {
        try {
            this.sqlEngineFactory.getDynamicProcedureEngine(name, sqlStatement);
            this.storeConfiguration();
        }
        catch (SqlEngineException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    public List<String> getNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.sqlEngineFactory.getNames());
        Collections.sort(list);
        return list;
    }

    public List<String> getDynamicNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.sqlEngineFactory.getDynamicNames());
        Collections.sort(list);
        return list;
    }

    public List<String> getQueryEngineProcessingCache(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlQueryEngine engine = this.sqlEngineFactory.getCheckedQueryEngine(name);
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(engine.getProcessingCache().keySet());
            Collections.sort(list);
            return list;
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            throw new RuntimeException(errors.toString());
        }
    }

    public List<String> getCrudEngineProcessingCache(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlCrudEngine engine = this.sqlEngineFactory.getCheckedCrudEngine(name);
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(engine.getProcessingCache().keySet());
            Collections.sort(list);
            return list;
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            throw new RuntimeException(errors.toString());
        }
    }

    public List<String> getProcedureEngineProcessingCache(String name) {
        StringBuilder errors = new StringBuilder();
        try {
            SqlProcedureEngine engine = this.sqlEngineFactory.getCheckedProcedureEngine(name);
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(engine.getProcessingCache().keySet());
            Collections.sort(list);
            return list;
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
            throw new RuntimeException(errors.toString());
        }
    }

    public int resetQueryEngineProcessingCache(String name, String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        try {
            SqlQueryEngine engine = this.sqlEngineFactory.getCheckedQueryEngine(name);
            for (String name0 : names.split(",")) {
                engine.getProcessingCache().remove(name0);
                ++count;
            }
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
        }
        if (errors.length() == 0) {
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engine cache: ").append(count).toString());
    }

    public int resetCrudEngineProcessingCache(String name, String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        try {
            SqlCrudEngine engine = this.sqlEngineFactory.getCheckedCrudEngine(name);
            for (String name0 : names.split(",")) {
                engine.getProcessingCache().remove(name0);
                ++count;
            }
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
        }
        if (errors.length() == 0) {
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engine cache: ").append(count).toString());
    }

    public int resetProcedureEngineProcessingCache(String name, String names) {
        int count = 0;
        StringBuilder errors = new StringBuilder();
        try {
            SqlProcedureEngine engine = this.sqlEngineFactory.getCheckedProcedureEngine(name);
            for (String name0 : names.split(",")) {
                engine.getProcessingCache().remove(name0);
                ++count;
            }
        }
        catch (SqlEngineException ex) {
            errors.append(ex.getMessage()).append("\n");
        }
        if (errors.length() == 0) {
            return count;
        }
        throw new RuntimeException(errors.append("/nReset engine cache: ").append(count).toString());
    }

    private SqlEngineConfiguration getConfiguration() {
        SqlEngineConfiguration configuration = this.sqlEngineFactory.getConfiguration();
        if (configuration == null) {
            throw new IllegalArgumentException("The dynamic configation is null");
        }
        return configuration;
    }

    public boolean isLazyInit() {
        return this.sqlEngineFactory.isLazyInit();
    }

    public void setLazyInit(boolean lazyInit) {
        this.getConfiguration().setLazyInit(lazyInit);
        this.storeConfiguration();
    }

    public Boolean getAsyncInit() {
        return this.getConfiguration().getAsyncInit();
    }

    public void setAsyncInit(Boolean asyncInit) {
        this.getConfiguration().setAsyncInit(asyncInit);
        this.storeConfiguration();
    }

    public Integer getInitTreshold() {
        return this.getConfiguration().getInitTreshold();
    }

    public void setInitTreshold(Integer initTreshold) {
        this.getConfiguration().setInitTreshold(initTreshold);
        this.storeConfiguration();
    }

    public Boolean getInitInUsageOrder() {
        return this.getConfiguration().getInitInUsageOrder();
    }

    public void setInitInUsageOrder(Boolean initInUsageOrder) {
        this.getConfiguration().setInitInUsageOrder(initInUsageOrder);
        this.storeConfiguration();
    }

    public void loadConfiguration() {
        try {
            this.getConfiguration().load();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void storeConfiguration() {
        this.getConfiguration().store();
    }

    public void clearConfiguration() {
        this.getConfiguration().clear();
    }

    public void clearConfigurationUsage() {
        this.getConfiguration().clearUsage();
    }

    private List<String> toList(List<SqlEngineConfiguration.NameValue> namevals) {
        ArrayList<String> list = new ArrayList<String>();
        for (SqlEngineConfiguration.NameValue nameval : namevals) {
            list.add(nameval.name);
        }
        return list;
    }

    public List<String> getQueryEnginesToInit() {
        return this.toList(this.getConfiguration().getQueryEnginesToInit(this.getConfiguration().getInitTreshold()));
    }

    public List<String> getCrudEnginesToInit() {
        return this.toList(this.getConfiguration().getCrudEnginesToInit(this.getConfiguration().getInitTreshold()));
    }

    public List<String> getProcedureEnginesToInit() {
        return this.toList(this.getConfiguration().getProcedureEnginesToInit(this.getConfiguration().getInitTreshold()));
    }

    public int getQueryEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getQueryEngines().get(name);
        if (usage == null) {
            return 0;
        }
        return usage.get();
    }

    public int getCrudEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getCrudEngines().get(name);
        if (usage == null) {
            return 0;
        }
        return usage.get();
    }

    public int getProcedureEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getProcedureEngines().get(name);
        if (usage == null) {
            return 0;
        }
        return usage.get();
    }

    public int resetQueryEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getQueryEngines().get(name);
        if (usage == null) {
            return 0;
        }
        usage.set(0);
        this.storeConfiguration();
        return usage.get();
    }

    public int resetCrudEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getCrudEngines().get(name);
        if (usage == null) {
            return 0;
        }
        usage.set(0);
        this.storeConfiguration();
        return usage.get();
    }

    public int resetProcedureEngineUsage(String name) {
        AtomicInteger usage = this.getConfiguration().getProcedureEngines().get(name);
        if (usage == null) {
            return 0;
        }
        usage.set(0);
        this.storeConfiguration();
        return usage.get();
    }

    public void setSqlEngineFactory(SqlEngineFactory sqlEngineFactory) {
        this.sqlEngineFactory = sqlEngineFactory;
    }
}

