/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlExtendedMonitor;
import org.sqlproc.engine.SqlMonitor;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.SqlSession;
import org.sqlproc.engine.impl.SqlMappingResult;
import org.sqlproc.engine.impl.SqlMappingRule;
import org.sqlproc.engine.impl.SqlMetaStatement;
import org.sqlproc.engine.impl.SqlProcessResult;
import org.sqlproc.engine.impl.SqlStandardControl;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlProcedureEngine
extends SqlEngine {
    public SqlProcedureEngine(String name, String statement, String mapping, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), mapping != null ? SqlMappingRule.getInstance(name, mapping, typeFactory) : null, null, null, typeFactory, pluginFactory);
    }

    public SqlProcedureEngine(String name, String statement, String mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) throws SqlEngineException {
        super(name, SqlMetaStatement.getInstance(name, statement, typeFactory), mapping != null ? SqlMappingRule.getInstance(name, mapping, typeFactory) : null, monitor, features, typeFactory, pluginFactory);
    }

    public SqlProcedureEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, mapping, null, null, typeFactory, pluginFactory);
    }

    public SqlProcedureEngine(String name, SqlMetaStatement statement, SqlMappingRule mapping, SqlMonitor monitor, Map<String, Object> features, SqlTypeFactory typeFactory, SqlPluginFactory pluginFactory) {
        super(name, statement, mapping, monitor, features, typeFactory, pluginFactory);
    }

    public <E> List<E> callQuery(SqlSession session, Class<E> resultClass, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.callQuery(session, resultClass, dynamicInputValues, null);
    }

    public <E> List<E> callQuery(SqlSession session, Class<E> resultClass, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.callQuery(session, resultClass, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> List<E> callQuery(final SqlSession session, final Class<E> resultClass, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> callQuery, session=" + session + ", resultClass=" + resultClass + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        List<E> result = null;
        try {
            List<E> list = result = this.monitor.runList(new SqlMonitor.Runner(){

                @Override
                public List<E> run() {
                    SqlProcessResult processResult = SqlProcedureEngine.this.process(SqlMetaStatement.Type.CALL, dynamicInputValues, sqlControl);
                    String sql = SqlProcedureEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlProcedureEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    if (SqlEngine.getMaxTimeout(sqlControl) != null) {
                        query.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
                    }
                    if (SqlEngine.getFetchSize(sqlControl) != null) {
                        query.setFetchSize(SqlEngine.getFetchSize(sqlControl));
                    }
                    processResult.setQueryParams(session, query);
                    final SqlMappingResult mappingResult = SqlMappingRule.merge(SqlProcedureEngine.this.mapping, processResult);
                    mappingResult.setQueryResultMapping(resultClass, null, query);
                    if (SqlProcedureEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlProcedureEngine.this.monitor;
                        return monitorExt.runListSql(new SqlMonitor.Runner(){

                            @Override
                            public List<E> run() {
                                return SqlProcedureEngine.this.callQuery(query, mappingResult, resultClass);
                            }
                        }, resultClass);
                    }
                    return SqlProcedureEngine.this.callQuery(query, mappingResult, resultClass);
                }
            }, resultClass);
            return list;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< callQuery, result=" + result);
            }
        }
    }

    private <E> List<E> callQuery(SqlQuery query, SqlMappingResult mappingResult, Class<E> resultClass) {
        List list = query.callList(mappingResult.getRuntimeContext());
        if (SqlUtils.isPrimitiveWrapper(resultClass)) {
            return list;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Object resultInstance = null;
        Object[] resultValue = null;
        for (Object resultRow : list) {
            Object[] objectArray;
            if (resultRow instanceof Object[]) {
                objectArray = (Object[])resultRow;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = resultRow;
            }
            resultValue = objectArray;
            resultInstance = mappingResult.getRuntimeContext().getInstance(resultClass);
            if (resultInstance == null) {
                throw new SqlRuntimeException("There's problem to instantiate " + resultClass);
            }
            mappingResult.setQueryResultData(resultInstance, resultValue, null, null);
            result.add(resultInstance);
        }
        return result;
    }

    public int callUpdate(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.callUpdate(session, dynamicInputValues, null);
    }

    public int callUpdate(SqlSession session, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.callUpdate(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int callUpdate(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> callUpdate, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        Integer count = null;
        try {
            count = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Integer run() {
                    final SqlProcessResult processResult = SqlProcedureEngine.this.process(SqlMetaStatement.Type.CALL, dynamicInputValues, sqlControl);
                    String sql = SqlProcedureEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlProcedureEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    if (SqlEngine.getMaxTimeout(sqlControl) != null) {
                        query.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
                    }
                    processResult.setQueryParams(session, query);
                    if (SqlProcedureEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlProcedureEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Integer run() {
                                return SqlProcedureEngine.this.callUpdate(query, processResult);
                            }
                        }, Integer.class);
                    }
                    return SqlProcedureEngine.this.callUpdate(query, processResult);
                }
            }, Integer.class);
            int n = count;
            return n;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< callUpdate, result=" + count);
            }
        }
    }

    private Integer callUpdate(SqlQuery query, SqlProcessResult processResult) {
        Integer count = query.callUpdate(processResult.getRuntimeContext());
        processResult.postProcess();
        return count;
    }

    public Object callFunction(SqlSession session, Object dynamicInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.callFunction(session, dynamicInputValues, null);
    }

    public Object callFunction(SqlSession session, Object dynamicInputValues, Object staticInputValues, int maxTimeout) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.callFunction(session, dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues).setMaxTimeout(maxTimeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(final SqlSession session, final Object dynamicInputValues, final SqlControl sqlControl) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> callFunction, session=" + session + ", dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        Object result = null;
        try {
            Object object = result = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public Object run() {
                    final SqlProcessResult processResult = SqlProcedureEngine.this.process(SqlMetaStatement.Type.CALL, dynamicInputValues, sqlControl);
                    String sql = SqlProcedureEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlProcedureEngine.this.name, processResult.getSql().toString());
                    final SqlQuery query = session.createSqlQuery(sql);
                    query.setLogError(processResult.isLogError());
                    if (SqlEngine.getMaxTimeout(sqlControl) != null) {
                        query.setTimeout(SqlEngine.getMaxTimeout(sqlControl));
                    }
                    processResult.setQueryParams(session, query);
                    if (SqlProcedureEngine.this.mapping != null) {
                        SqlMappingResult mappingResult = SqlMappingRule.merge(SqlProcedureEngine.this.mapping, processResult);
                        mappingResult.setQueryResultMapping(Object.class, null, query);
                    }
                    if (SqlProcedureEngine.this.monitor instanceof SqlExtendedMonitor) {
                        SqlExtendedMonitor monitorExt = (SqlExtendedMonitor)SqlProcedureEngine.this.monitor;
                        return monitorExt.runSql(new SqlMonitor.Runner(){

                            @Override
                            public Object run() {
                                return SqlProcedureEngine.this.callFunction(query, processResult);
                            }
                        }, Object.class);
                    }
                    return SqlProcedureEngine.this.callFunction(query, processResult);
                }
            }, Object.class);
            return object;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< callFunction, result=" + result);
            }
        }
    }

    private Object callFunction(SqlQuery query, SqlProcessResult processResult) {
        Object result = query.callFunction();
        processResult.postProcess();
        return result;
    }

    public String getCallSql(Object dynamicInputValues, Object staticInputValues) throws SqlProcessorException, SqlRuntimeException {
        return this.getSql(dynamicInputValues, staticInputValues, SqlMetaStatement.Type.CALL);
    }

    public String getSql(Object dynamicInputValues, Object staticInputValues, SqlMetaStatement.Type statementType) throws SqlProcessorException, SqlRuntimeException {
        this.checkStaticInputValues(staticInputValues);
        return this.getSql(dynamicInputValues, new SqlStandardControl().setStaticInputValues(staticInputValues), statementType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSql(final Object dynamicInputValues, final SqlControl sqlControl, final SqlMetaStatement.Type statementType) throws SqlProcessorException, SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> getSql, dynamicInputValues=" + dynamicInputValues + ", sqlControl=" + sqlControl);
        }
        this.checkDynamicInputValues(dynamicInputValues);
        String sql = null;
        try {
            String string = sql = this.monitor.run(new SqlMonitor.Runner(){

                @Override
                public String run() {
                    SqlProcessResult processResult = SqlProcedureEngine.this.process(statementType, dynamicInputValues, sqlControl);
                    String sql = SqlProcedureEngine.this.pluginFactory.getSqlExecutionPlugin().beforeSqlExecution(SqlProcedureEngine.this.name, processResult.getSql().toString());
                    return sql;
                }
            }, String.class);
            return string;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< getSql, sql=" + sql);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public SqlMonitor getMonitor() {
        return this.monitor;
    }
}

