/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlFeature;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.type.SqlMetaType;

class SqlType {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SqlMetaType metaType;
    private String value;

    SqlType() {
    }

    SqlType(SqlMetaType metaType) {
        this.metaType = metaType;
    }

    SqlMetaType getMetaType(SqlProcessContext ctx) {
        if (this.metaType == null) {
            return ctx.getTypeFactory().getDefaultType();
        }
        return this.metaType;
    }

    void setResult(SqlProcessContext ctx, Object resultInstance, String attributeName, Object resultValue) throws SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("setResult " + this.metaType + " " + attributeName + " " + resultValue);
        }
        this.getMetaType(ctx).setResult(ctx, resultInstance, attributeName, resultValue, ctx.isFeature(SqlFeature.IGNORE_INPROPER_OUT));
    }

    void setParameter(SqlProcessContext ctx, SqlQuery query, String paramName, Object inputValue, Class<?> inputType) throws SqlRuntimeException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("setParameter " + this.metaType + " " + paramName + " " + inputValue);
        }
        this.getMetaType(ctx).setParameter(ctx, query, paramName, inputValue, inputType, ctx.isFeature(SqlFeature.IGNORE_INPROPER_IN));
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SqlType[");
        if (this.metaType != null) {
            sb.append(" metaType=").append(this.metaType.toString());
        }
        sb.append(", value=").append(this.value);
        return sb.append("]").toString();
    }
}

