/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.SqlProviderType;

public abstract class SqlByteArrayType
extends SqlProviderType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{byte[].class, Byte[].class};
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"BYTEARR", "BYTEARRAY", "BYTES"};
    }

    @Override
    public void addScalar(SqlQuery query, String dbName, Class<?> attributeType) {
        query.addScalar(dbName, this.getProviderSqlType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue);
        }
        if (resultValue instanceof byte[]) {
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, resultValue, byte[].class)) {
                return;
            }
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, SqlUtils.toBytes((byte[])resultValue), Byte[].class)) {
                return;
            }
            if (!ingoreError) throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            return;
        } else {
            if (!(resultValue instanceof Byte[])) throw new RuntimeException("Incorrect binary array " + resultValue);
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, resultValue, Byte[].class)) {
                return;
            }
            if (!ingoreError) throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        }
    }

    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter " + this.getMetaTypes()[0] + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getProviderSqlNullType());
        } else if (inputValue instanceof byte[]) {
            query.setParameter(paramName, (byte[])inputValue, this.getProviderSqlType());
        } else if (inputValue instanceof Byte[]) {
            query.setParameter(paramName, SqlUtils.toBytes((Byte[])inputValue), this.getProviderSqlType());
        } else if (ingoreError) {
            this.logger.error("Incorrect binary array " + inputValue + " for " + paramName);
        } else {
            throw new SqlRuntimeException("Incorrect binary array " + inputValue + " for " + paramName);
        }
    }
}

