/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.impl.SqlMetaElement;
import org.sqlproc.engine.impl.SqlMetaSimple;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlProcessResult;

class SqlMetaOrd
implements SqlMetaElement {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    List<SqlMetaSimple> elements = new ArrayList<SqlMetaSimple>();
    String id = null;

    SqlMetaOrd(String id) {
        this.id = id;
    }

    void addElement(SqlMetaSimple element) {
        this.elements.add(element);
    }

    private StringBuilder process(StringBuilder sql, SqlOrder.Order orderDirrection) {
        String ss = sql.toString().trim();
        if (ss.toUpperCase().startsWith("ORDER")) {
            ss = ss.substring(5).trim();
        }
        if (ss.toUpperCase().startsWith("BY")) {
            ss = ss.substring(2).trim();
        }
        if (orderDirrection == SqlOrder.Order.ASC) {
            return new StringBuilder(ss).append(" ASC");
        }
        if (orderDirrection == SqlOrder.Order.DESC) {
            return new StringBuilder(ss).append(" DESC");
        }
        return new StringBuilder(ss);
    }

    @Override
    public SqlProcessResult process(SqlProcessContext ctx) {
        SqlProcessResult result = new SqlProcessResult(ctx);
        int orderIndex = ctx.getOrderIndex(this.id);
        if (orderIndex != -1) {
            result.addTrue();
            result.setOrderIndex(orderIndex);
            StringBuilder s = new StringBuilder();
            for (SqlMetaSimple item : this.elements) {
                SqlProcessResult itemResult = item.process(ctx);
                if (itemResult.isAdd()) {
                    s.append((CharSequence)itemResult.getSql());
                    result.addInputValues(itemResult.getInputValues());
                    result.addMappedInputValues(itemResult.getMappedInputValues());
                    continue;
                }
                result.addFalse();
            }
            result.setSql(this.process(s, ctx.getOrder(orderIndex)));
        } else {
            result.addFalse();
        }
        return result;
    }
}

