/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlDoubleType;

public class JdbcDoubleType
extends SqlDoubleType
implements JdbcSqlType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{Double.class, Double.TYPE};
    }

    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return 8;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        if (Character.isDigit(columnLabel.charAt(0))) {
            return new Double(rs.getDouble(Integer.parseInt(columnLabel)));
        }
        return new Double(rs.getDouble(columnLabel));
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        st.setDouble(index, (Double)value);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        Double result = cs.getDouble(index);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

