/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.type.OutValueSetter;
import org.sqlproc.engine.type.SqlDefaultType;

public abstract class SqlEnumIntegerType
extends SqlDefaultType {
    @Override
    public Class<?>[] getClassTypesForDefault() {
        return new Class[0];
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"EINTEGER", "EINT"};
    }

    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue);
        }
        Class<?> attributeType = runtimeCtx.getAttributeType(resultInstance.getClass(), attributeName);
        Object enumInstance = runtimeCtx.getValueToEnum(attributeType, resultValue);
        if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, enumInstance, attributeType)) {
            return;
        }
        if (!ingoreError) {
            throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        }
        this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, boolean ingoreError, Class<?> ... inputTypes) throws SqlRuntimeException {
        Object o;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter for META type " + this + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputTypes=" + inputTypes);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getProviderSqlType(), new Class[0]);
            return;
        }
        if (!inputValue.getClass().isEnum()) {
            if (!(inputValue instanceof Collection)) {
                if (inputValue instanceof OutValueSetter) {
                    query.setParameter(paramName, inputValue, this.getProviderSqlType(), new Class[0]);
                    return;
                }
                this.error(ingoreError, "Incorrect integer based enum " + inputValue + " for " + paramName);
                return;
            }
        } else {
            Object o2 = runtimeCtx.getEnumToValue(inputValue);
            if (o2 != null && o2 instanceof Integer) {
                query.setParameter(paramName, (Integer)o2, this.getProviderSqlType(), new Class[0]);
                return;
            }
            this.error(ingoreError, "Incorrect integer based enum value " + o2 + " for " + paramName);
            return;
        }
        ArrayList<Integer> vals = new ArrayList<Integer>();
        Iterator iter = ((Collection)inputValue).iterator();
        while (true) {
            if (!iter.hasNext()) {
                query.setParameterList(paramName, vals.toArray());
                return;
            }
            Object val = iter.next();
            if (!val.getClass().isEnum()) {
                this.error(ingoreError, "Incorrect integer based enum item " + val + " for " + paramName);
                return;
            }
            o = runtimeCtx.getEnumToValue(val);
            if (o == null || !(o instanceof Integer)) break;
            vals.add((Integer)o);
        }
        this.error(ingoreError, "Incorrect integer based enum item value " + o + " for " + paramName);
    }
}

