/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlByteType;

public class JdbcByteType
extends SqlByteType
implements JdbcSqlType {
    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return -6;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        if (Character.isDigit(columnLabel.charAt(0))) {
            return new Byte(rs.getByte(Integer.parseInt(columnLabel)));
        }
        return new Byte(rs.getByte(columnLabel));
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        st.setByte(index, (Byte)value);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        Byte result = cs.getByte(index);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

