/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.SqlDefaultType;

public abstract class SqlByteArrayType
extends SqlDefaultType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{byte[].class, Byte[].class};
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"BYTES"};
    }

    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        this.setResultEntryLog(this.logger, this, runtimeCtx, resultInstance, attributeName, resultValue, ingoreError);
        if (resultValue instanceof byte[]) {
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, resultValue, byte[].class)) {
                return;
            }
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, SqlUtils.toBytes((byte[])resultValue), Byte[].class)) {
                return;
            }
            this.error(this.logger, ingoreError, "There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this);
            return;
        }
        if (resultValue instanceof Byte[]) {
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, resultValue, Byte[].class)) {
                return;
            }
            this.error(this.logger, ingoreError, "There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this);
            return;
        }
        throw new RuntimeException("Incorrect binary array " + resultValue + ", META type is " + this);
    }

    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, boolean ingoreError, Class<?> ... inputTypes) throws SqlRuntimeException {
        this.setParameterEntryLog(this.logger, this, runtimeCtx, query, paramName, inputValue, ingoreError, inputTypes);
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getProviderSqlType(), new Class[0]);
        } else if (inputValue instanceof byte[]) {
            query.setParameter(paramName, (byte[])inputValue, this.getProviderSqlType(), new Class[0]);
        } else if (inputValue instanceof Byte[]) {
            query.setParameter(paramName, SqlUtils.toBytes((Byte[])inputValue), this.getProviderSqlType(), new Class[0]);
        } else {
            this.error(this.logger, ingoreError, "Incorrect binary array " + inputValue + " for " + paramName + ", META type is " + this);
            return;
        }
    }
}

