/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sqlproc.engine.SqlControl;
import org.sqlproc.engine.SqlOrder;
import org.sqlproc.engine.impl.SqlUtils;

public class SqlStandardControl
implements SqlControl {
    private Object staticInputValues;
    private Object dynamicUpdateValues;
    private Integer maxTimeout;
    private Integer firstResult;
    private Integer maxResults;
    private SqlOrder order;
    private Map<String, Class<?>> moreResultClasses;
    private Map<String, Object> features = new HashMap<String, Object>();
    private String processingId;
    private Integer fetchSize;
    private Boolean skipEmptyStatement;
    private SqlControl.LowLevelSqlCallback lowLevelSqlCallback;
    private SqlControl.SqlExecutionCallback sqlExecutionCallback;
    private String sqlName;

    public SqlStandardControl() {
    }

    public SqlStandardControl(SqlControl sqlControl) {
        if (sqlControl != null) {
            this.setStaticInputValues(sqlControl.getStaticInputValues());
            this.setDynamicUpdateValues(sqlControl.getDynamicUpdateValues());
            this.setFirstResult(sqlControl.getFirstResult());
            this.setMaxResults(sqlControl.getMaxResults());
            this.setMaxTimeout(sqlControl.getMaxTimeout());
            this.setMoreResultClasses(sqlControl.getMoreResultClasses());
            this.setOrder(sqlControl.getOrder());
            this.setFeatures(sqlControl.getFeatures());
            this.setProcessingId(sqlControl.getProcessingId());
            this.setFetchSize(sqlControl.getFetchSize());
            this.setLowLevelSqlCallback(sqlControl.getLowLevelSqlCallback());
            this.setSqlExecutionCallback(sqlControl.getSqlExecutionCallback());
        }
    }

    @Override
    public Object getStaticInputValues() {
        return this.staticInputValues;
    }

    public SqlStandardControl setStaticInputValues(Object staticInputValues) {
        this.staticInputValues = staticInputValues;
        return this;
    }

    @Override
    public Object getDynamicUpdateValues() {
        return this.dynamicUpdateValues;
    }

    public SqlStandardControl setDynamicUpdateValues(Object dynamicUpdateValues) {
        this.dynamicUpdateValues = dynamicUpdateValues;
        return this;
    }

    @Override
    public Integer getMaxTimeout() {
        return this.maxTimeout;
    }

    public SqlStandardControl setMaxTimeout(Integer maxTimeout) {
        this.maxTimeout = maxTimeout;
        return this;
    }

    @Override
    public Integer getFirstResult() {
        return this.firstResult;
    }

    public SqlStandardControl setFirstResult(Integer firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public Integer getMaxResults() {
        return this.maxResults;
    }

    public SqlStandardControl setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public SqlOrder getOrder() {
        return this.order;
    }

    public SqlStandardControl setOrder(SqlOrder order) {
        this.order = order;
        return this;
    }

    public SqlStandardControl setAscOrder(int order) {
        this.order = SqlOrder.getAscOrder(order);
        return this;
    }

    public SqlStandardControl setAscOrderNullsLast(int order) {
        this.order = SqlOrder.getAscOrderNullsLast(order);
        return this;
    }

    public SqlStandardControl setAscOrder(String order) {
        this.order = SqlOrder.getAscOrder(order);
        return this;
    }

    public SqlStandardControl setAscOrderNullsLast(String order) {
        this.order = SqlOrder.getAscOrderNullsLast(order);
        return this;
    }

    public SqlStandardControl setDescOrder(int order) {
        this.order = SqlOrder.getDescOrder(order);
        return this;
    }

    public SqlStandardControl setDescOrderNullsFirst(int order) {
        this.order = SqlOrder.getDescOrderNullsFirst(order);
        return this;
    }

    public SqlStandardControl setDescOrder(String order) {
        this.order = SqlOrder.getDescOrder(order);
        return this;
    }

    public SqlStandardControl setDescOrderNullsFirst(String order) {
        this.order = SqlOrder.getDescOrderNullsFirst(order);
        return this;
    }

    @Override
    public Map<String, Class<?>> getMoreResultClasses() {
        return this.moreResultClasses;
    }

    public SqlStandardControl setMoreResultClasses(Map<String, Class<?>> moreResultClasses) {
        this.moreResultClasses = moreResultClasses;
        return this;
    }

    @Override
    public Map<String, Object> getFeatures() {
        return this.features;
    }

    public SqlStandardControl setFeatures(Map<String, Object> features) {
        this.features = features;
        return this;
    }

    public SqlStandardControl setFeature(String name, Object value) {
        this.features.put(name, value);
        this.unsetFeatures(SqlUtils.oppositeFeatures(name));
        return this;
    }

    public SqlStandardControl unsetFeatures(Set<String> names) {
        if (names != null) {
            for (String name : names) {
                this.features.remove(name);
            }
        }
        return this;
    }

    @Override
    public String getProcessingId() {
        return this.processingId;
    }

    public SqlStandardControl setProcessingId(String processingId) {
        this.processingId = processingId;
        return this;
    }

    @Override
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public SqlStandardControl setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    @Override
    public Boolean getSkipEmptyStatement() {
        return this.skipEmptyStatement;
    }

    public void setSkipEmptyStatement(Boolean skipEmptyStatement) {
        this.skipEmptyStatement = skipEmptyStatement;
    }

    @Override
    public SqlControl.LowLevelSqlCallback getLowLevelSqlCallback() {
        return this.lowLevelSqlCallback;
    }

    public SqlStandardControl setLowLevelSqlCallback(SqlControl.LowLevelSqlCallback lowLevelSqlCallback) {
        this.lowLevelSqlCallback = lowLevelSqlCallback;
        return this;
    }

    @Override
    public SqlControl.SqlExecutionCallback getSqlExecutionCallback() {
        return this.sqlExecutionCallback;
    }

    public SqlStandardControl setSqlExecutionCallback(SqlControl.SqlExecutionCallback sqlExecutionCallback) {
        this.sqlExecutionCallback = sqlExecutionCallback;
        return this;
    }

    @Override
    public String getSqlName() {
        return this.sqlName;
    }

    public SqlStandardControl setSqlName(String sqlName) {
        this.sqlName = sqlName;
        return this;
    }

    public String toString() {
        return "SqlStandardControl [staticInputValues=" + String.valueOf(this.staticInputValues) + ", dynamicUpdateValues=" + String.valueOf(this.dynamicUpdateValues) + ", maxTimeout=" + this.maxTimeout + ", firstResult=" + this.firstResult + ", maxResults=" + this.maxResults + ", order=" + String.valueOf(this.order) + ", moreResultClasses=" + String.valueOf(this.moreResultClasses) + ", features=" + String.valueOf(this.features) + ", processingId=" + this.processingId + ", fetchSize=" + this.fetchSize + ", skipEmptyStatement=" + this.skipEmptyStatement + ", sqlName=" + this.sqlName + "]";
    }
}

