/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl.config.store;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJaxbStore {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String directory;
    private final String fileName;
    private final JAXBContext xmlContext;
    private final File file;

    public SimpleJaxbStore(String directory, String fileName, Class<?> ... jaxbClasses) throws IOException, JAXBException {
        this.directory = SimpleJaxbStore.substitute(directory);
        this.fileName = SimpleJaxbStore.substitute(fileName);
        this.xmlContext = JAXBContext.newInstance((Class[])jaxbClasses);
        File dir = new File(this.directory);
        dir.mkdirs();
        if (!dir.exists()) {
            throw new IOException("Could not create data directory: " + this.directory);
        }
        this.file = new File(dir, this.fileName);
    }

    static String substitute(String s) {
        int ix2;
        int ix = s.indexOf("${");
        int n = ix2 = ix >= 0 ? s.indexOf("}", ix) : -1;
        if (ix < 0 || ix2 < 0) {
            return s;
        }
        String toSubstitute = s.substring(ix + 2, ix + ix2);
        String substituted = System.getenv(toSubstitute);
        if (substituted == null) {
            substituted = System.getProperty(toSubstitute);
        }
        if (substituted == null) {
            return s;
        }
        String result = s.substring(0, ix) + substituted + s.substring(ix + ix2 + 1);
        return result;
    }

    public boolean writeXml(Object xml) {
        this.logger.warn(">>> writeXml file={}, dir={}", (Object)this.file, (Object)this.directory);
        if (this.file == null) {
            return false;
        }
        this.logger.warn("=== writeXml xml={}", xml);
        try {
            Marshaller marshaller = this.xmlContext.createMarshaller();
            marshaller.marshal(xml, this.file);
        }
        catch (JAXBException ex) {
            throw new IllegalStateException("Could not save configuration", ex);
        }
        this.logger.warn("<<< writeXml xmlContext={}", (Object)this.xmlContext);
        return true;
    }

    public Object readXml() {
        this.logger.warn(">>> readXml file={}, dir={}", (Object)this.file, (Object)this.directory);
        if (this.file == null || !this.file.exists()) {
            return null;
        }
        this.logger.warn("=== readXml xmlContext={}", (Object)this.xmlContext);
        Object xml = null;
        try {
            Unmarshaller unmarshaller = this.xmlContext.createUnmarshaller();
            xml = unmarshaller.unmarshal(this.file);
        }
        catch (JAXBException ex) {
            throw new IllegalStateException("Could not read configuration", ex);
        }
        this.logger.warn("<<< readXml xml={}", xml);
        return xml;
    }
}

