/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.commons.validator;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.validation.Errors;

public class Resources {
    private static Log log = LogFactory.getLog((Class)(class$org$springmodules$commons$validator$Resources == null ? (class$org$springmodules$commons$validator$Resources = Resources.class$("org.springmodules.commons.validator.Resources")) : class$org$springmodules$commons$validator$Resources));
    static /* synthetic */ Class class$org$springmodules$commons$validator$Resources;

    public static void rejectValue(Errors errors, Field field, ValidatorAction va) {
        String fieldCode = field.getKey();
        String errorCode = Resources.getMsgKey(va, field);
        Object[] args = Resources.getArgs(va, field);
        String defaultMsg = errorCode;
        log.debug((Object)("Rejecting value [field='" + fieldCode + "', errorCode='" + errorCode + "']"));
        errors.rejectValue(fieldCode, errorCode, args, defaultMsg);
    }

    public static String getMsgKey(ValidatorAction va, Field field) {
        return field.getMsg(va.getName()) != null ? field.getMsg(va.getName()) : va.getMsg();
    }

    public static Object[] getArgs(ValidatorAction va, Field field) {
        ArrayList<Object> args = new ArrayList<Object>();
        String actionName = va.getName();
        if (field.getArg(actionName, 0) != null) {
            args.add(0, Resources.getMessage(field.getArg(actionName, 0)));
        }
        if (field.getArg(actionName, 1) != null) {
            args.add(1, Resources.getMessage(field.getArg(actionName, 1)));
        }
        if (field.getArg(actionName, 2) != null) {
            args.add(2, Resources.getMessage(field.getArg(actionName, 2)));
        }
        if (field.getArg(actionName, 3) != null) {
            args.add(3, Resources.getMessage(field.getArg(actionName, 3)));
        }
        return args.toArray();
    }

    public static Object getMessage(Arg arg) {
        if (arg.isResource()) {
            return Resources.createMessage(arg.getKey());
        }
        return arg.getKey();
    }

    public static MessageSourceResolvable createMessage(Object obj) {
        String[] codes = new String[]{String.valueOf(obj)};
        String defaultMsg = codes[0];
        DefaultMessageSourceResolvable msg = new DefaultMessageSourceResolvable(codes, null, defaultMsg);
        return msg;
    }

    public static String getMessage(MessageSource messages, Locale locale, ValidatorAction va, Field field) {
        String code = Resources.getMsgKey(va, field);
        Object[] args = Resources.getArgs(va, field);
        String defaultMsg = code;
        return messages.getMessage(code, args, defaultMsg, locale);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

