package app.microkit.sdk
import kotlinx.coroutines.*

fun setInterval(timeMillis: Long, handler: () -> Unit) = GlobalScope.launch {
    while (true) {
        delay(timeMillis)
        handler()
    }
}
object NetworkController {

    val update = Publisher();
    fun getLatestData (): String {
        return HttpClient.makeRequest("init")
    }

    fun startUpdateInterval () {
        setInterval( Config.get("pollingInterval").toString().toLong(), fun () {
            val res = HttpClient.makeRequest("update")
            this.update.publish(res, "");
        })
    }
}