package app.microkit.sdk

import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.encodeToJsonElement

fun transformToJsonElement (element: Any): JsonElement {
    if (element is Boolean) {
        return Json.encodeToJsonElement(element);
    } else if (element is Int) {
        return Json.encodeToJsonElement(element);
    } else if (element is JsonElement) {
        return element;
    } else  {
        return Json.encodeToJsonElement(element.toString());
    }
}