package app.microkit.sdk

object Config  {

    val config = HashMap<String, Any>()

    fun init(options: HashMap<String, Any>) {
        this.config["baseUrl"] = if ("baseUrl" in options) options["baseUrl"] as String else (if ("base_url"  in options) options["base_url"] as String else "sdk.microkit.app");
        this.config["apiKey"] = if ("apiKey" in options) options["apiKey"] as String else "";
        this.config["port"] = if ("port" in options) options["port"] as String else "";
        this.config["http"] = if ("http" in options) options["http"] as Boolean else false;
        this.config["pollingInterval"] = if ("pollingInterval" in options) options["pollingInterval"] as Int else 30000;
        this.config["pollingOn"] = if ("pollingOn" in options) options["pollingOn"] as Boolean else true;
        this.config["service"] = if ("service" in options) options["service"] as String else "";
        this.config["user"] = if ("user" in options) options["user"] as HashMap<String, Any> else HashMap<String, Any>();
        this.validate()
    }

    private fun validate() {
        if (this.config["apiKey"] == "") {
            throw Exception("SDK key is required!!!")
        }
    }


    fun get (configName: String): Any? {
        return if (configName in this.config) this.config[configName] else null;
    }

    fun set (configName: String, value: Any) {
        this.config.put(configName, value);
    }
}