package app.microkit.sdk;

import kotlinx.serialization.Serializable
import kotlinx.serialization.json.*
import kotlin.jvm.JvmField

//@Serializable
//data class ItemValue<T>(val type: String, val value: T)

abstract class Item: Leaf{
    protected var item: Map<String, JsonElement>;
    protected var type: String;
    protected var name: String;
    constructor(value: JsonElement, name: String) {
        this.item = value.jsonObject.toMap();
        this.type =  this.cleanJsonSting(this.item["type"].toString());
        this.name = name;
    }

    override fun update(item: Any, inti: Boolean) {
        val value = (item as JsonElement).jsonObject.toMap();
        val changed = this.item["type"] != value["type"] || this.item["value"] != value["value"] ;

        val prevItem = this.item;
        this.item = value;
        this.type =  this.cleanJsonSting(value["type"].toString());

        if (changed) {
            this.change.publish(this.getItemValue(this.item), this.getItemValue(prevItem))
        }
    }

    override fun getValue(): Any {
        return getItemValue(this.item);
    }

    fun getBoolValue () : Boolean {
        return this.getValue() as Boolean;
    }

    fun getStringValue () : String {
        return this.getValue() as String;
    }

    fun getIntValue () : Int {
        return (this.getValue() as Double).toInt();
    }

    fun getDoubleValue () : Double {
        return this.getValue() as Double;
    }

    abstract fun getValue(user: HashMap<String, Any>): Any

    abstract fun getBoolValue(user: HashMap<String, Any>): Any

    abstract fun getStringValue(user: HashMap<String, Any>): Any

    abstract fun getIntValue(user: HashMap<String, Any>): Any

    abstract fun getDoubleValue(user: HashMap<String, Any>): Any


    protected fun getItemValue (item: Map<String, JsonElement>): Any {
        // TODO refactor if else to be when
        if (this.type == "string") {
            return  this.cleanJsonSting(item["value"].toString());
        } else if (this.type == "boolean") {
            if ( this.cleanJsonSting(item["value"].toString()) == "true") {
                return true;
            }
            return false;
        } else if (this.type == "number") {
            return  this.cleanJsonSting(item["value"].toString()).toDouble();
        }
        return item["value"] as Any;
    }

    private fun cleanJsonSting (str: String): String {
        if (str.get(0) == '"') {
            return str.drop(1).dropLast(1)
        } else {
            return str;
        }
    }
}