package app.microkit.sdk;


data class Subscription(val unsubscribe: () -> Unit);
class Publisher{
    private val subscribers: HashMap<String, (currentValue: Any, prevValue:Any)-> Unit> = HashMap<String, (currentValue: Any, prevValue:Any)-> Unit >()


    fun subscribe (handelr: (currentValue: Any, prevValue:Any)->Unit): Subscription {
        val key = this.getRandomString(10)
        this.subscribers[key] = handelr;
        return Subscription(fun (): Unit { this.subscribers.remove(key) });
    }

    fun publish (currentValue: Any, prevValue:Any) {
        subscribers.forEach { (key, handler) -> handler(currentValue, prevValue) }
    }

    private fun getRandomString(length: Int) : String {
        val allowedChars = ('A'..'Z') + ('a'..'z') + ('0'..'9')
        return (1..length)
            .map { allowedChars.random() }
            .joinToString("")
    }
}