package app.microkit.sdk
import kotlinx.coroutines.*
import kotlin.concurrent.thread


//import kotlinx.coroutines.Dispatchers.Main
 fun setInterval(timeMillis: Long, handler: () -> Unit, microkit: MicroKit) {
    thread {
        while (!microkit.closed) {
            Thread.sleep(timeMillis)
            handler()
        }
    }

}
actual object NetworkController {

    actual val update = Publisher();
    actual fun getLatestData (): String {
        return HttpClient.makeRequest("init")
    }

    actual fun startUpdateInterval (microkit: MicroKit) {
        setInterval( Config.get("pollingInterval").toString().toLong(), fun () {
            val res = HttpClient.makeRequest("update")
            this.update.publish(res, "");
        }, microkit)
    }
}