package app.microkit.sdk;

import java.net.URI
import java.net.URLEncoder
import java.net.http.HttpClient
import java.net.http.HttpRequest
import java.net.http.HttpResponse

import kotlinx.serialization.*
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.encodeToJsonElement
import kotlinx.serialization.json.jsonObject
import java.util.Objects

@Serializable
data class RequestBody(val lang: String, val options: Options)

@Serializable
data class Options(val service: String)

actual object HttpClient {

    actual fun makeRequest (action: String, path: String, data: HashMap<String, Any>, method: String): String {
        val options = Json.encodeToJsonElement(Options.serializer(), Options(Config.get("service") as String)).jsonObject;
        data.put("lang", "java");
        data.put("options", options);
        if (Config.get("key_vars_values") != null) {
            data.put("key_vars_values", Config.get("key_vars_values") as Any)
        }


        val queryMap = data.mapValues {transformToJsonElement(it.value)}

        val token = Config.get("apiKey") as String;
        val client = HttpClient.newBuilder().build();
        val request = HttpRequest.newBuilder()
            .uri(URI.create("${if(!(Config.get("http") as Boolean)) "https://" else "http://"}${Config.get("baseUrl") as String}${if (Config.get("port") != "") ":${Config.get("port")}" else ""}/v1/$path"))
            .POST(HttpRequest.BodyPublishers.ofString(this.cleanNestedJsonString(Json.encodeToJsonElement(queryMap).toString())))
            .header("Content-Type", "application/json")
            .header("Authorization", "Bearer $token")
            .build()
        val response = client.send(request, HttpResponse.BodyHandlers.ofString());
       return response.body()
    }



    private fun cleanNestedJsonString (str: String) : String {
        return str.replace("\\", "").replace("\"{", "{").replace("}\"", "}")
    }




}
