package app.microkit.sdk

import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.jsonObject
import kotlin.jvm.JvmStatic


actual object MicroKit {
    @JvmField
    actual  val configKit = Group("config" , HashMap<String, JsonElement>() )
    @JvmField
    val featureKit = Group("features" , HashMap<String, JsonElement>() )
    actual var closed = false

    @JvmStatic
    actual fun initializeKit (key: String, user: HashMap<String, Any>, options: HashMap<String, Any>): MicroKit {
        val decryptKeyLength = 24;
        options["user"] = user;
        options["apiKey"] = key.take(key.length - (decryptKeyLength + 1));
        val decryptKey = key.takeLast(decryptKeyLength)

        Config.init(options)
        val res = NetworkController.getLatestData();

        val data = Json.parseToJsonElement(res).jsonObject.toMap()

        Config.set("key_vars_values", data["key_vars_values"] as Any)

        val decrypted = decrypt(this.cleanJsonSting(data["config"].toString()), decryptKey)
        this.configKit.update(Json.parseToJsonElement(decrypted).jsonObject.toMap(), true)
        this.featureKit.update(Json.parseToJsonElement(data["features"].toString()).jsonObject.toMap(), true)
        if (Config.get("pollingOn") as Boolean) {
            NetworkController.startUpdateInterval(this)
            NetworkController.update.subscribe(fun (current: Any, prev: Any) {
                val data = Json.parseToJsonElement(current as String).jsonObject.toMap()
                val decrypted = decrypt(this.cleanJsonSting(data["config"].toString()), decryptKey)
                this.configKit.update(Json.parseToJsonElement(decrypted).jsonObject.toMap())
            })
        }


        return MicroKit;
    }

    fun close () {
        this.closed = true
        this.featureKit.clear()
        this.configKit.clear()
    }


    @JvmStatic
    actual fun kitReady (): MicroKit {
        return MicroKit;
    }

    actual  fun cleanJsonSting (str: String): String {
        if (str.get(0) == '"') {
            return str.drop(1).dropLast(1)
        } else {
            return str;
        }
    }
}