/*
 * Decompiled with CFR 0.152.
 */
package app.microkit.sdk;

import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u00a8\u0006\u0004"}, d2={"decrypt", "", "dataToDecryptB64", "key", "microkit-java-server-sdk"})
public final class DecryptKt {
    @NotNull
    public static final String decrypt(@NotNull String dataToDecryptB64, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)dataToDecryptB64, (String)"dataToDecryptB64");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] dataToDecrypt = Base64.getMimeDecoder().decode(dataToDecryptB64);
        byte[] ivBytes = new byte[16];
        byte[] cipherBytes = new byte[dataToDecrypt.length - ivBytes.length];
        System.arraycopy(dataToDecrypt, 0, ivBytes, 0, ivBytes.length);
        System.arraycopy(dataToDecrypt, ivBytes.length, cipherBytes, 0, cipherBytes.length);
        byte[] keyBytes = Base64.getMimeDecoder().decode(key);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
        cipher.init(2, (Key)new SecretKeySpec(keyBytes, "AES"), new IvParameterSpec(ivBytes));
        byte[] cipherText = cipher.doFinal(cipherBytes);
        Intrinsics.checkNotNullExpressionValue((Object)cipherText, (String)"cipherText");
        return new String(cipherText, Charsets.ISO_8859_1);
    }
}

