/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.document;

import cloud.codestore.jsonapi.JsonApiObjectMapper;
import cloud.codestore.jsonapi.document.JsonApiObject;
import cloud.codestore.jsonapi.document.ResourceCollectionDocument;
import cloud.codestore.jsonapi.document.SingleResourceDocument;
import cloud.codestore.jsonapi.internal.JsonApiDocumentDeserializer;
import cloud.codestore.jsonapi.link.Link;
import cloud.codestore.jsonapi.link.LinksObject;
import cloud.codestore.jsonapi.meta.MetaInformation;
import cloud.codestore.jsonapi.resource.ResourceObject;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"jsonapi", "data", "included", "links", "meta"})
@JsonDeserialize(using=JsonApiDocumentDeserializer.class)
public abstract class JsonApiDocument {
    public static final String MEDIA_TYPE = "application/vnd.api+json";
    private JsonApiObject jsonapi;
    private List<ResourceObject> includedResources = new LinkedList<ResourceObject>();
    private LinksObject links = new LinksObject();
    private MetaInformation meta;

    public static <T extends ResourceObject> JsonApiDocument of(T data) {
        return new SingleResourceDocument<T>(data);
    }

    public static <T extends ResourceObject> JsonApiDocument of(T[] data) {
        return new ResourceCollectionDocument(data);
    }

    public static JsonApiDocument of(MetaInformation meta) {
        return new SingleResourceDocument(meta);
    }

    @JsonSetter(value="jsonapi")
    public JsonApiDocument setJsonapiObject(JsonApiObject jsonapi) {
        this.jsonapi = jsonapi;
        return this;
    }

    @JsonGetter(value="jsonapi")
    public JsonApiObject getJsonApiObject() {
        return this.jsonapi;
    }

    @JsonGetter(value="included")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<ResourceObject> getIncludedResources() {
        return Collections.unmodifiableList(this.includedResources);
    }

    public JsonApiDocument setSelfLink(String self) {
        return this.addLink(new Link("self", self));
    }

    public JsonApiDocument addLink(Link link) {
        this.links.add(link);
        return this;
    }

    @JsonGetter(value="links")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_EMPTY)
    public LinksObject getLinks() {
        return this.links;
    }

    @JsonSetter(value="meta")
    public JsonApiDocument setMeta(MetaInformation meta) {
        this.meta = meta;
        return this;
    }

    @JsonGetter(value="meta")
    public MetaInformation getMeta() {
        return this.meta;
    }

    public String toJson() throws JsonProcessingException {
        return new JsonApiObjectMapper().writeValueAsString(this);
    }

    public void include(ResourceObject ... resourceObjects) {
        Objects.requireNonNull(resourceObjects);
        for (ResourceObject resourceObject : resourceObjects) {
            Objects.requireNonNull(resourceObject);
            if (this.alreadyIncluded(resourceObject)) continue;
            this.includedResources.add(resourceObject);
        }
    }

    private boolean alreadyIncluded(ResourceObject resourceToInclude) {
        for (ResourceObject includedResource : this.includedResources) {
            if (!Objects.equals(includedResource.getIdentifier(), resourceToInclude.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    @JsonSetter(value="included")
    void setIncludedResources(List<ResourceObject> includedResources) {
        this.includedResources = includedResources;
    }

    @JsonSetter(value="links")
    void setLinksObject(LinksObject links) {
        this.links = links;
    }
}

