/*
 * Decompiled with CFR 0.152.
 */
package cloud.codestore.jsonapi.error;

import cloud.codestore.jsonapi.error.ErrorObject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Objects;

public class ErrorDocument {
    private ErrorObject[] errors;

    @JsonCreator
    ErrorDocument() {
    }

    public ErrorDocument(ErrorObject error) {
        Objects.requireNonNull(error);
        this.errors = new ErrorObject[]{error};
    }

    public ErrorDocument(ErrorObject[] errors) {
        if (errors == null || errors.length == 0) {
            throw new IllegalArgumentException("An error document must contain at least one error object.");
        }
        this.errors = errors;
    }

    @JsonGetter(value="errors")
    public ErrorObject[] getErrors() {
        return this.errors;
    }

    @JsonSetter(value="errors")
    void setErrors(ErrorObject[] errors) {
        this.errors = errors;
    }

    public String toJson() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper.writeValueAsString((Object)this);
    }
}

